/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.general.PacketChat;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class PartBarrel
extends APart
implements IFluidTank,
IFluidHandler {
    private FluidTankInfo tankInfo;
    private final FluidTankInfo emptyTankInfo;

    public PartBarrel(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.emptyTankInfo = new FluidTankInfo(null, this.pack.barrel.capacity);
        this.tankInfo = dataTag.func_74764_b("FluidName") ? new FluidTankInfo(FluidStack.loadFluidStackFromNBT((NBTTagCompound)dataTag), this.emptyTankInfo.capacity) : this.emptyTankInfo;
    }

    @Override
    public boolean interactPart(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            if (!this.vehicle.locked) {
                ItemStack stack = player.func_184614_ca();
                if (stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                    IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (player.func_70093_af()) {
                        if (this.getFluid() != null) {
                            this.drain(handler.fill(this.getFluid(), true), true);
                        }
                    } else if (this.getFluid() != null) {
                        this.fill(handler.drain(new FluidStack(this.getFluid().getFluid(), this.getCapacity() - this.getFluidAmount()), true), true);
                    } else {
                        this.fill(handler.drain(this.getCapacity() - this.getFluidAmount(), true), true);
                    }
                    return true;
                }
            } else {
                MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.failure.vehiclelocked"), (EntityPlayerMP)player);
            }
        }
        return true;
    }

    @Override
    public NBTTagCompound getPartNBTTag() {
        NBTTagCompound dataTag = new NBTTagCompound();
        if (this.tankInfo.fluid != null) {
            this.tankInfo.fluid.writeToNBT(dataTag);
        }
        return dataTag;
    }

    @Override
    public float getWidth() {
        return 1.0f;
    }

    @Override
    public float getHeight() {
        return 1.0f;
    }

    public IFluidTankProperties[] getTankProperties() {
        return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{this.tankInfo});
    }

    public FluidStack getFluid() {
        return this.tankInfo.fluid;
    }

    public int getFluidAmount() {
        return this.tankInfo.fluid != null ? this.tankInfo.fluid.amount : 0;
    }

    public int getCapacity() {
        return this.tankInfo.capacity;
    }

    public FluidTankInfo getInfo() {
        return this.tankInfo;
    }

    public int fill(FluidStack stack, boolean doFill) {
        if (stack != null && (this.tankInfo.fluid == null || stack.isFluidEqual(this.tankInfo.fluid))) {
            int amountAbleToFill = this.tankInfo.capacity - (this.tankInfo.fluid != null ? this.tankInfo.fluid.amount : 0);
            int amountToFill = Math.min(amountAbleToFill, stack.amount);
            if (doFill) {
                if (this.tankInfo.fluid == null) {
                    this.tankInfo = new FluidTankInfo(new FluidStack(stack.getFluid(), 0), this.emptyTankInfo.capacity);
                }
                this.tankInfo.fluid.amount += amountToFill;
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.tankInfo.fluid, this.vehicle.field_70170_p, this.vehicle.func_180425_c(), (IFluidTank)this, amountToFill));
            }
            return amountToFill;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.getFluid() != null ? this.drain(new FluidStack(this.getFluid(), maxDrain), doDrain) : null;
    }

    public FluidStack drain(FluidStack stack, boolean doDrain) {
        if (this.getFluid() != null && this.getFluid().getFluid().equals(stack.getFluid())) {
            int amountToDrain = Math.max(this.getFluidAmount(), stack.amount);
            if (doDrain) {
                this.tankInfo.fluid.amount -= amountToDrain;
                if (this.tankInfo.fluid.amount == 0) {
                    this.tankInfo = this.emptyTankInfo;
                }
            }
            FluidStack returnStack = new FluidStack(stack.getFluid(), amountToDrain);
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(returnStack, this.vehicle.field_70170_p, this.vehicle.func_180425_c(), (IFluidTank)this, amountToDrain));
            return returnStack;
        }
        return null;
    }
}

