/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;
import net.minecraft.nbt.NBTTagCompound;

public class PartEngineAircraft
extends APartEngine {
    public PartPropeller propeller;
    private final EntityVehicleF_Plane plane;

    public PartEngineAircraft(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.plane = (EntityVehicleF_Plane)vehicle;
    }

    @Override
    public void updatePart() {
        super.updatePart();
        if (this.propeller == null) {
            if (!this.childParts.isEmpty()) {
                this.propeller = (PartPropeller)this.childParts.get(0);
            }
        } else if (this.childParts.isEmpty()) {
            this.propeller = null;
        }
        if (this.state.running) {
            double engineTargetRPM = (double)((float)this.plane.throttle / 100.0f) * ((double)this.pack.engine.maxRPM - (double)this.engineStartRPM * 1.25 - this.hours) + (double)this.engineStartRPM * 1.25;
            double engineRPMDifference = engineTargetRPM - this.RPM;
            if (this.propeller != null) {
                double propellerForcePenalty = (float)(this.propeller.pack.propeller.diameter - 75) / (50.0f * this.pack.engine.fuelConsumption - 15.0f);
                double propellerFeedback = -(this.plane.velocity - 0.0254 * (double)Math.abs(this.propeller.currentPitch) * this.RPM * (double)this.pack.engine.gearRatios[0] / 60.0 / 20.0 - propellerForcePenalty) * 25.0;
                this.RPM += engineRPMDifference / 10.0 - propellerFeedback;
            } else {
                this.RPM += engineRPMDifference / 10.0;
            }
        } else {
            this.RPM = this.propeller != null ? Math.max(this.RPM + (this.plane.velocity - 0.0254 * (double)Math.abs(this.propeller.currentPitch) * this.RPM * (double)this.pack.engine.gearRatios[0] / 60.0 / 20.0) * 15.0 - 10.0, 0.0) : Math.max(this.RPM - 10.0, 0.0);
        }
        this.engineRotationLast = this.engineRotation;
        this.engineRotation += 360.0 * this.RPM / 1200.0;
        this.engineDriveshaftRotationLast = this.engineDriveshaftRotation;
        this.engineDriveshaftRotation += 360.0 * this.RPM / 1200.0 * (double)this.pack.engine.gearRatios[0];
    }

    @Override
    public double getForceOutput() {
        if (this.propeller != null && this.propeller.currentPitch != 0 && this.state.running) {
            double currentPitchVelocity = this.vehicle.velocity * 20.0;
            double effectivePitchVelocity = 0.0254 * (double)this.propeller.currentPitch * this.RPM * (double)this.pack.engine.gearRatios[0] / 60.0;
            if ((effectivePitchVelocity *= (1.0 * (double)this.propeller.currentPitch / (double)this.propeller.pack.propeller.diameter + 0.2) / (1.0 * (double)this.propeller.currentPitch / (double)this.propeller.pack.propeller.diameter)) != 0.0) {
                double angleOfAttack = Math.abs(effectivePitchVelocity - currentPitchVelocity);
                return this.vehicle.airDensity * Math.PI * Math.pow(0.0254 * (double)this.propeller.pack.propeller.diameter / 2.0, 2.0) * (effectivePitchVelocity * effectivePitchVelocity - effectivePitchVelocity * currentPitchVelocity) * Math.pow((double)this.propeller.pack.propeller.diameter / 2.0 / (double)Math.abs(this.propeller.currentPitch) + (double)this.propeller.pack.propeller.numberBlades / 1000.0, 1.5) / 400.0 * (angleOfAttack > 35.0 ? 35.0 / angleOfAttack : 1.0) * Math.signum(effectivePitchVelocity);
            }
        }
        return 0.0;
    }

    @Override
    public void setElectricStarterStatus(boolean engaged) {
        super.setElectricStarterStatus(engaged);
        if (engaged && this.vehicle.throttle < 10) {
            this.vehicle.throttle = (byte)10;
        }
    }
}

