/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import minecrafttransportsimulator.vehicles.parts.APartGroundDevice;
import net.minecraft.nbt.NBTTagCompound;

public class PartEngineCar
extends APartEngine {
    public byte currentGear;
    private double engineForce;
    private final EntityVehicleF_Car car;

    public PartEngineCar(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.car = (EntityVehicleF_Car)vehicle;
        this.currentGear = dataTag.func_74771_c("gearNumber");
    }

    @Override
    public void updatePart() {
        super.updatePart();
        float lowestSpeed = 999.0f;
        float vehicleDesiredSpeed = -999.0f;
        if (this.currentGear != 0) {
            for (APartGroundDevice aPartGroundDevice : this.car.wheels) {
                if (!(aPartGroundDevice.offset.field_72449_c > 0.0 && this.car.pack.car.isFrontWheelDrive) && (!(aPartGroundDevice.offset.field_72449_c <= 0.0) || !this.car.pack.car.isRearWheelDrive) || !aPartGroundDevice.isOnGround() && this.car.groundedWheels.size() != 0) continue;
                lowestSpeed = Math.min(aPartGroundDevice.angularVelocity, lowestSpeed);
                vehicleDesiredSpeed = (float)Math.max(this.car.velocity / (double)aPartGroundDevice.getHeight(), (double)vehicleDesiredSpeed);
            }
            if (lowestSpeed != 999.0f) {
                this.RPM = lowestSpeed * 1200.0f * this.getRatioForCurrentGear() * this.car.pack.car.axleRatio > this.engineStallRPM || !this.state.running && !this.state.esOn ? (double)(lowestSpeed * 1200.0f * this.getRatioForCurrentGear() * this.car.pack.car.axleRatio) : (this.RPM -= (this.RPM - (double)this.engineStallRPM) / 10.0);
            }
        }
        if (this.state.running && this.pack.engine.isAutomatic && this.currentGear > 0) {
            if (this.RPM > (double)((float)PartEngineCar.getSafeRPMFromMax(this.pack.engine.maxRPM) * 0.5f * (1.0f + (float)this.car.throttle / 100.0f))) {
                this.shiftUp(false);
            } else if (this.RPM < (double)PartEngineCar.getSafeRPMFromMax(this.pack.engine.maxRPM) * 0.25 * (double)(1.0f + (float)this.car.throttle / 100.0f) && this.currentGear > 1) {
                this.shiftDown(false);
            }
        }
        float wheelFriction = 0.0f;
        for (APartGroundDevice wheel : this.car.groundedWheels) {
            if (!(wheel.offset.field_72449_c > 0.0 && this.car.pack.car.isFrontWheelDrive) && (!(wheel.offset.field_72449_c <= 0.0) || !this.car.pack.car.isRearWheelDrive)) continue;
            wheelFriction += wheel.getMotiveFriction() - wheel.getFrictionLoss();
        }
        if (this.state.running && this.currentGear == -1 && this.car.pack != null && this.car.pack.car.isBigTruck && this.car.electricPower > 4.0 && this.car.field_70170_p.func_82737_E() % 20L == 1L && this.vehicle.field_70170_p.field_72995_K) {
            MTS.proxy.playSound(this.vehicle.func_174791_d(), "mts:backup_beeper", 1.0f, 1.0f);
        }
        if (this.state.running || this.state.esOn) {
            double d = (double)((float)this.car.throttle / 100.0f) * ((double)this.pack.engine.maxRPM - (double)this.engineStartRPM / 1.25 - this.hours) + (double)this.engineStartRPM / 1.25;
            if (this.getRatioForCurrentGear() != 0.0f && this.car.wheels.size() > 0) {
                this.engineForce = (d - this.RPM) / (double)this.pack.engine.maxRPM * (double)this.getRatioForCurrentGear() * (double)this.car.pack.car.axleRatio * (double)this.pack.engine.fuelConsumption * (double)0.6f;
                if (Math.abs(this.engineForce / 10.0) > (double)wheelFriction || (double)(Math.abs(lowestSpeed) - Math.abs(vehicleDesiredSpeed)) > 0.1 && (double)(Math.abs(lowestSpeed) - Math.abs(vehicleDesiredSpeed)) < Math.abs(this.engineForce / 10.0)) {
                    this.engineForce *= this.car.currentMass / 100000.0 * (double)wheelFriction / Math.abs(this.engineForce / 10.0);
                    for (APartGroundDevice wheel : this.car.wheels) {
                        if (!(wheel.offset.field_72449_c > 0.0 && this.car.pack.car.isFrontWheelDrive) && (!(wheel.offset.field_72449_c <= 0.0) || !this.car.pack.car.isRearWheelDrive)) continue;
                        wheel.angularVelocity = this.getRatioForCurrentGear() > 0.0f ? (this.engineForce >= 0.0 ? (float)Math.min(d / 1200.0 / (double)this.getRatioForCurrentGear() / (double)this.car.pack.car.axleRatio, (double)wheel.angularVelocity + 0.01) : (float)Math.min(d / 1200.0 / (double)this.getRatioForCurrentGear() / (double)this.car.pack.car.axleRatio, (double)wheel.angularVelocity - 0.01)) : (this.engineForce >= 0.0 ? (float)Math.max(d / 1200.0 / (double)this.getRatioForCurrentGear() / (double)this.car.pack.car.axleRatio, (double)wheel.angularVelocity - 0.01) : (float)Math.max(d / 1200.0 / (double)this.getRatioForCurrentGear() / (double)this.car.pack.car.axleRatio, (double)wheel.angularVelocity + 0.01));
                        wheel.skipAngularCalcs = true;
                    }
                } else {
                    for (APartGroundDevice wheel : this.car.wheels) {
                        wheel.skipAngularCalcs = false;
                        if (wheel.isOnGround() || !(wheel.offset.field_72449_c > 0.0 && this.car.pack.car.isFrontWheelDrive) && (!(wheel.offset.field_72449_c <= 0.0) || !this.car.pack.car.isRearWheelDrive)) continue;
                        wheel.angularVelocity = lowestSpeed;
                    }
                }
                if (this.engineForce < 0.0 && this.currentGear > 0 && this.car.velocity < 0.25 || this.engineForce > 0.0 && this.currentGear < 0 && this.car.velocity > -0.25) {
                    this.engineForce = 0.0;
                }
            } else {
                for (APartGroundDevice wheel : this.car.wheels) {
                    wheel.skipAngularCalcs = false;
                }
                this.RPM += (d - this.RPM) / 10.0;
                if (this.RPM > (double)PartEngineCar.getSafeRPMFromMax(this.pack.engine.maxRPM)) {
                    this.RPM -= Math.abs(d - this.RPM) / 5.0;
                }
                this.engineForce = 0.0;
            }
        } else if (this.currentGear != 0) {
            this.engineForce = -this.RPM / (double)this.pack.engine.maxRPM * (double)Math.signum(this.currentGear);
        } else {
            this.engineForce = 0.0;
            this.RPM = Math.max(this.RPM - 10.0, 0.0);
        }
        this.engineRotationLast = this.engineRotation;
        this.engineRotation += 360.0 * this.RPM / 1200.0;
        float f = -999.0f;
        for (APartGroundDevice wheel : this.car.wheels) {
            if (!(wheel.offset.field_72449_c > 0.0 && this.car.pack.car.isFrontWheelDrive) && (!(wheel.offset.field_72449_c <= 0.0) || !this.car.pack.car.isRearWheelDrive)) continue;
            f = Math.max(Math.abs(wheel.angularVelocity), f);
        }
        f = (float)(this.vehicle.speedFactor * (double)f * Math.signum(this.car.velocity) * 360.0);
        this.engineDriveshaftRotationLast = this.engineDriveshaftRotation;
        this.engineDriveshaftRotation += (double)f;
    }

    @Override
    public void removePart() {
        super.removePart();
        for (APartGroundDevice wheel : this.car.wheels) {
            if (wheel.isOnGround() || !(wheel.offset.field_72449_c > 0.0 && this.car.pack.car.isFrontWheelDrive) && (!(wheel.offset.field_72449_c <= 0.0) || !this.car.pack.car.isRearWheelDrive)) continue;
            wheel.skipAngularCalcs = false;
        }
    }

    @Override
    public NBTTagCompound getPartNBTTag() {
        NBTTagCompound dataTag = super.getPartNBTTag();
        dataTag.func_74774_a("gearNumber", this.currentGear);
        return dataTag;
    }

    private float getRatioForCurrentGear() {
        return this.currentGear == -1 ? this.pack.engine.gearRatios[0] : (this.currentGear > 0 ? this.pack.engine.gearRatios[this.currentGear + 1] : 0.0f);
    }

    public float getGearshiftRotation() {
        return this.pack.engine.isAutomatic ? (float)Math.min(1, this.currentGear) * 15.0f : (float)(this.currentGear * 5);
    }

    @Override
    public double getForceOutput() {
        return this.engineForce * 30.0;
    }

    public void shiftUp(boolean packet) {
        if (this.currentGear == -1) {
            this.currentGear = 0;
        } else if (this.currentGear == 0) {
            if (this.car.velocity > -0.1) {
                this.currentGear = 1;
            } else if (this.vehicle.field_70170_p.field_72995_K) {
                MTS.proxy.playSound(this.partPos, "mts:engine_shifting_grinding", 1.0f, 1.0f);
            }
        } else if (this.currentGear < this.pack.engine.gearRatios.length - 2) {
            this.currentGear = this.pack.engine.isAutomatic && packet ? (byte)1 : (byte)(this.currentGear + 1);
        }
    }

    public void shiftDown(boolean packet) {
        if (this.currentGear > 0) {
            this.currentGear = this.pack.engine.isAutomatic && packet ? (byte)0 : (byte)(this.currentGear - 1);
        } else if (this.currentGear == 0) {
            if (this.car.velocity < 0.1) {
                this.currentGear = (byte)-1;
            } else if (this.vehicle.field_70170_p.field_72995_K) {
                MTS.proxy.playSound(this.partPos, "mts:engine_shifting_grinding", 1.0f, 1.0f);
            }
        }
    }
}

