/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.DamageSources;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.parts.PacketPartEngineSignal;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngineAircraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PartPropeller
extends APart {
    public float angularPosition;
    public float angularVelocity;
    public float damage;
    public short currentPitch;
    private final PartEngineAircraft connectedEngine;

    public PartPropeller(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.damage = dataTag.func_74760_g("damage");
        this.currentPitch = this.pack.propeller.pitch;
        this.connectedEngine = (PartEngineAircraft)this.parentPart;
    }

    @Override
    public void attackPart(DamageSource source, float damage) {
        EntityPlayer player;
        if (source.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)source.func_76346_g()).func_184614_ca() == null) {
            if (!this.vehicle.equals(player.func_184187_bx())) {
                this.connectedEngine.handStartEngine();
                MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineSignal(this.connectedEngine, PacketPartEngineSignal.PacketEngineTypes.HS_ON));
            }
            return;
        }
        this.damagePropeller(damage);
    }

    @Override
    public void updatePart() {
        super.updatePart();
        if (this.pack.propeller.isDynamicPitch) {
            if (((EntityVehicleF_Plane)this.vehicle).reverseThrust && this.currentPitch > -45) {
                this.currentPitch = (short)(this.currentPitch - 1);
            } else if (!((EntityVehicleF_Plane)this.vehicle).reverseThrust && this.currentPitch < 45) {
                this.currentPitch = (short)(this.currentPitch + 1);
            } else if (this.connectedEngine.RPM < (double)this.connectedEngine.pack.engine.maxRPM * 0.8 && this.currentPitch > 45) {
                this.currentPitch = (short)(this.currentPitch - 1);
            } else if (this.connectedEngine.RPM > (double)this.connectedEngine.pack.engine.maxRPM * 0.85 && this.currentPitch < this.pack.propeller.pitch) {
                this.currentPitch = (short)(this.currentPitch + 1);
            }
        }
        if (this.vehicle.field_70170_p.field_72995_K) {
            this.angularVelocity = (float)(360.0 * this.connectedEngine.RPM * (double)this.connectedEngine.pack.engine.gearRatios[0] / 60.0 / 20.0);
            this.angularPosition += this.angularVelocity;
        } else if (this.connectedEngine.RPM >= 100.0) {
            List collidedEntites = this.vehicle.field_70170_p.func_72872_a(EntityLivingBase.class, this.getAABBWithOffset(Vec3d.field_186680_a).func_72314_b(0.2f, 0.2f, 0.2f));
            if (!collidedEntites.isEmpty()) {
                Entity attacker = null;
                for (Entity passenger : this.vehicle.func_184188_bt()) {
                    if (!this.vehicle.getSeatForRider((Entity)passenger).isController) continue;
                    attacker = passenger;
                    break;
                }
                for (int i = 0; i < collidedEntites.size(); ++i) {
                    if (this.vehicle.equals(((EntityLivingBase)collidedEntites.get(i)).func_184187_bx())) continue;
                    ((EntityLivingBase)collidedEntites.get(i)).func_70097_a((DamageSource)new DamageSources.DamageSourcePropellor(attacker), (float)(ConfigSystem.getDoubleConfig("PropellerDamageFactor") * this.connectedEngine.RPM * (double)this.connectedEngine.pack.engine.gearRatios[0] / 500.0));
                }
            }
            if (this.isPartCollidingWithBlocks(Vec3d.field_186680_a)) {
                this.damagePropeller(1.0f);
            }
            if (this.connectedEngine.RPM * (double)this.connectedEngine.pack.engine.gearRatios[0] / 60.0 * Math.PI * (double)this.pack.propeller.diameter * 0.0254 > 340.29) {
                this.damagePropeller(9999.0f);
            }
        }
    }

    @Override
    public NBTTagCompound getPartNBTTag() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74776_a("damage", this.damage);
        return dataTag;
    }

    @Override
    public float getWidth() {
        return (float)this.pack.propeller.diameter * 0.0254f / 2.0f;
    }

    @Override
    public float getHeight() {
        return (float)this.pack.propeller.diameter * 0.0254f;
    }

    @Override
    public Vec3d getActionRotation(float partialTicks) {
        return new Vec3d(0.0, 0.0, (double)(this.angularPosition + this.angularVelocity * partialTicks));
    }

    private void damagePropeller(float damage) {
        this.damage += damage;
        if (this.damage > (float)this.pack.propeller.startingHealth && !this.vehicle.field_70170_p.field_72995_K) {
            this.vehicle.removePart(this, true);
        }
    }
}

