/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.core;

import java.util.List;
import javax.annotation.Nullable;
import minecrafttransportsimulator.blocks.core.TileEntityDecor;
import minecrafttransportsimulator.dataclasses.PackDecorObject;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDecor
extends Block
implements ITileEntityProvider {
    private final boolean isOriented;
    private AxisAlignedBB regularAABB;
    private AxisAlignedBB rotatedAABB;

    public BlockDecor(boolean isOriented, boolean lighted) {
        super(Material.field_151576_e);
        this.isOriented = isOriented;
        this.field_149787_q = false;
        this.func_149715_a(lighted ? 1.0f : 0.0f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (!this.isOriented) {
            PackDecorObject pack;
            if (this.regularAABB != null) return this.regularAABB;
            TileEntityDecor tile = (TileEntityDecor)access.func_175625_s(pos);
            if (tile == null || (pack = PackParserSystem.getDecor(tile.decorName)) == null) return super.func_185496_a(state, access, pos);
            this.regularAABB = new AxisAlignedBB((double)(0.5f - pack.general.width / 2.0f), 0.0, (double)(0.5f - pack.general.depth / 2.0f), (double)(0.5f + pack.general.width / 2.0f), (double)pack.general.height, (double)(0.5f + pack.general.depth / 2.0f));
            return super.func_185496_a(state, access, pos);
        } else if (this.regularAABB == null) {
            PackDecorObject pack;
            TileEntityDecor tile = (TileEntityDecor)access.func_175625_s(pos);
            if (tile == null || (pack = PackParserSystem.getDecor(tile.decorName)) == null) return super.func_185496_a(state, access, pos);
            this.regularAABB = new AxisAlignedBB((double)(0.5f - pack.general.width / 2.0f), 0.0, (double)(0.5f - pack.general.depth / 2.0f), (double)(0.5f + pack.general.width / 2.0f), (double)pack.general.height, (double)(0.5f + pack.general.depth / 2.0f));
            this.rotatedAABB = !this.isOriented ? this.regularAABB : new AxisAlignedBB((double)(0.5f - pack.general.depth / 2.0f), 0.0, (double)(0.5f - pack.general.width / 2.0f), (double)(0.5f + pack.general.depth / 2.0f), (double)pack.general.height, (double)(0.5f + pack.general.width / 2.0f));
            return super.func_185496_a(state, access, pos);
        } else {
            TileEntityDecor tile = (TileEntityDecor)access.func_175625_s(pos);
            if (tile == null) return super.func_185496_a(state, access, pos);
            if (tile.rotation % 2 != 0) return this.rotatedAABB;
            return this.regularAABB;
        }
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        if (!this.isOriented) {
            BlockDecor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        } else if (this.regularAABB == null) {
            PackDecorObject pack;
            TileEntityDecor tile = (TileEntityDecor)world.func_175625_s(pos);
            if (tile != null && (pack = PackParserSystem.getDecor(tile.decorName)) != null) {
                this.regularAABB = new AxisAlignedBB((double)(0.5f - pack.general.width / 2.0f), 0.0, (double)(0.5f - pack.general.depth / 2.0f), (double)(0.5f + pack.general.width / 2.0f), (double)pack.general.height, (double)(0.5f + pack.general.depth / 2.0f));
                this.rotatedAABB = !this.isOriented ? this.regularAABB : new AxisAlignedBB((double)(0.5f - pack.general.depth / 2.0f), 0.0, (double)(0.5f - pack.general.width / 2.0f), (double)(0.5f + pack.general.depth / 2.0f), (double)pack.general.height, (double)(0.5f + pack.general.width / 2.0f));
            }
            BlockDecor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
        } else {
            TileEntityDecor tile = (TileEntityDecor)world.func_175625_s(pos);
            if (tile != null) {
                if (tile.rotation % 2 == 0) {
                    BlockDecor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.regularAABB);
                } else {
                    BlockDecor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.rotatedAABB);
                }
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntityDecor createNewTileEntity(World worldIn, int meta) {
        return new TileEntityDecor();
    }
}

