/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.core;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.core.BlockRotatable;
import minecrafttransportsimulator.blocks.core.TileEntityFuelPump;
import minecrafttransportsimulator.items.blocks.ItemBlockRotatable;
import minecrafttransportsimulator.packets.general.PacketChat;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockFuelPump
extends BlockRotatable
implements ITileEntityProvider {
    public BlockFuelPump(EnumFacing orientation, ItemBlockRotatable item) {
        super(orientation, item);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            TileEntityFuelPump pump = (TileEntityFuelPump)world.func_175625_s(pos);
            if (stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                int amountToDrain;
                IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack drainedStack = handler.drain(Integer.MAX_VALUE, false);
                if (drainedStack != null && (drainedStack = handler.drain(amountToDrain = pump.fill(drainedStack, false), !player.field_71075_bZ.field_75098_d)) != null) {
                    pump.fill(drainedStack, true);
                    player.func_184611_a(hand, handler.getContainer());
                }
                return true;
            }
            if (pump.getConnectedVehicle() == null) {
                Entity nearestEntity = null;
                float lowestDistance = 99.0f;
                for (Entity entity : world.field_72996_f) {
                    float distance;
                    if (!(entity instanceof EntityVehicleE_Powered) || !((distance = (float)Math.sqrt(entity.func_180425_c().func_177951_i((Vec3i)pump.func_174877_v()))) < lowestDistance)) continue;
                    lowestDistance = distance;
                    nearestEntity = entity;
                }
                if (nearestEntity != null) {
                    pump.setConnectedVehicle((EntityVehicleE_Powered)nearestEntity);
                    MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.fuelpump.connect"), (EntityPlayerMP)player);
                } else {
                    MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.fuelpump.toofar"), (EntityPlayerMP)player);
                }
            } else {
                pump.setConnectedVehicle(null);
                MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.fuelpump.disconnect"), (EntityPlayerMP)player);
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public TileEntityFuelPump createNewTileEntity(World worldIn, int meta) {
        return new TileEntityFuelPump();
    }
}

