/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.dataclasses;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.core.BlockDecor;
import minecrafttransportsimulator.blocks.core.BlockRotatable;
import minecrafttransportsimulator.blocks.pole.BlockPoleAttachment;
import minecrafttransportsimulator.blocks.pole.BlockPoleNormal;
import minecrafttransportsimulator.blocks.pole.BlockPoleSign;
import minecrafttransportsimulator.blocks.pole.BlockPoleWallConnector;
import minecrafttransportsimulator.dataclasses.CreativeTabCore;
import minecrafttransportsimulator.dataclasses.CreativeTabPack;
import minecrafttransportsimulator.items.blocks.ItemBlockBench;
import minecrafttransportsimulator.items.blocks.ItemBlockFuelPump;
import minecrafttransportsimulator.items.blocks.ItemBlockRotatable;
import minecrafttransportsimulator.items.blocks.ItemBlockTrafficSignalController;
import minecrafttransportsimulator.items.core.ItemDecor;
import minecrafttransportsimulator.items.core.ItemInstrument;
import minecrafttransportsimulator.items.core.ItemJumperCable;
import minecrafttransportsimulator.items.core.ItemKey;
import minecrafttransportsimulator.items.core.ItemManual;
import minecrafttransportsimulator.items.core.ItemVehicle;
import minecrafttransportsimulator.items.core.ItemWrench;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.packets.control.AileronPacket;
import minecrafttransportsimulator.packets.control.BrakePacket;
import minecrafttransportsimulator.packets.control.ElevatorPacket;
import minecrafttransportsimulator.packets.control.FlapPacket;
import minecrafttransportsimulator.packets.control.HornPacket;
import minecrafttransportsimulator.packets.control.LightPacket;
import minecrafttransportsimulator.packets.control.ReverseThrustPacket;
import minecrafttransportsimulator.packets.control.RudderPacket;
import minecrafttransportsimulator.packets.control.ShiftPacket;
import minecrafttransportsimulator.packets.control.SirenPacket;
import minecrafttransportsimulator.packets.control.SteeringPacket;
import minecrafttransportsimulator.packets.control.ThrottlePacket;
import minecrafttransportsimulator.packets.control.TrimPacket;
import minecrafttransportsimulator.packets.general.PacketBulletHit;
import minecrafttransportsimulator.packets.general.PacketChat;
import minecrafttransportsimulator.packets.general.PacketManualPageUpdate;
import minecrafttransportsimulator.packets.general.PacketPackReload;
import minecrafttransportsimulator.packets.general.PacketPlayerCrafting;
import minecrafttransportsimulator.packets.parts.PacketPartEngineDamage;
import minecrafttransportsimulator.packets.parts.PacketPartEngineLinked;
import minecrafttransportsimulator.packets.parts.PacketPartEngineSignal;
import minecrafttransportsimulator.packets.parts.PacketPartGroundDeviceWheelFlat;
import minecrafttransportsimulator.packets.parts.PacketPartGunReload;
import minecrafttransportsimulator.packets.parts.PacketPartGunSignal;
import minecrafttransportsimulator.packets.parts.PacketPartInteraction;
import minecrafttransportsimulator.packets.parts.PacketPartSeatRiderChange;
import minecrafttransportsimulator.packets.tileentities.PacketFuelPumpConnection;
import minecrafttransportsimulator.packets.tileentities.PacketFuelPumpFillDrain;
import minecrafttransportsimulator.packets.tileentities.PacketSignChange;
import minecrafttransportsimulator.packets.tileentities.PacketTileEntityClientServerHandshake;
import minecrafttransportsimulator.packets.tileentities.PacketTrafficSignalControllerChange;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleAttacked;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientInit;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientInitResponse;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientPartAddition;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientPartRemoval;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientRemoval;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleDeltas;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleInstruments;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleKey;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleNameTag;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleServerPartAddition;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleWindowBreak;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleWindowFix;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public final class MTSRegistry {
    public static List<Item> itemList = new ArrayList<Item>();
    public static Map<String, ItemVehicle> vehicleItemMap = new LinkedHashMap<String, ItemVehicle>();
    public static Map<String, AItemPart> partItemMap = new LinkedHashMap<String, AItemPart>();
    public static Map<String, ItemInstrument> instrumentItemMap = new LinkedHashMap<String, ItemInstrument>();
    public static Map<String, ItemDecor> decorItemMap = new LinkedHashMap<String, ItemDecor>();
    public static Map<BlockRotatable, ItemBlockRotatable> rotatableItemMap = new LinkedHashMap<BlockRotatable, ItemBlockRotatable>();
    public static final CreativeTabCore coreTab = new CreativeTabCore();
    public static final Map<String, CreativeTabPack> packTabs = new HashMap<String, CreativeTabPack>();
    public static final Item manual = new ItemManual().func_77637_a(coreTab);
    public static final Item wrench = new ItemWrench().func_77637_a(coreTab);
    public static final Item key = new ItemKey().func_77637_a(coreTab);
    public static final Item jumperCable = new ItemJumperCable().func_77637_a(coreTab);
    public static final Item vehicleBench = new ItemBlockBench("plane", "car").createBlocks();
    public static final Item propellerBench = new ItemBlockBench("propeller").createBlocks();
    public static final Item engineBench = new ItemBlockBench("engine_aircraft", "engine_jet", "engine_car").createBlocks();
    public static final Item wheelBench = new ItemBlockBench("pontoon", "skid", "tread", "wheel").createBlocks();
    public static final Item seatBench = new ItemBlockBench("seat", "crate", "barrel").createBlocks();
    public static final Item gunBench = new ItemBlockBench("gun_fixed", "gun_").createBlocks();
    public static final Item customBench = new ItemBlockBench("custom").createBlocks();
    public static final Item instrumentBench = new ItemBlockBench("instrument").createBlocks();
    public static final Item fuelPump = new ItemBlockFuelPump().createBlocks();
    public static final Item trafficSignalController = new ItemBlockTrafficSignalController().createBlocks();
    public static final Block pole = new BlockPoleNormal(0.125f);
    public static final Item itemBlockPole = new ItemBlock(pole);
    public static final Block poleBase = new BlockPoleWallConnector(0.125f);
    public static final Item itemBlockPoleBase = new ItemBlock(poleBase);
    public static final Block trafficSignal = new BlockPoleAttachment(0.125f);
    public static final Item itemBlockTrafficSignal = new ItemBlock(trafficSignal);
    public static final Block streetLight = new BlockPoleAttachment(0.125f);
    public static final Item itemBlockStreetLight = new ItemBlock(streetLight);
    public static final Block trafficSign = new BlockPoleSign(0.125f);
    public static final Item itemBlockTrafficSign = new ItemBlock(trafficSign);
    public static final Block decorBasicDark = new BlockDecor(false, false);
    public static final Block decorOrientedDark = new BlockDecor(true, false);
    public static final Block decorBasicLight = new BlockDecor(false, true);
    public static final Block decorOrientedLight = new BlockDecor(true, true);
    private static int entityNumber = 0;
    private static int packetNumber = 0;
    private static int craftingNumber = 0;

    public static void init() {
        MTSRegistry.initEntities();
        MTSRegistry.initPackets();
        MTSRegistry.initCoreItemRecipes();
        MTSRegistry.initCraftingBenchItemRecipes();
        MTSRegistry.initDecorItemRecipes();
    }

    public static List<Item> getItemsForPack(String modID) {
        ArrayList<Item> packItems = new ArrayList<Item>();
        for (ItemVehicle itemVehicle : vehicleItemMap.values()) {
            if (!itemVehicle.vehicleName.startsWith(modID)) continue;
            packItems.add(itemVehicle);
        }
        for (AItemPart aItemPart : partItemMap.values()) {
            if (!aItemPart.partName.startsWith(modID)) continue;
            packItems.add(aItemPart);
        }
        for (ItemInstrument itemInstrument : instrumentItemMap.values()) {
            if (!itemInstrument.instrumentName.startsWith(modID)) continue;
            packItems.add(itemInstrument);
        }
        for (ItemDecor itemDecor : decorItemMap.values()) {
            if (!itemDecor.decorName.startsWith(modID)) continue;
            packItems.add(itemDecor);
        }
        return packItems;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ArrayList registeredTileEntityClasses = new ArrayList();
        for (Field field : MTSRegistry.class.getFields()) {
            if (field.getType().equals(Block.class)) {
                try {
                    Class<?> tileEntityClass;
                    Block block = (Block)field.get(null);
                    String name = field.getName().toLowerCase();
                    event.getRegistry().register((IForgeRegistryEntry)((Block)block.setRegistryName(name)).func_149663_c(name));
                    if (!(block instanceof ITileEntityProvider) || registeredTileEntityClasses.contains(tileEntityClass = ((ITileEntityProvider)block).func_149915_a(null, 0).getClass())) continue;
                    GameRegistry.registerTileEntity(tileEntityClass, (String)tileEntityClass.getSimpleName());
                    registeredTileEntityClasses.add(tileEntityClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!field.getType().equals(Item.class)) continue;
            try {
                if (!(field.get(null) instanceof ItemBlockRotatable)) continue;
                ItemBlockRotatable item = (ItemBlockRotatable)((Object)field.get(null));
                for (int i = 0; i < item.blocks.length; i = (int)((byte)(i + 1))) {
                    Class<?> tileEntityClass;
                    BlockRotatable block = item.blocks[i];
                    String name = field.getName().toLowerCase() + "_" + i;
                    event.getRegistry().register((IForgeRegistryEntry)((Block)block.setRegistryName(name)).func_149663_c(name));
                    rotatableItemMap.put(block, item);
                    if (!(block instanceof ITileEntityProvider) || registeredTileEntityClasses.contains(tileEntityClass = ((ITileEntityProvider)block).func_149915_a(null, 0).getClass())) continue;
                    GameRegistry.registerTileEntity(tileEntityClass, (String)tileEntityClass.getSimpleName());
                    registeredTileEntityClasses.add(tileEntityClass);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Field field : MTSRegistry.class.getFields()) {
            if (!field.getType().equals(Item.class)) continue;
            try {
                Item item = (Item)field.get(null);
                String name = field.getName().toLowerCase();
                if (!name.startsWith("itemblock")) {
                    event.getRegistry().register((IForgeRegistryEntry)((Item)item.setRegistryName(name)).func_77655_b(name));
                    itemList.add(item);
                    continue;
                }
                name = name.substring("itemblock".length());
                event.getRegistry().register((IForgeRegistryEntry)((Item)item.setRegistryName(name)).func_77655_b(name));
                itemList.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String multipartName : PackParserSystem.getAllVehiclePackNames()) {
            ItemVehicle itemMultipart = new ItemVehicle(multipartName);
            vehicleItemMap.put(multipartName, itemMultipart);
        }
        for (String partName : PackParserSystem.getAllPartPackNames()) {
            try {
                Class<? extends AItemPart> itemClass = PackParserSystem.getPartItemClass(partName);
                Constructor<? extends AItemPart> construct = itemClass.getConstructor(String.class);
                AItemPart itemPart = construct.newInstance(partName);
                partItemMap.put(partName, itemPart);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String instrumentName : PackParserSystem.getAllInstruments()) {
            ItemInstrument itemInstrument = new ItemInstrument(instrumentName);
            instrumentItemMap.put(instrumentName, itemInstrument);
        }
        for (String decorName : PackParserSystem.getAllDecor()) {
            ItemDecor itemDecor = new ItemDecor(decorName);
            decorItemMap.put(decorName, itemDecor);
        }
    }

    private static void initEntities() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mts", EntityVehicleF_Car.class.getSimpleName().substring(6).toLowerCase()), EntityVehicleF_Car.class, (String)"vehiclecar", (int)entityNumber++, (Object)"mts", (int)80, (int)5, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mts", EntityVehicleF_Plane.class.getSimpleName().substring(6).toLowerCase()), EntityVehicleF_Plane.class, (String)"vehicleplane", (int)entityNumber++, (Object)"mts", (int)80, (int)5, (boolean)false);
    }

    private static void initPackets() {
        MTSRegistry.registerPacket(AileronPacket.class, AileronPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(BrakePacket.class, BrakePacket.Handler.class, true, true);
        MTSRegistry.registerPacket(ElevatorPacket.class, ElevatorPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(FlapPacket.class, FlapPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(HornPacket.class, HornPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(LightPacket.class, LightPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(ReverseThrustPacket.class, ReverseThrustPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(RudderPacket.class, RudderPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(SirenPacket.class, SirenPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(ShiftPacket.class, ShiftPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(SteeringPacket.class, SteeringPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(ThrottlePacket.class, ThrottlePacket.Handler.class, true, true);
        MTSRegistry.registerPacket(TrimPacket.class, TrimPacket.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketBulletHit.class, PacketBulletHit.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketChat.class, PacketChat.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketPartGunReload.class, PacketPartGunReload.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketManualPageUpdate.class, PacketManualPageUpdate.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketPackReload.class, PacketPackReload.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketPlayerCrafting.class, PacketPlayerCrafting.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketFuelPumpConnection.class, PacketFuelPumpConnection.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketFuelPumpFillDrain.class, PacketFuelPumpFillDrain.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketSignChange.class, PacketSignChange.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketTileEntityClientServerHandshake.class, PacketTileEntityClientServerHandshake.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketTrafficSignalControllerChange.class, PacketTrafficSignalControllerChange.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketVehicleAttacked.class, PacketVehicleAttacked.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketVehicleClientInit.class, PacketVehicleClientInit.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketVehicleClientInitResponse.class, PacketVehicleClientInitResponse.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketVehicleClientPartAddition.class, PacketVehicleClientPartAddition.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketVehicleClientPartRemoval.class, PacketVehicleClientPartRemoval.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketVehicleClientRemoval.class, PacketVehicleClientRemoval.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketVehicleDeltas.class, PacketVehicleDeltas.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketVehicleInstruments.class, PacketVehicleInstruments.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketVehicleKey.class, PacketVehicleKey.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketVehicleNameTag.class, PacketVehicleNameTag.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketVehicleServerPartAddition.class, PacketVehicleServerPartAddition.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketVehicleWindowBreak.class, PacketVehicleWindowBreak.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketVehicleWindowFix.class, PacketVehicleWindowFix.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketPartEngineDamage.class, PacketPartEngineDamage.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketPartEngineLinked.class, PacketPartEngineLinked.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketPartEngineSignal.class, PacketPartEngineSignal.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketPartGroundDeviceWheelFlat.class, PacketPartGroundDeviceWheelFlat.Handler.class, true, false);
        MTSRegistry.registerPacket(PacketPartGunSignal.class, PacketPartGunSignal.Handler.class, true, true);
        MTSRegistry.registerPacket(PacketPartInteraction.class, PacketPartInteraction.Handler.class, false, true);
        MTSRegistry.registerPacket(PacketPartSeatRiderChange.class, PacketPartSeatRiderChange.Handler.class, true, false);
    }

    private static void initCoreItemRecipes() {
        MTSRegistry.registerRecipe(new ItemStack(manual), " A ", "CBC", " D ", Character.valueOf('A'), Items.field_151008_G, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('D'), Items.field_151121_aF);
        MTSRegistry.registerRecipe(new ItemStack(wrench), "  A", " A ", "A  ", Character.valueOf('A'), Items.field_151042_j);
        MTSRegistry.registerRecipe(new ItemStack(key), " A ", " A ", " S ", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('S'), Items.field_151007_F);
        MTSRegistry.registerRecipe(new ItemStack(jumperCable), "I I", "SRS", "SSS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151097_aZ);
        MTSRegistry.registerRecipe(new ItemStack(fuelPump), "DED", "CBC", "AAA", Character.valueOf('A'), new ItemStack((Block)Blocks.field_150333_U, 1, 0), Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, 0), Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('E'), Blocks.field_150410_aZ);
        MTSRegistry.registerRecipe(new ItemStack(trafficSignalController), "AAA", "BCB", "DBD", Character.valueOf('A'), new ItemStack((Block)Blocks.field_150333_U, 1, 0), Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('D'), Items.field_151137_ax);
    }

    private static void initCraftingBenchItemRecipes() {
        for (Block fenceBlock : new Block[]{Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180405_aT, Blocks.field_180406_aS}) {
            MTSRegistry.registerRecipe(new ItemStack(vehicleBench), "AAA", "ACA", "B B", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), fenceBlock, Character.valueOf('C'), Blocks.field_150410_aZ);
        }
        MTSRegistry.registerRecipe(new ItemStack(propellerBench), "AAA", " BA", "ACA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151045_i, Character.valueOf('C'), Blocks.field_150467_bQ);
        MTSRegistry.registerRecipe(new ItemStack(engineBench), "AAA", "BDA", " CC", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('C'), Blocks.field_150339_S, Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, 1));
        MTSRegistry.registerRecipe(new ItemStack(wheelBench), "A  ", "ACC", "BCC", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150467_bQ, Character.valueOf('C'), Blocks.field_150344_f);
        MTSRegistry.registerRecipe(new ItemStack(seatBench), "   ", "ABA", "A A", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151036_c);
        MTSRegistry.registerRecipe(new ItemStack(gunBench), "   ", "ABC", "DAD", Character.valueOf('A'), Blocks.field_150339_S, Character.valueOf('B'), Items.field_151045_i, Character.valueOf('C'), new ItemStack(Items.field_151100_aR, 1, 14), Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, 2));
        MTSRegistry.registerRecipe(new ItemStack(customBench), "AAA", "ABA", "AAA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150462_ai);
        MTSRegistry.registerRecipe(new ItemStack(instrumentBench), "AGA", "PRP", "P P", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('G'), Blocks.field_150426_aN, Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('P'), Blocks.field_150344_f);
    }

    private static void initDecorItemRecipes() {
        MTSRegistry.registerRecipe(new ItemStack(itemBlockPole, 4), " S ", " S ", " S ", Character.valueOf('S'), Blocks.field_150463_bK);
        MTSRegistry.registerRecipe(new ItemStack(itemBlockPoleBase), "   ", " P ", " S ", Character.valueOf('S'), Blocks.field_150333_U, Character.valueOf('P'), itemBlockPole);
        MTSRegistry.registerRecipe(new ItemStack(itemBlockStreetLight), " SP", " G ", "   ", Character.valueOf('S'), Blocks.field_150333_U, Character.valueOf('P'), itemBlockPole, Character.valueOf('G'), Items.field_151114_aO);
        MTSRegistry.registerRecipe(new ItemStack(itemBlockTrafficSignal), "RLS", "YLP", "GLA", Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('Y'), new ItemStack(Items.field_151100_aR, 1, 11), Character.valueOf('G'), new ItemStack(Items.field_151100_aR, 1, 10), Character.valueOf('L'), Items.field_151114_aO, Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('S'), Blocks.field_150333_U, Character.valueOf('P'), itemBlockPole);
        MTSRegistry.registerRecipe(new ItemStack(itemBlockTrafficSign), "   ", " I ", " P ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), itemBlockPole);
    }

    private static void registerRecipe(ItemStack output, Object ... params) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])params);
        ++craftingNumber;
    }

    private static <REQ extends IMessage, REPLY extends IMessage> void registerPacket(Class<REQ> packetClass, Class<? extends IMessageHandler<REQ, REPLY>> handlerClass, boolean client, boolean server) {
        if (client) {
            MTS.MTSNet.registerMessage(handlerClass, packetClass, ++packetNumber, Side.CLIENT);
        }
        if (server) {
            MTS.MTSNet.registerMessage(handlerClass, packetClass, ++packetNumber, Side.SERVER);
        }
    }
}

