/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.dataclasses;

import java.lang.reflect.Field;
import minecrafttransportsimulator.blocks.core.TileEntityDecor;
import minecrafttransportsimulator.blocks.core.TileEntityFuelPump;
import minecrafttransportsimulator.blocks.pole.TileEntityPoleSign;
import minecrafttransportsimulator.blocks.pole.TileEntityPoleWallConnector;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.items.core.ItemDecor;
import minecrafttransportsimulator.items.core.ItemInstrument;
import minecrafttransportsimulator.items.core.ItemVehicle;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.rendering.RenderVehicle;
import minecrafttransportsimulator.rendering.blockrenders.RenderDecor;
import minecrafttransportsimulator.rendering.blockrenders.RenderFuelPump;
import minecrafttransportsimulator.rendering.blockrenders.RenderPoleLighted;
import minecrafttransportsimulator.rendering.blockrenders.RenderPoleSign;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class MTSRegistryClient {
    private static final IRenderFactory<EntityVehicleE_Powered> MTSRenderFactory = new IRenderFactory<EntityVehicleE_Powered>(){

        public Render<? super EntityVehicleE_Powered> createRenderFor(RenderManager manager) {
            return new RenderVehicle(manager);
        }
    };

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFuelPump.class, (TileEntitySpecialRenderer)new RenderFuelPump());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPoleWallConnector.class, (TileEntitySpecialRenderer)new RenderPoleLighted());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPoleSign.class, (TileEntitySpecialRenderer)new RenderPoleSign());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDecor.class, (TileEntitySpecialRenderer)new RenderDecor());
        RenderingRegistry.registerEntityRenderingHandler(EntityVehicleE_Powered.class, MTSRenderFactory);
        for (Field field : MTSRegistry.class.getFields()) {
            if (!field.getType().equals(Item.class)) continue;
            try {
                MTSRegistryClient.registerCoreItemRender((Item)field.get(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ItemVehicle vehicleItem : MTSRegistry.vehicleItemMap.values()) {
            MTSRegistryClient.registerPackItemRender(vehicleItem, vehicleItem.vehicleName, "vehicles");
        }
        for (AItemPart partItem : MTSRegistry.partItemMap.values()) {
            MTSRegistryClient.registerPackItemRender(partItem, partItem.partName, "parts");
        }
        for (ItemInstrument instrumentItem : MTSRegistry.instrumentItemMap.values()) {
            MTSRegistryClient.registerPackItemRender(instrumentItem, instrumentItem.instrumentName, "instruments");
        }
        for (ItemDecor decorItem : MTSRegistry.decorItemMap.values()) {
            MTSRegistryClient.registerPackItemRender(decorItem, decorItem.decorName, "decors");
        }
    }

    private static void registerCoreItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("mts:" + item.getRegistryName().func_110623_a(), "inventory"));
    }

    private static void registerPackItemRender(Item item, String wholeName, String renderFolder) {
        String itemModID = wholeName.substring(0, wholeName.indexOf(58));
        String itemName = wholeName.substring(wholeName.indexOf(58) + 1);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemModID + ":" + renderFolder + "/" + itemName, "inventory"));
    }
}

