/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis;

import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.items.blocks.ItemBlockBench;
import minecrafttransportsimulator.items.core.ItemDecor;
import minecrafttransportsimulator.items.core.ItemVehicle;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.packets.general.PacketManualPageUpdate;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.OBJParserSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIManual
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("mts", "textures/guis/manual_pages.png");
    private static final ResourceLocation cover = new ResourceLocation("mts", "textures/guis/manual_cover.png");
    private short pageNumber;
    private int guiLeft;
    private int guiTop;
    private int leftSideOffset;
    private int rightSideOffset;
    private final ItemStack stack;
    private final NBTTagCompound stackTag;
    private final byte totalInfoPages;
    private final byte totalPages;
    private final List<ItemBlockBench> craftingBenches = new ArrayList<ItemBlockBench>();
    private static final ResourceLocation craftingTableTexture = new ResourceLocation("textures/gui/container/crafting_table.png");
    private GuiButton leftButton;
    private GuiButton rightButton;
    int xOffset = 160;
    int yOffset = 200;
    float scale = 6.0f;

    public GUIManual(ItemStack stack) {
        this.stack = stack;
        this.stackTag = !stack.func_77942_o() ? stack.func_77955_b(new NBTTagCompound()) : stack.func_77978_p();
        this.pageNumber = this.stackTag.func_74765_d("page");
        boolean benches = false;
        for (Field field : MTSRegistry.class.getFields()) {
            if (!field.getType().equals(Item.class)) continue;
            try {
                Item item = (Item)field.get(null);
                if (!(item instanceof ItemBlockBench)) continue;
                this.craftingBenches.add((ItemBlockBench)item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 1; i < 50; i = (int)((byte)(i + 1))) {
            if (!I18n.func_135052_a((String)("manual." + String.valueOf(i) + ".title"), (Object[])new Object[0]).equals("manual." + String.valueOf(i) + ".title")) continue;
            this.totalInfoPages = (byte)((i - 1) * 2);
            this.totalPages = (byte)(this.totalInfoPages + (this.craftingBenches.size() - 1) + 2);
            if (this.pageNumber > this.totalPages) {
                this.pageNumber = 0;
            }
            return;
        }
        this.totalPages = 0;
        this.totalInfoPages = 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 280) / 2;
        this.guiTop = (this.field_146295_m - 180) / 2;
        this.leftSideOffset = this.guiLeft + 20;
        this.rightSideOffset = this.guiLeft + 155;
        this.leftButton = new GuiButton(0, this.guiLeft + 10, this.guiTop + 150, 20, 20, "<");
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButton(0, this.guiLeft + 250, this.guiTop + 150, 20, 20, ">");
        this.field_146292_n.add(this.rightButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
        if (Mouse.isCreated() && Mouse.hasWheel()) {
            int wheelMovement = Mouse.getDWheel();
            if (wheelMovement > 0 && this.pageNumber + 1 < this.totalPages) {
                this.pageNumber = (short)(this.pageNumber + (this.pageNumber == 0 ? 1 : 2));
            } else if (wheelMovement < 0 && this.pageNumber > 0) {
                this.pageNumber = (short)(this.pageNumber - (this.pageNumber == 1 ? 1 : 2));
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.pageNumber != 0) {
            this.field_146297_k.func_110434_K().func_110577_a(background);
            GUIManual.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)280, (int)180, (float)512.0f, (float)256.0f);
            this.field_146289_q.func_78276_b(String.valueOf(this.pageNumber) + "/" + String.valueOf(this.totalPages), this.guiLeft + 15, this.guiTop + 10, Color.BLACK.getRGB());
            this.field_146289_q.func_78276_b(String.valueOf(this.pageNumber + 1) + "/" + String.valueOf(this.totalPages), this.guiLeft + 240, this.guiTop + 10, Color.BLACK.getRGB());
            this.leftButton.field_146125_m = true;
            this.leftButton.field_146124_l = true;
            this.leftButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
            if (this.pageNumber < this.totalPages) {
                this.rightButton.field_146125_m = true;
                this.rightButton.field_146124_l = true;
                this.rightButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
            } else {
                this.rightButton.field_146125_m = false;
                this.rightButton.field_146124_l = false;
            }
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(cover);
            GUIManual.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)280, (int)180, (float)512.0f, (float)256.0f);
            this.leftButton.field_146125_m = false;
            this.leftButton.field_146124_l = false;
            this.rightButton.field_146125_m = true;
            this.rightButton.field_146124_l = true;
            this.rightButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        if (this.pageNumber == 0) {
            this.drawCover();
        } else if (this.pageNumber == 1) {
            this.drawContentsPage();
        } else if (this.pageNumber < this.totalInfoPages + 3) {
            this.drawInfoPage();
        } else {
            this.drawCraftingPage(mouseX, mouseY);
        }
    }

    private void drawCover() {
        ItemStack stack;
        GL11.glPushMatrix();
        if (ConfigSystem.getBooleanConfig("DevMode") && this.field_146297_k.func_71356_B() && (stack = this.field_146297_k.field_71439_g.func_184592_cb()) != null && stack.func_77973_b() != null) {
            String packName;
            Object pack;
            ResourceLocation textureLocation;
            ResourceLocation modelLocation;
            Item item;
            if (stack.func_77973_b() instanceof ItemVehicle) {
                item = (ItemVehicle)stack.func_77973_b();
                String packName2 = item.vehicleName.substring(0, item.vehicleName.indexOf(58));
                modelLocation = new ResourceLocation(packName2, "objmodels/vehicles/" + PackParserSystem.getVehicleJSONName(item.vehicleName) + ".obj");
                textureLocation = new ResourceLocation(packName2, "textures/vehicles/" + item.vehicleName.substring(item.vehicleName.indexOf(58) + 1) + ".png");
            } else if (stack.func_77973_b() instanceof AItemPart) {
                item = (AItemPart)stack.func_77973_b();
                pack = PackParserSystem.getPartPack(item.partName);
                packName = item.partName.substring(0, item.partName.indexOf(58));
                modelLocation = ((PackPartObject)pack).general.modelName != null ? new ResourceLocation(packName, "objmodels/parts/" + ((PackPartObject)pack).general.modelName + ".obj") : new ResourceLocation(packName, "objmodels/parts/" + item.partName.substring(item.partName.indexOf(58) + 1) + ".obj");
                textureLocation = new ResourceLocation(packName, "textures/parts/" + item.partName.substring(item.partName.indexOf(58) + 1) + ".png");
            } else if (stack.func_77973_b() instanceof ItemDecor) {
                item = (ItemDecor)stack.func_77973_b();
                pack = PackParserSystem.getDecor(item.decorName);
                packName = item.decorName.substring(0, item.decorName.indexOf(58));
                modelLocation = new ResourceLocation(packName, "objmodels/decors/" + item.decorName.substring(item.decorName.indexOf(58) + 1) + ".obj");
                textureLocation = new ResourceLocation(packName, "textures/decors/" + item.decorName.substring(item.decorName.indexOf(58) + 1) + ".png");
            } else {
                modelLocation = null;
                textureLocation = null;
            }
            if (modelLocation != null) {
                this.field_146297_k.func_110434_K().func_110577_a(textureLocation);
                GL11.glTranslatef((float)(this.guiLeft + this.xOffset), (float)(this.guiTop + this.yOffset), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)35.264f, (float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
                GL11.glBegin((int)4);
                for (Map.Entry<String, Float[][]> entry : OBJParserSystem.parseOBJModel(modelLocation.func_110624_b(), modelLocation.func_110623_a()).entrySet()) {
                    for (Float[] vertex : entry.getValue()) {
                        GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                        GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                        GL11.glVertex3f((float)(-vertex[0].floatValue()), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                    }
                }
                GL11.glEnd();
            }
        }
        GL11.glTranslatef((float)(this.guiLeft + 170), (float)(this.guiTop + 25), (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        this.field_146289_q.func_78276_b("MINECRAFT", 0, 10, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b("TRANSPORT", 0, 20, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b("SIMULATOR", 0, 30, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b("HANDBOOK", 0, 40, Color.WHITE.getRGB());
        GL11.glScalef((float)0.6666667f, (float)0.6666667f, (float)0.6666667f);
        GL11.glPopMatrix();
        this.field_146289_q.func_78276_b("Formerly Minecraft", this.guiLeft + 160, this.guiTop + 140, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b("  Flight Simulator", this.guiLeft + 160, this.guiTop + 150, Color.WHITE.getRGB());
    }

    private void drawContentsPage() {
        int contentsLine = 0;
        int contentsCount = 0;
        int pageCount = 3;
        this.field_146289_q.func_78276_b("CONTENTS", this.guiLeft + 50, this.guiTop + 25, Color.BLACK.getRGB());
        for (int i = 1; i <= this.totalInfoPages / 2; i = (int)((byte)(i + 1))) {
            String title = I18n.func_135052_a((String)("manual." + String.valueOf(i) + ".title"), (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(String.valueOf(i * 2 + 1) + ": " + title, contentsCount < 10 ? this.leftSideOffset : this.rightSideOffset, this.guiTop + 45 + 10 * contentsLine, Color.BLACK.getRGB());
            contentsCount = (byte)(contentsCount + 1);
            contentsLine = (byte)(contentsLine + 1);
            if (contentsLine != 10) continue;
            contentsLine = 0;
        }
    }

    private void drawInfoPage() {
        int topOffset = this.guiTop + 25;
        int headerOffset = 20;
        byte sectionNumber = (byte)((this.pageNumber - 1) / 2);
        String title = I18n.func_135052_a((String)("manual." + sectionNumber + ".title"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.guiLeft + 75 - this.field_146289_q.func_78256_a(title) / 2, topOffset, Color.BLACK.getRGB());
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.leftSideOffset, (float)(topOffset + headerOffset), (float)0.0f);
        GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)("manual." + sectionNumber + ".1"), (Object[])new Object[0]), 0, 0, 150, Color.BLACK.getRGB());
        GL11.glTranslatef((float)((float)(this.rightSideOffset - this.leftSideOffset) / 0.75f), (float)((float)(-headerOffset) / 0.75f), (float)0.0f);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)("manual." + sectionNumber + ".2"), (Object[])new Object[0]), 0, 0, 150, Color.BLACK.getRGB());
        GL11.glPopMatrix();
    }

    private void drawCraftingPage(int mouseX, int mouseY) {
        byte benchNumber = (byte)(this.pageNumber - this.totalInfoPages - 2);
        ItemBlockBench benchItemLeft = this.craftingBenches.get(benchNumber);
        ItemBlockBench benchItemRight = benchNumber + 1 < this.craftingBenches.size() ? this.craftingBenches.get(benchNumber + 1) : null;
        String title = I18n.func_135052_a((String)(benchItemLeft.func_77658_a() + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.guiLeft + 75 - this.field_146289_q.func_78256_a(title) / 2, this.guiTop + 25, Color.BLACK.getRGB());
        if (benchItemRight != null) {
            title = I18n.func_135052_a((String)(benchItemRight.func_77658_a() + ".name"), (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(title, this.guiLeft + 75 + 140 - this.field_146289_q.func_78256_a(title) / 2, this.guiTop + 25, Color.BLACK.getRGB());
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(craftingTableTexture);
        this.func_73729_b(this.guiLeft + 50, this.guiTop + 100, 29, 16, 54, 54);
        if (benchItemRight != null) {
            this.func_73729_b(this.guiLeft + 50 + 140, this.guiTop + 100, 29, 16, 54, 54);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)this.guiLeft + 50.0f), (float)((float)this.guiTop + 40.0f), (float)0.0f);
        GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
        this.field_146296_j.func_180450_b(new ItemStack((Item)benchItemLeft), 0, 0);
        GL11.glPopMatrix();
        if (benchItemRight != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)this.guiLeft + 50.0f + 140.0f), (float)((float)this.guiTop + 40.0f), (float)0.0f);
            GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
            this.field_146296_j.func_180450_b(new ItemStack((Item)benchItemRight), 0, 0);
            GL11.glPopMatrix();
        }
        ItemStack hoveredStack = null;
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (recipe.func_77571_b() == null) continue;
            int xOffset = 0;
            if (recipe.func_77571_b().func_77973_b().equals((Object)benchItemLeft)) {
                xOffset = 51;
            } else if (recipe.func_77571_b().func_77973_b().equals((Object)benchItemRight)) {
                xOffset = 191;
            }
            if (xOffset == 0) continue;
            int i = this.guiLeft + xOffset;
            int j = this.guiTop + 100;
            for (ItemStack stack : ((ShapedRecipes)recipe).field_77574_d) {
                if (stack != null) {
                    this.field_146296_j.func_180450_b(new ItemStack(stack.func_77973_b()), i, j);
                    if (mouseX > i && mouseX < i + 16 && mouseY > j && mouseY < j + 16) {
                        hoveredStack = stack;
                    }
                }
                if ((i += 18) != this.guiLeft + xOffset + 54) continue;
                i = this.guiLeft + xOffset;
                j += 18;
            }
        }
        if (hoveredStack != null) {
            this.func_146285_a(hoveredStack, mouseX, mouseY);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_146284_a(GuiButton buttonClicked) throws IOException {
        super.func_146284_a(buttonClicked);
        if (buttonClicked.equals(this.leftButton)) {
            this.pageNumber = (short)(this.pageNumber - (this.pageNumber == 1 ? 1 : 2));
        } else if (buttonClicked.equals(this.rightButton)) {
            this.pageNumber = (short)(this.pageNumber + (this.pageNumber == 0 ? 1 : 2));
        }
    }

    public void func_146281_b() {
        MTS.MTSNet.sendToServer((IMessage)new PacketManualPageUpdate(this.pageNumber));
        this.stackTag.func_74777_a("page", this.pageNumber);
        this.stack.func_77982_d(this.stackTag);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            super.func_73869_a('0', 1);
        } else if (ConfigSystem.getBooleanConfig("DevMode") && this.field_146297_k.func_71356_B()) {
            if (keyCode == 200) {
                --this.yOffset;
            } else if (keyCode == 208) {
                ++this.yOffset;
            } else if (keyCode == 203) {
                --this.xOffset;
            } else if (keyCode == 205) {
                ++this.xOffset;
            } else if (keyCode == 201) {
                this.scale += 0.5f;
            } else if (keyCode == 209) {
                this.scale -= 0.5f;
            }
        }
    }
}

