/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis;

import java.awt.Color;
import java.io.IOException;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.packets.control.LightPacket;
import minecrafttransportsimulator.packets.control.ReverseThrustPacket;
import minecrafttransportsimulator.packets.control.TrimPacket;
import minecrafttransportsimulator.packets.parts.PacketPartEngineSignal;
import minecrafttransportsimulator.rendering.RenderHUD;
import minecrafttransportsimulator.rendering.RenderInstruments;
import minecrafttransportsimulator.rendering.RenderVehicle;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GUIPanelAircraft
extends GuiScreen {
    private static final ResourceLocation toggleOn = new ResourceLocation("textures/blocks/redstone_lamp_on.png");
    private static final ResourceLocation toggleOff = new ResourceLocation("textures/blocks/redstone_lamp_off.png");
    private static final EntityVehicleE_Powered.LightTypes[] lights = new EntityVehicleE_Powered.LightTypes[]{EntityVehicleE_Powered.LightTypes.NAVIGATIONLIGHT, EntityVehicleE_Powered.LightTypes.STROBELIGHT, EntityVehicleE_Powered.LightTypes.TAXILIGHT, EntityVehicleE_Powered.LightTypes.LANDINGLIGHT};
    private static final String[] lightText = new String[]{I18n.func_135052_a((String)"gui.panel.navigationlights", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.panel.strobelights", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.panel.taxilights", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.panel.landinglights", (Object[])new Object[0])};
    private final EntityVehicleE_Powered aircraft;
    private final APartEngine[] engines;
    private final boolean[] hasLight;
    private final int[][] lightButtonCoords;
    private final int[][] magnetoButtonCoords;
    private final int[][] starterButtonCoords;
    private final int[] reverseButtonCoords;
    private GuiButton aileronTrimUpButton;
    private GuiButton aileronTrimDownButton;
    private GuiButton elevatorTrimUpButton;
    private GuiButton elevatorTrimDownButton;
    private GuiButton rudderTrimUpButton;
    private GuiButton rudderTrimDownButton;
    private byte lastEngineStarted;
    private GuiButton lastButtonPressed;

    public GUIPanelAircraft(EntityVehicleE_Powered aircraft) {
        int xOffset;
        byte i;
        this.aircraft = aircraft;
        this.engines = new APartEngine[aircraft.getNumberEngineBays()];
        for (i = 0; i < this.engines.length; i = (byte)(i + 1)) {
            this.engines[i] = aircraft.getEngineByNumber(i);
        }
        this.hasLight = new boolean[4];
        this.lightButtonCoords = new int[4][4];
        for (i = 0; i < this.lightButtonCoords.length; i = (byte)(i + 1)) {
            this.lightButtonCoords[i] = new int[]{16, 48, 280 + 50 * i + 32, 280 + 50 * i};
        }
        this.magnetoButtonCoords = new int[this.engines.length][4];
        for (i = 0; i < this.magnetoButtonCoords.length; i = (byte)(i + 1)) {
            xOffset = i < 4 ? 64 : 144;
            this.magnetoButtonCoords[i] = new int[]{xOffset, xOffset + 32, 280 + 50 * (i % 4) + 32, 280 + 50 * (i % 4)};
        }
        this.starterButtonCoords = new int[this.engines.length][4];
        for (i = 0; i < this.starterButtonCoords.length; i = (byte)(i + 1)) {
            xOffset = i < 4 ? 96 : 176;
            this.starterButtonCoords[i] = new int[]{xOffset, xOffset + 32, 280 + 50 * (i % 4) + 32, 280 + 50 * (i % 4)};
        }
        int xOffset2 = this.engines.length < 4 ? 160 : 240;
        this.reverseButtonCoords = new int[]{xOffset2, xOffset2 + 32, 462, 430};
    }

    public void func_73866_w_() {
        for (int i = 0; i < this.lightButtonCoords.length; i = (int)((byte)(i + 1))) {
            this.hasLight[i] = RenderVehicle.doesVehicleHaveLight(this.aircraft, lights[i]);
        }
        int xOffset = this.engines.length < 4 ? 90 : 140;
        this.aileronTrimUpButton = new GuiButton(0, xOffset, 175, 20, 20, "<");
        this.field_146292_n.add(this.aileronTrimUpButton);
        this.aileronTrimDownButton = new GuiButton(0, xOffset + 20, 175, 20, 20, ">");
        this.field_146292_n.add(this.aileronTrimDownButton);
        this.elevatorTrimUpButton = new GuiButton(0, xOffset, 206, 20, 20, "/\\");
        this.field_146292_n.add(this.elevatorTrimUpButton);
        this.elevatorTrimDownButton = new GuiButton(0, xOffset + 20, 206, 20, 20, "\\/");
        this.field_146292_n.add(this.elevatorTrimDownButton);
        this.rudderTrimUpButton = new GuiButton(0, xOffset, 237, 20, 20, "<");
        this.field_146292_n.add(this.rudderTrimUpButton);
        this.rudderTrimDownButton = new GuiButton(0, xOffset + 20, 237, 20, 20, ">");
        this.field_146292_n.add(this.rudderTrimDownButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        int textY;
        int i;
        int i2;
        if (this.aircraft.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        boolean lightsOn = RenderInstruments.lightsOn(this.aircraft);
        CameraSystem.disableHUD = true;
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f * (float)this.field_146294_l / 854.0f), (float)(1.0f * (float)this.field_146295_m / 480.0f), (float)0.0f);
        RenderHUD.drawAuxiliaryHUD(this.aircraft, this.field_146294_l, this.field_146295_m, false);
        for (i2 = 0; i2 < this.hasLight.length; i2 = (int)((byte)(i2 + 1))) {
            if (!this.hasLight[i2]) continue;
            this.drawRedstoneButton(this.lightButtonCoords[i2], this.aircraft.isLightOn(lights[i2]));
        }
        for (i2 = 0; i2 < this.magnetoButtonCoords.length; i2 = (int)((byte)(i2 + 1))) {
            this.drawRedstoneButton(this.magnetoButtonCoords[i2], this.engines[i2] != null ? this.engines[i2].state.magnetoOn : false);
            this.drawRedstoneButton(this.starterButtonCoords[i2], this.engines[i2] != null ? this.engines[i2].state.esOn : false);
        }
        mouseX = (int)(1.0f * (float)mouseX / (float)this.field_146294_l * 854.0f * 20.0f / 32.0f);
        mouseY = (int)(1.0f * (float)mouseY / (float)this.field_146295_m * 480.0f * 20.0f / 32.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)1.6f, (float)1.6f, (float)0.0f);
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        if (this.aircraft instanceof EntityVehicleF_Plane) {
            this.drawRedstoneButton(this.reverseButtonCoords, ((EntityVehicleF_Plane)this.aircraft).reverseThrust);
        }
        for (i = 0; i < this.lightButtonCoords.length; i = (int)((byte)(i + 1))) {
            if (!this.hasLight[i]) continue;
            int textX = this.lightButtonCoords[i][0] + (this.lightButtonCoords[i][1] - this.lightButtonCoords[i][0]) / 2;
            textY = this.lightButtonCoords[i][2] + 2;
            this.field_146289_q.func_78276_b(lightText[i], textX - this.field_146289_q.func_78256_a(lightText[i]) / 2, textY, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        }
        for (i = 0; i < this.magnetoButtonCoords.length; i = (int)((byte)(i + 1))) {
            int textX = this.magnetoButtonCoords[i][0] + (this.magnetoButtonCoords[i][1] - this.magnetoButtonCoords[i][0]) / 2;
            textY = this.magnetoButtonCoords[i][2] + 2;
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.panel.magneto", (Object[])new Object[0]), textX - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.panel.magneto", (Object[])new Object[0])) / 2, textY, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.panel.starter", (Object[])new Object[0]), textX - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.panel.starter", (Object[])new Object[0])) / 2 + 32, textY, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        }
        int xOffset = this.engines.length < 4 ? 176 : 256;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.panel.trim_roll", (Object[])new Object[0]), xOffset - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.panel.trim_roll", (Object[])new Object[0])) / 2, 314, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.panel.trim_pitch", (Object[])new Object[0]), xOffset - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.panel.trim_pitch", (Object[])new Object[0])) / 2, 364, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.panel.trim_yaw", (Object[])new Object[0]), xOffset - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.panel.trim_yaw", (Object[])new Object[0])) / 2, 414, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        if (this.aircraft instanceof EntityVehicleF_Plane) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.panel.reverse", (Object[])new Object[0]), xOffset - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.panel.reverse", (Object[])new Object[0])) / 2, 464, lightsOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        }
        GL11.glPopMatrix();
    }

    private void drawRedstoneButton(int[] coords, boolean isOn) {
        this.field_146297_k.func_110434_K().func_110577_a(isOn ? toggleOn : toggleOff);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)coords[0], (double)coords[3], (double)0.0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)coords[0], (double)coords[2], (double)0.0);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)coords[1], (double)coords[2], (double)0.0);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3d((double)coords[1], (double)coords[3], (double)0.0);
        GL11.glEnd();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        mouseX = (int)(1.0f * (float)mouseX / (float)this.field_146294_l * 854.0f);
        mouseY = (int)(1.0f * (float)mouseY / (float)this.field_146295_m * 480.0f);
        this.lastEngineStarted = (byte)-1;
        if (mouseY < 240) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            int i;
            for (i = 0; i < this.lightButtonCoords.length; i = (int)((byte)(i + 1))) {
                if (mouseX <= this.lightButtonCoords[i][0] || mouseX >= this.lightButtonCoords[i][1] || mouseY >= this.lightButtonCoords[i][2] || mouseY <= this.lightButtonCoords[i][3] || !this.hasLight[i]) continue;
                MTS.MTSNet.sendToServer((IMessage)new LightPacket(this.aircraft.func_145782_y(), lights[i]));
            }
            for (i = 0; i < this.magnetoButtonCoords.length; i = (int)((byte)(i + 1))) {
                if (this.engines[i] == null || mouseX <= this.magnetoButtonCoords[i][0] || mouseX >= this.magnetoButtonCoords[i][1] || mouseY >= this.magnetoButtonCoords[i][2] || mouseY <= this.magnetoButtonCoords[i][3]) continue;
                MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(this.engines[i], this.engines[i].state.magnetoOn ? PacketPartEngineSignal.PacketEngineTypes.MAGNETO_OFF : PacketPartEngineSignal.PacketEngineTypes.MAGNETO_ON));
            }
            for (i = 0; i < this.starterButtonCoords.length; i = (int)((byte)(i + 1))) {
                if (this.engines[i] == null || mouseX <= this.starterButtonCoords[i][0] || mouseX >= this.starterButtonCoords[i][1] || mouseY >= this.starterButtonCoords[i][2] || mouseY <= this.starterButtonCoords[i][3]) continue;
                if (!this.engines[i].state.esOn) {
                    MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(this.engines[i], PacketPartEngineSignal.PacketEngineTypes.ES_ON));
                }
                this.lastEngineStarted = (byte)i;
            }
            if (this.aircraft instanceof EntityVehicleF_Plane && mouseX > this.reverseButtonCoords[0] && mouseX < this.reverseButtonCoords[1] && mouseY < this.reverseButtonCoords[2] && mouseY > this.reverseButtonCoords[3]) {
                MTS.MTSNet.sendToServer((IMessage)new ReverseThrustPacket(this.aircraft.func_145782_y(), !((EntityVehicleF_Plane)this.aircraft).reverseThrust));
                MTS.proxy.playSound(this.aircraft.func_174791_d(), "mts:panel_buzzer", 1.0f, 1.0f);
            }
            this.lastButtonPressed = null;
            for (GuiButton button : this.field_146292_n) {
                if (!button.func_146115_a()) continue;
                this.lastButtonPressed = button;
                return;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int actionType) {
        if (actionType == 0) {
            if (this.lastEngineStarted != -1 && this.starterButtonCoords.length > 0) {
                MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(this.engines[this.lastEngineStarted], PacketPartEngineSignal.PacketEngineTypes.ES_OFF));
            }
            this.lastButtonPressed = null;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.lastButtonPressed != null) {
            if (this.lastButtonPressed.equals(this.aileronTrimUpButton)) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(this.aircraft.func_145782_y(), 0));
            } else if (this.lastButtonPressed.equals(this.aileronTrimDownButton)) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(this.aircraft.func_145782_y(), 8));
            } else if (this.lastButtonPressed.equals(this.elevatorTrimUpButton)) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(this.aircraft.func_145782_y(), 9));
            } else if (this.lastButtonPressed.equals(this.elevatorTrimDownButton)) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(this.aircraft.func_145782_y(), 1));
            } else if (this.lastButtonPressed.equals(this.rudderTrimUpButton)) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(this.aircraft.func_145782_y(), 2));
            } else if (this.lastButtonPressed.equals(this.rudderTrimDownButton)) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(this.aircraft.func_145782_y(), 10));
            }
        }
    }

    public void func_146281_b() {
        CameraSystem.disableHUD = false;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) || this.field_146297_k.field_71474_y.field_74311_E.isActiveAndMatches(keyCode)) {
            super.func_73869_a('0', 1);
        }
    }
}

