/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.pole.BlockPoleSign;
import minecrafttransportsimulator.blocks.pole.TileEntityPoleSign;
import minecrafttransportsimulator.dataclasses.PackSignObject;
import minecrafttransportsimulator.packets.tileentities.PacketSignChange;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GUISign
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("mts", "textures/guis/crafting.png");
    private final EntityPlayer player;
    private final TileEntityPoleSign decor;
    private final TileEntityPoleSign decorTemp;
    private final List<GuiTextField> signTextBoxes = new ArrayList<GuiTextField>();
    private GuiButton leftPackButton;
    private GuiButton rightPackButton;
    private GuiButton leftSignButton;
    private GuiButton rightSignButton;
    private GuiButton startButton;
    private GuiButton textButton;
    private int guiLeft;
    private int guiTop;
    private String packName = "";
    private String prevPackName = "";
    private String nextPackName = "";
    private String signName = "";
    private String prevSignName = "";
    private String nextSignName = "";
    private PackSignObject pack;

    public GUISign(BlockPoleSign block, EntityPlayer player) {
        this.decor = (TileEntityPoleSign)player.field_70170_p.func_175625_s(block.lastClickedPos);
        this.decorTemp = new TileEntityPoleSign();
        this.player = player;
        if (!this.decor.definition.isEmpty()) {
            this.packName = this.decor.definition.substring(0, this.decor.definition.indexOf(58));
            this.signName = this.decor.definition;
        }
        this.updateSignNames();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 220) / 2;
        this.leftPackButton = new GuiButton(0, this.guiLeft + 25, this.guiTop + 5, 20, 20, "<");
        this.field_146292_n.add(this.leftPackButton);
        this.rightPackButton = new GuiButton(0, this.guiLeft + 215, this.guiTop + 5, 20, 20, ">");
        this.field_146292_n.add(this.rightPackButton);
        this.leftSignButton = new GuiButton(0, this.guiLeft + 25, this.guiTop + 25, 20, 20, "<");
        this.field_146292_n.add(this.leftSignButton);
        this.rightSignButton = new GuiButton(0, this.guiLeft + 215, this.guiTop + 25, 20, 20, ">");
        this.field_146292_n.add(this.rightSignButton);
        this.startButton = new GuiButton(0, this.guiLeft + 188, this.guiTop + 170, 20, 20, "");
        this.field_146292_n.add(this.startButton);
        this.textButton = new GuiButton(0, this.guiLeft + 8, this.guiTop + 55, 126, 108, "");
        this.field_146292_n.add(this.textButton);
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            this.signTextBoxes.add(new GuiTextField(0, this.field_146289_q, this.guiLeft + 9, this.guiTop + 54 + i * 10, 125, 10));
            this.signTextBoxes.get(i).func_146184_c(false);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 201);
        if (this.startButton.field_146124_l) {
            this.func_73729_b(this.guiLeft + 140, this.guiTop + 173, 0, 201, 44, 16);
        }
        this.drawCenteredString(!this.packName.isEmpty() ? I18n.func_135052_a((String)("itemGroup." + this.packName), (Object[])new Object[0]) : "", this.guiLeft + 130, this.guiTop + 10);
        this.drawCenteredString(!this.signName.isEmpty() ? I18n.func_135052_a((String)("sign." + this.packName + "." + this.signName.substring(this.signName.indexOf(58) + 1) + ".name"), (Object[])new Object[0]) : "", this.guiLeft + 130, this.guiTop + 30);
        this.startButton.field_146124_l = !this.signName.isEmpty();
        this.leftPackButton.field_146124_l = !this.prevPackName.isEmpty();
        this.rightPackButton.field_146124_l = !this.nextPackName.isEmpty();
        this.leftSignButton.field_146124_l = !this.prevSignName.isEmpty();
        this.rightSignButton.field_146124_l = !this.nextSignName.isEmpty();
        this.textButton.field_146124_l = !this.signName.isEmpty() && this.pack.general.textLines != null;
        for (GuiButton button : this.field_146292_n) {
            if (button.equals(this.textButton)) continue;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        GUISign.func_73734_a((int)(this.guiLeft + 190), (int)(this.guiTop + 188), (int)(this.guiLeft + 206), (int)(this.guiTop + 172), (int)(this.startButton.field_146124_l ? Color.GREEN.getRGB() : Color.RED.getRGB()));
        if (!this.signName.isEmpty()) {
            this.decorTemp.definition = this.signName;
            if (this.pack.general.textLines != null) {
                for (int i = 0; i < PackParserSystem.getSign((String)this.decorTemp.definition).general.textLines.length; i = (int)((byte)(i + 1))) {
                    if (this.decor.definition.equals(this.decorTemp.definition) && this.decor.text.size() > i) {
                        this.decorTemp.text.add(this.decor.text.get(i));
                        continue;
                    }
                    this.decorTemp.text.add("");
                }
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)(this.guiLeft + 196), (float)(this.guiTop + 107), (float)100.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = -90.0f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)this.decorTemp, -0.5, -0.5, -0.5, renderPartialTicks);
            GL11.glPopMatrix();
            if (this.pack.general.textLines != null) {
                for (int i = 0; i < this.pack.general.textLines.length; i = (int)((byte)(i + 1))) {
                    GuiTextField textBox = this.signTextBoxes.get(i);
                    textBox.func_146180_a(this.decorTemp.text.get(i));
                    textBox.func_146203_f((int)this.pack.general.textLines[i].characters);
                    textBox.func_146194_f();
                    textBox.func_146184_c(true);
                }
            }
        }
    }

    protected void func_146284_a(GuiButton buttonClicked) throws IOException {
        super.func_146284_a(buttonClicked);
        if (buttonClicked.equals(this.startButton)) {
            MTS.MTSNet.sendToServer((IMessage)new PacketSignChange(this.decor, this.signName, this.decorTemp.text));
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (buttonClicked.equals(this.leftPackButton)) {
            this.packName = this.prevPackName;
            this.signName = "";
        } else if (buttonClicked.equals(this.rightPackButton)) {
            this.packName = this.nextPackName;
            this.signName = "";
        } else if (buttonClicked.equals(this.leftSignButton)) {
            this.signName = this.prevSignName;
        } else if (buttonClicked.equals(this.rightSignButton)) {
            this.signName = this.nextSignName;
        }
        this.updateSignNames();
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        for (GuiTextField box : this.signTextBoxes) {
            if (!box.func_146176_q()) continue;
            box.func_146192_a(x, y, button);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            super.func_73869_a('0', 1);
        } else {
            for (int i = 0; i < this.signTextBoxes.size(); i = (int)((byte)(i + 1))) {
                GuiTextField box;
                if (this.decorTemp.text.size() <= i || !(box = this.signTextBoxes.get(i)).func_146201_a(typedChar, keyCode)) continue;
                this.decorTemp.text.set(i, box.func_146179_b());
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawCenteredString(String stringToDraw, int x, int y) {
        this.field_146289_q.func_78276_b(stringToDraw, x - this.field_146289_q.func_78256_a(stringToDraw) / 2, y, 0x404040);
    }

    private void updateSignNames() {
        this.prevPackName = "";
        this.nextPackName = "";
        this.prevSignName = "";
        this.nextSignName = "";
        boolean passedPack = false;
        boolean passedSign = false;
        for (String signFullName : PackParserSystem.getAllSigns()) {
            if (this.packName.isEmpty()) {
                this.packName = signFullName.substring(0, signFullName.indexOf(58));
            } else if (!passedPack && !signFullName.startsWith(this.packName)) {
                this.prevPackName = signFullName.substring(0, signFullName.indexOf(58));
            }
            if (signFullName.startsWith(this.packName)) {
                passedPack = true;
                if (this.signName.isEmpty()) {
                    this.signName = signFullName;
                    passedSign = true;
                    continue;
                }
                if (this.signName.equals(signFullName)) {
                    passedSign = true;
                    continue;
                }
                if (!passedSign) {
                    this.prevSignName = signFullName;
                    continue;
                }
                if (!this.nextSignName.isEmpty()) continue;
                this.nextSignName = signFullName;
                continue;
            }
            if (!this.nextPackName.isEmpty() || !passedPack) continue;
            this.nextPackName = signFullName.substring(0, signFullName.indexOf(58));
        }
        if (this.signName != null) {
            this.pack = PackParserSystem.getSign(this.signName);
            for (GuiTextField textBox : this.signTextBoxes) {
                textBox.func_146180_a("");
                textBox.func_146184_c(false);
            }
            this.decorTemp.text.clear();
        }
    }
}

