/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.parts;

import java.util.List;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPartBullet
extends AItemPart {
    public final PackPartObject.PartBulletConfig bulletPackData;

    public ItemPartBullet(String partName) {
        super(partName);
        this.bulletPackData = PackParserSystem.getPartPack((String)partName).bullet;
    }

    @Override
    public boolean isPartValidForPackDef(PackVehicleObject.PackPart packPart) {
        float bulletDiameter = PackParserSystem.getPartPack((String)this.partName).bullet.diameter;
        return packPart.minValue <= bulletDiameter && packPart.maxValue >= bulletDiameter ? super.isPartValidForPackDef(packPart) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltipLines, boolean p_77624_4_) {
        PackPartObject pack = PackParserSystem.getPartPack(((ItemPartBullet)stack.func_77973_b()).partName);
        tooltipLines.add(I18n.func_135052_a((String)("info.item.bullet.type." + this.bulletPackData.type), (Object[])new Object[0]));
        tooltipLines.add(I18n.func_135052_a((String)"info.item.bullet.diameter", (Object[])new Object[0]) + pack.bullet.diameter);
        tooltipLines.add(I18n.func_135052_a((String)"info.item.bullet.quantity", (Object[])new Object[0]) + pack.bullet.quantity);
    }
}

