/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.control;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RudderPacket
implements IMessage {
    private int id;
    private byte packetType;
    private short rudderData;

    public RudderPacket() {
    }

    public RudderPacket(int id, boolean increment, short rudderCooldown) {
        this.id = id;
        this.rudderData = rudderCooldown;
        this.packetType = (byte)(increment ? 1 : -1);
    }

    public RudderPacket(int id, short rudderAngle) {
        this.id = id;
        this.rudderData = rudderAngle;
        this.packetType = 0;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.packetType = buf.readByte();
        this.rudderData = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte((int)this.packetType);
        buf.writeShort((int)this.rudderData);
    }

    public static class Handler
    implements IMessageHandler<RudderPacket, IMessage> {
        public IMessage onMessage(final RudderPacket message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    EntityVehicleF_Plane thisEntity;
                    if (ctx.side.isServer()) {
                        thisEntity = (EntityVehicleF_Plane)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id);
                    } else {
                        if (Minecraft.func_71410_x().field_71441_e == null) {
                            return;
                        }
                        thisEntity = (EntityVehicleF_Plane)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
                    }
                    if (thisEntity == null) return;
                    if (message.packetType == 1) {
                        thisEntity.rudderCooldown = message.rudderData;
                        if (thisEntity.rudderAngle + 6 > 250) return;
                        thisEntity.rudderAngle = (short)(thisEntity.rudderAngle + 6);
                    } else if (message.packetType == -1) {
                        thisEntity.rudderCooldown = message.rudderData;
                        if (thisEntity.rudderAngle - 6 < -250) return;
                        thisEntity.rudderAngle = (short)(thisEntity.rudderAngle - 6);
                    } else {
                        thisEntity.rudderAngle = message.rudderData;
                        thisEntity.rudderCooldown = Short.MAX_VALUE;
                    }
                    if (!ctx.side.isServer()) return;
                    MTS.MTSNet.sendToAll((IMessage)message);
                }
            });
            return null;
        }
    }
}

