/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.control;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SteeringPacket
implements IMessage {
    private int id;
    private byte packetType;
    private short steeringData;

    public SteeringPacket() {
    }

    public SteeringPacket(int id, boolean increment, short steeringCooldown) {
        this.id = id;
        this.steeringData = steeringCooldown;
        this.packetType = (byte)(increment ? 1 : -1);
    }

    public SteeringPacket(int id, short steeringAngle) {
        this.id = id;
        this.steeringData = steeringAngle;
        this.packetType = 0;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.packetType = buf.readByte();
        this.steeringData = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte((int)this.packetType);
        buf.writeShort((int)this.steeringData);
    }

    public static class Handler
    implements IMessageHandler<SteeringPacket, IMessage> {
        public IMessage onMessage(final SteeringPacket message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    EntityVehicleF_Car vehicle;
                    if (ctx.side.isServer()) {
                        vehicle = (EntityVehicleF_Car)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id);
                    } else {
                        if (Minecraft.func_71410_x().field_71441_e == null) {
                            return;
                        }
                        vehicle = (EntityVehicleF_Car)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
                    }
                    if (vehicle == null) return;
                    if (message.packetType == 1) {
                        vehicle.steeringCooldown = message.steeringData;
                        if (vehicle.steeringAngle + 20 > 450) return;
                        vehicle.steeringAngle = (short)(vehicle.steeringAngle + 20);
                    } else if (message.packetType == -1) {
                        vehicle.steeringCooldown = message.steeringData;
                        if (vehicle.steeringAngle - 20 < -450) return;
                        vehicle.steeringAngle = (short)(vehicle.steeringAngle - 20);
                    } else {
                        vehicle.steeringAngle = message.steeringData;
                        vehicle.steeringCooldown = Short.MAX_VALUE;
                    }
                    if (!ctx.side.isServer()) return;
                    MTS.MTSNet.sendToAll((IMessage)message);
                }
            });
            return null;
        }
    }
}

