/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.parts;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.packets.parts.APacketPart;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPartInteraction
extends APacketPart {
    private int player;

    public PacketPartInteraction() {
    }

    public PacketPartInteraction(APart part, int player) {
        super(part);
        this.player = player;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.player = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.player);
    }

    public static class Handler
    implements IMessageHandler<PacketPartInteraction, IMessage> {
        public IMessage onMessage(final PacketPartInteraction message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    APart part = APacketPart.getVehiclePartFromMessage(message, ctx);
                    EntityPlayer player = (EntityPlayer)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.player);
                    if (part != null && player != null) {
                        part.interactPart(player);
                    }
                }
            });
            return null;
        }
    }
}

