/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.vehicles;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.packets.vehicles.APacketVehicle;
import minecrafttransportsimulator.packets.vehicles.APacketVehiclePart;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientPartAddition;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleA_Base;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVehicleServerPartAddition
extends APacketVehiclePart {
    private int player;

    public PacketVehicleServerPartAddition() {
    }

    public PacketVehicleServerPartAddition(EntityVehicleA_Base vehicle, double offsetX, double offsetY, double offsetZ, EntityPlayer player) {
        super(vehicle, offsetX, offsetY, offsetZ);
        this.player = player.func_145782_y();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.player = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.player);
    }

    public static class Handler
    implements IMessageHandler<PacketVehicleServerPartAddition, IMessage> {
        public IMessage onMessage(final PacketVehicleServerPartAddition message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityVehicleA_Base vehicle = APacketVehicle.getVehicle(message, ctx);
                    EntityPlayer player = ctx.side.isServer() ? (EntityPlayer)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.player) : (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.player);
                    ItemStack heldStack = player.func_184614_ca();
                    if (heldStack != null && heldStack.func_77973_b() instanceof AItemPart) {
                        AItemPart partItem = (AItemPart)heldStack.func_77973_b();
                        PackVehicleObject.PackPart packPart = vehicle.getPackDefForLocation(message.offsetX, message.offsetY, message.offsetZ);
                        PackPartObject itemPack = PackParserSystem.getPartPack(partItem.partName);
                        if (packPart.types.contains(itemPack.general.type)) {
                            Vec3d partOffset = new Vec3d(message.offsetX, message.offsetY, message.offsetZ);
                            for (APart part : vehicle.getVehicleParts()) {
                                if (!part.offset.equals((Object)partOffset)) continue;
                                return;
                            }
                            PackParserSystem.getPartPack(partItem.partName);
                            if (!partItem.isPartValidForPackDef(packPart)) {
                                return;
                            }
                            try {
                                Class<? extends APart> partClass = PackParserSystem.getPartPartClass(partItem.partName);
                                Constructor<? extends APart> construct = partClass.getConstructor(EntityVehicleE_Powered.class, PackVehicleObject.PackPart.class, String.class, NBTTagCompound.class);
                                APart newPart = construct.newInstance(new Object[]{(EntityVehicleE_Powered)vehicle, packPart, partItem.partName, heldStack.func_77942_o() ? heldStack.func_77978_p() : new NBTTagCompound()});
                                vehicle.addPart(newPart, false);
                                MTS.MTSNet.sendToAll((IMessage)new PacketVehicleClientPartAddition(vehicle, message.offsetX, message.offsetY, message.offsetZ, heldStack));
                                if (!player.field_71075_bZ.field_75098_d) {
                                    player.field_71071_by.func_174925_a((Item)partItem, heldStack.func_77952_i(), 1, heldStack.func_77978_p());
                                }
                            }
                            catch (Exception e) {
                                MTS.MTSLog.error("ERROR SPAWING PART ON SERVER!");
                                MTS.MTSLog.error(e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            return null;
        }
    }
}

