/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import minecrafttransportsimulator.dataclasses.MTSControls;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.rendering.RenderControls;
import minecrafttransportsimulator.rendering.RenderInstruments;
import minecrafttransportsimulator.rendering.RenderVehicle;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public final class RenderHUD {
    public static final int screenDefaultX = 854;
    public static final int screenDefaultY = 480;

    public static void drawMainHUD(EntityVehicleE_Powered vehicle, boolean inGUI) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderVehicle.getTextureForVehicle(vehicle));
        if (!inGUI) {
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
        if (CameraSystem.hudMode == 3 || inGUI) {
            RenderHUD.drawLowerPanel(vehicle.pack.rendering.hudBackplaneTexturePercentages);
        } else {
            GL11.glTranslatef((float)0.0f, (float)120.0f, (float)0.0f);
        }
        if (CameraSystem.hudMode == 2 || CameraSystem.hudMode == 3 || inGUI) {
            RenderHUD.drawUpperPanel(vehicle.pack.rendering.hudBackplaneTexturePercentages, vehicle.pack.rendering.hudMouldingTexturePercentages);
        }
        if (CameraSystem.hudMode > 0 || inGUI) {
            RenderHUD.drawInstruments(vehicle, CameraSystem.hudMode == 1 && !inGUI ? 25 : 0, CameraSystem.hudMode == 1 && !inGUI ? 75 : 100, CameraSystem.hudMode != 3 && !inGUI ? 75 : 100, true);
        }
        if (CameraSystem.hudMode > 1 && !inGUI) {
            RenderHUD.drawControls(vehicle, inGUI);
        }
        if (!inGUI) {
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
        GL11.glPopMatrix();
    }

    public static void drawAuxiliaryHUD(EntityVehicleE_Powered vehicle, int width, int height, boolean inGUI) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderVehicle.getTextureForVehicle(vehicle));
        if (!inGUI) {
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
        RenderHUD.drawAuxiliaryPanel(vehicle.pack.rendering.hudBackplaneTexturePercentages, vehicle.pack.rendering.hudMouldingTexturePercentages);
        RenderHUD.drawInstruments(vehicle, 0, 100, 100, false);
        if (!inGUI) {
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
        GL11.glPopMatrix();
    }

    private static void drawInstruments(EntityVehicleE_Powered vehicle, int minX, int maxX, int maxY, boolean main) {
        for (byte i = 0; i < vehicle.pack.motorized.instruments.size(); i = (byte)((byte)(i + 1))) {
            PackVehicleObject.PackInstrument packInstrument = vehicle.pack.motorized.instruments.get(i);
            if ((packInstrument.optionalEngineNumber != 0 || !main) && (packInstrument.optionalEngineNumber == 0 || main) || packInstrument.hudpos == null || !(packInstrument.hudpos[0] >= (float)minX) || !(packInstrument.hudpos[0] <= (float)maxX) || !(packInstrument.hudpos[1] <= (float)maxY)) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)(packInstrument.hudpos[0] * 854.0f) / 100.0), (double)((double)(packInstrument.hudpos[1] * 480.0f) / 100.0), (double)0.0);
            GL11.glScalef((float)packInstrument.hudScale, (float)packInstrument.hudScale, (float)packInstrument.hudScale);
            EntityVehicleE_Powered.VehicleInstrument instrument = vehicle.getInstrumentInfoInSlot(i);
            if (instrument != null) {
                RenderInstruments.drawInstrument(vehicle, instrument, true, packInstrument.optionalEngineNumber);
            }
            GL11.glPopMatrix();
        }
    }

    private static void drawControls(EntityVehicleE_Powered vehicle, boolean inGUI) {
        for (int i = 0; i < vehicle.pack.motorized.controls.size(); i = (int)((byte)(i + 1))) {
            PackVehicleObject.PackControl packControl = vehicle.pack.motorized.controls.get(i);
            for (MTSControls.Controls control : MTSControls.Controls.values()) {
                if (!control.name().toLowerCase().equals(packControl.controlName)) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(packControl.hudpos[0] * 854 / 100), (double)(packControl.hudpos[1] * 480 / 100), (double)0.0);
                RenderControls.drawControl(vehicle, control, !inGUI);
                GL11.glPopMatrix();
            }
        }
    }

    private static void drawUpperPanel(float[] backplanePercentages, float[] mouldingPercentages) {
        GL11.glBegin((int)8);
        GL11.glTexCoord2f((float)backplanePercentages[0], (float)(backplanePercentages[2] + 0.5f * (backplanePercentages[3] - backplanePercentages[2])));
        GL11.glVertex2d((double)0.0, (double)300.0);
        GL11.glTexCoord2f((float)backplanePercentages[0], (float)backplanePercentages[3]);
        GL11.glVertex2d((double)0.0, (double)360.0);
        GL11.glTexCoord2f((float)(backplanePercentages[0] + 0.25f * (backplanePercentages[1] - backplanePercentages[0])), (float)backplanePercentages[2]);
        GL11.glVertex2d((double)213.0, (double)240.0);
        GL11.glTexCoord2f((float)(backplanePercentages[0] + 0.25f * (backplanePercentages[1] - backplanePercentages[0])), (float)backplanePercentages[3]);
        GL11.glVertex2d((double)213.0, (double)360.0);
        GL11.glTexCoord2f((float)(backplanePercentages[0] + 0.75f * (backplanePercentages[1] - backplanePercentages[0])), (float)backplanePercentages[2]);
        GL11.glVertex2d((double)640.0, (double)240.0);
        GL11.glTexCoord2f((float)(backplanePercentages[0] + 0.75f * (backplanePercentages[1] - backplanePercentages[0])), (float)backplanePercentages[3]);
        GL11.glVertex2d((double)640.0, (double)360.0);
        GL11.glTexCoord2f((float)backplanePercentages[1], (float)(backplanePercentages[2] + 0.5f * (backplanePercentages[3] - backplanePercentages[2])));
        GL11.glVertex2d((double)854.0, (double)300.0);
        GL11.glTexCoord2f((float)backplanePercentages[1], (float)backplanePercentages[3]);
        GL11.glVertex2d((double)854.0, (double)360.0);
        GL11.glEnd();
        GL11.glBegin((int)8);
        GL11.glTexCoord2f((float)mouldingPercentages[0], (float)mouldingPercentages[2]);
        GL11.glVertex2d((double)0.0, (double)284.0);
        GL11.glTexCoord2f((float)mouldingPercentages[0], (float)mouldingPercentages[3]);
        GL11.glVertex2d((double)0.0, (double)300.0);
        GL11.glTexCoord2f((float)(mouldingPercentages[0] + 0.25f * (mouldingPercentages[1] - mouldingPercentages[0])), (float)mouldingPercentages[2]);
        GL11.glVertex2d((double)213.0, (double)224.0);
        GL11.glTexCoord2f((float)(mouldingPercentages[0] + 0.25f * (mouldingPercentages[1] - mouldingPercentages[0])), (float)mouldingPercentages[3]);
        GL11.glVertex2d((double)213.0, (double)240.0);
        GL11.glTexCoord2f((float)(mouldingPercentages[0] + 0.75f * (mouldingPercentages[1] - mouldingPercentages[0])), (float)mouldingPercentages[2]);
        GL11.glVertex2d((double)640.0, (double)224.0);
        GL11.glTexCoord2f((float)(mouldingPercentages[0] + 0.75f * (mouldingPercentages[1] - mouldingPercentages[0])), (float)mouldingPercentages[3]);
        GL11.glVertex2d((double)640.0, (double)240.0);
        GL11.glTexCoord2f((float)mouldingPercentages[1], (float)mouldingPercentages[2]);
        GL11.glVertex2d((double)854.0, (double)284.0);
        GL11.glTexCoord2f((float)mouldingPercentages[1], (float)mouldingPercentages[3]);
        GL11.glVertex2d((double)854.0, (double)300.0);
        GL11.glEnd();
    }

    private static void drawLowerPanel(float[] backplanePercentages) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)backplanePercentages[0], (float)backplanePercentages[2]);
        GL11.glVertex2d((double)0.0, (double)360.0);
        GL11.glTexCoord2f((float)backplanePercentages[0], (float)backplanePercentages[3]);
        GL11.glVertex2d((double)0.0, (double)480.0);
        GL11.glTexCoord2f((float)backplanePercentages[1], (float)backplanePercentages[3]);
        GL11.glVertex2d((double)854.0, (double)480.0);
        GL11.glTexCoord2f((float)backplanePercentages[1], (float)backplanePercentages[2]);
        GL11.glVertex2d((double)854.0, (double)360.0);
        GL11.glEnd();
    }

    private static void drawAuxiliaryPanel(float[] backplanePercentages, float[] mouldingPercentages) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)backplanePercentages[0], (float)backplanePercentages[2]);
        GL11.glVertex2d((double)0.0, (double)256.0);
        GL11.glTexCoord2f((float)backplanePercentages[0], (float)backplanePercentages[3]);
        GL11.glVertex2d((double)0.0, (double)480.0);
        GL11.glTexCoord2f((float)backplanePercentages[1], (float)backplanePercentages[3]);
        GL11.glVertex2d((double)854.0, (double)480.0);
        GL11.glTexCoord2f((float)backplanePercentages[1], (float)backplanePercentages[2]);
        GL11.glVertex2d((double)854.0, (double)256.0);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)mouldingPercentages[0], (float)mouldingPercentages[2]);
        GL11.glVertex2d((double)0.0, (double)240.0);
        GL11.glTexCoord2f((float)mouldingPercentages[0], (float)mouldingPercentages[3]);
        GL11.glVertex2d((double)0.0, (double)256.0);
        GL11.glTexCoord2f((float)mouldingPercentages[1], (float)mouldingPercentages[3]);
        GL11.glVertex2d((double)854.0, (double)256.0);
        GL11.glTexCoord2f((float)mouldingPercentages[1], (float)mouldingPercentages[2]);
        GL11.glVertex2d((double)854.0, (double)240.0);
        GL11.glEnd();
    }
}

