/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.dataclasses.PackInstrumentObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import minecrafttransportsimulator.vehicles.parts.PartEngineCar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class RenderInstruments {
    protected static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    protected static final ResourceLocation controlsTexture = new ResourceLocation("mts", "textures/controls_aircraft.png");
    private static Map<String, Map<String, ResourceLocation>> instrumentTextureSheets = new HashMap<String, Map<String, ResourceLocation>>();

    public static void drawInstrument(EntityVehicleE_Powered vehicle, EntityVehicleE_Powered.VehicleInstrument instrument, boolean hud, byte engineNumber) {
        if (!instrumentTextureSheets.containsKey(vehicle.pack.general.type)) {
            instrumentTextureSheets.put(vehicle.pack.general.type, new HashMap());
        }
        if (!instrumentTextureSheets.get(vehicle.pack.general.type).containsKey(instrument.name)) {
            instrumentTextureSheets.get(vehicle.pack.general.type).put(instrument.name, new ResourceLocation(instrument.name.substring(0, instrument.name.indexOf(58)), "textures/instruments/" + vehicle.pack.general.type + ".png"));
        }
        textureManager.func_110577_a(instrumentTextureSheets.get(vehicle.pack.general.type).get(instrument.name));
        float textureUStart = (float)(instrument.pack.general.textureXSectorStart - 1) / 8.0f;
        float textureVStart = (float)(instrument.pack.general.textureYSectorStart - 1) / 8.0f;
        if (hud) {
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)0.0f);
        }
        boolean lightsOn = RenderInstruments.lightsOn(vehicle);
        if (engineNumber > 0) {
            engineNumber = (byte)(engineNumber - 1);
        }
        int currentLayer = 0;
        for (PackInstrumentObject.PackInstrumentComponent component : instrument.pack.components) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-currentLayer) * 0.1f));
            if (lightsOn) {
                Minecraft.func_71410_x().field_71460_t.func_175072_h();
            } else {
                Minecraft.func_71410_x().field_71460_t.func_180436_i();
            }
            float layerHeight = 128.0f;
            float layerUStart = textureUStart;
            float layerUEnd = textureUStart + 0.125f;
            float layerVStart = textureVStart + (float)currentLayer / 8.0f;
            float layerVEnd = textureVStart + (float)(1 + currentLayer) / 8.0f;
            if (component.rotationVariable != null && !component.rotationVariable.isEmpty()) {
                double rotation = (double)component.rotationOffset + RenderInstruments.getVariableValue(vehicle, component.rotationVariable, engineNumber) * (double)component.rotationFactor;
                GL11.glTranslatef((float)(-component.xRotationPositionOffset), (float)component.yRotationPositionOffset, (float)0.0f);
                GL11.glRotated((double)rotation, (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslatef((float)component.xRotationPositionOffset, (float)(-component.yRotationPositionOffset), (float)0.0f);
            }
            if (component.visibilityVariable != null && !component.visibilityVariable.isEmpty()) {
                double height = RenderInstruments.getVariableValue(vehicle, component.visibilityVariable, engineNumber) * (double)component.visibilityFactor;
                if (!component.dynamicVisibility) {
                    layerHeight = component.visibleSectionHeight;
                    layerVEnd = (layerVStart += (float)(((double)(64.0f + component.visibilityOffset) + height - (double)((float)component.visibleSectionHeight / 2.0f)) / 1024.0)) + (float)component.visibleSectionHeight / 1024.0f;
                } else {
                    layerHeight = (float)((double)component.visibilityOffset + height);
                    layerVEnd = (layerVStart += component.visibilityOffset / 1024.0f) + layerHeight / 1024.0f;
                    GL11.glTranslatef((float)0.0f, (float)(layerHeight / 2.0f), (float)0.0f);
                }
            }
            if (!component.lightOverlay) {
                RenderInstruments.renderSquareUV(128.0f, layerHeight, 0.0f, layerUStart, layerUEnd, layerVStart, layerVEnd);
            } else if (lightsOn) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                RenderInstruments.renderSquareUV(128.0f, layerHeight, 0.0f, layerUStart, layerUEnd, layerVStart, layerVEnd);
            }
            currentLayer = (byte)(currentLayer + 1);
            GL11.glPopMatrix();
        }
        if (lightsOn) {
            GL11.glBlendFunc((int)770, (int)771);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        }
    }

    private static double getVariableValue(EntityVehicleE_Powered vehicle, String variable, byte engineNumber) {
        switch (variable) {
            case "yaw": {
                return -vehicle.field_70177_z;
            }
            case "pitch": {
                return Math.max(Math.min(vehicle.field_70125_A, 25.0f), -25.0f);
            }
            case "roll": {
                return vehicle.rotationRoll;
            }
            case "altitude": {
                return vehicle.field_70163_u - (double)(ConfigSystem.getBooleanConfig("SeaLevelOffset") ? vehicle.field_70170_p.field_73011_w.func_76557_i() : 0);
            }
            case "speed": {
                return Math.abs(vehicle.velocity * vehicle.speedFactor * 20.0);
            }
            case "turn_coordinator": {
                return Math.max(Math.min(((vehicle.rotationRoll - vehicle.prevRotationRoll) / 10.0f + vehicle.field_70177_z - vehicle.field_70126_B) / 0.15f * 25.0f, 50.0f), -50.0f);
            }
            case "turn_indicator": {
                return Math.max(Math.min((vehicle.field_70177_z - vehicle.field_70126_B) / 0.15f * 25.0f, 50.0f), -50.0f);
            }
            case "slip": {
                return 75.0 * ((EntityVehicleF_Plane)vehicle).sideVec.func_72430_b(vehicle.velocityVec);
            }
            case "vertical_speed": {
                return vehicle.field_70181_x * 20.0;
            }
            case "lift_reserve": {
                return Math.max(Math.min(((EntityVehicleF_Plane)vehicle).trackAngle * 3.0 + 20.0, 35.0), -35.0);
            }
            case "trim_rudder": {
                return (float)((EntityVehicleF_Plane)vehicle).rudderTrim / 10.0f;
            }
            case "trim_elevator": {
                return (float)((EntityVehicleF_Plane)vehicle).elevatorTrim / 10.0f;
            }
            case "trim_aileron": {
                return (float)((EntityVehicleF_Plane)vehicle).aileronTrim / 10.0f;
            }
            case "electric_power": {
                return vehicle.electricPower;
            }
            case "electric_usage": {
                return Math.min(vehicle.electricFlow * 20.0, 1.0);
            }
            case "fuel": {
                return vehicle.fuel / (double)vehicle.pack.motorized.fuelCapacity * 100.0;
            }
            case "rpm": {
                return vehicle.getEngineByNumber(engineNumber) != null ? (vehicle.getEngineByNumber((byte)engineNumber).pack.engine.maxRPM < 15000 ? vehicle.getEngineByNumber((byte)engineNumber).RPM : vehicle.getEngineByNumber((byte)engineNumber).RPM / 10.0) : 0.0;
            }
            case "rpm_max": {
                return vehicle.getEngineByNumber(engineNumber) != null ? (vehicle.getEngineByNumber((byte)engineNumber).pack.engine.maxRPM < 15000 ? (double)APartEngine.getSafeRPMFromMax(vehicle.getEngineByNumber((byte)engineNumber).pack.engine.maxRPM) : (double)APartEngine.getSafeRPMFromMax(vehicle.getEngineByNumber((byte)engineNumber).pack.engine.maxRPM) / 10.0) : 0.0;
            }
            case "fuel_flow": {
                return vehicle.getEngineByNumber(engineNumber) != null ? vehicle.getEngineByNumber((byte)engineNumber).fuelFlow * 20.0 * 60.0 / 1000.0 : 0.0;
            }
            case "temp": {
                return vehicle.getEngineByNumber(engineNumber) != null ? vehicle.getEngineByNumber((byte)engineNumber).temp : 0.0;
            }
            case "oil": {
                return vehicle.getEngineByNumber(engineNumber) != null ? vehicle.getEngineByNumber((byte)engineNumber).oilPressure : 0.0;
            }
            case "gear": {
                return vehicle.getEngineByNumber(engineNumber) != null ? (double)((PartEngineCar)vehicle.getEngineByNumber((byte)engineNumber)).currentGear : 0.0;
            }
        }
        return 0.0;
    }

    public static boolean lightsOn(EntityVehicleE_Powered vehicle) {
        return (vehicle.isLightOn(EntityVehicleE_Powered.LightTypes.NAVIGATIONLIGHT) || vehicle.isLightOn(EntityVehicleE_Powered.LightTypes.HEADLIGHT)) && vehicle.electricPower > 3.0;
    }

    protected static void renderSquareUV(float width, float height, float depth, float u, float U, float v, float V) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)u, (float)v);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(width / 2.0f), (float)(height / 2.0f), (float)(depth / 2.0f));
        GL11.glTexCoord2f((float)u, (float)V);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(width / 2.0f), (float)(-height / 2.0f), (float)(-depth / 2.0f));
        GL11.glTexCoord2f((float)U, (float)V);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-width / 2.0f), (float)(-height / 2.0f), (float)(-depth / 2.0f));
        GL11.glTexCoord2f((float)U, (float)v);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-width / 2.0f), (float)(height / 2.0f), (float)(depth / 2.0f));
        GL11.glEnd();
    }

    protected static void drawScaledString(String string, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(string, x, y, Color.WHITE.getRGB());
        GL11.glPopMatrix();
    }
}

