/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.blockrenders;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.blocks.core.TileEntityTrafficSignalController;
import minecrafttransportsimulator.blocks.pole.BlockPoleAttachment;
import minecrafttransportsimulator.blocks.pole.TileEntityPoleWallConnector;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import org.lwjgl.opengl.GL11;

public class RenderPoleLighted
extends TileEntitySpecialRenderer<TileEntityPoleWallConnector> {
    private static final ResourceLocation vanillaGlassTexture = new ResourceLocation("minecraft", "textures/blocks/glass.png");
    private static final ResourceLocation lensFlareTexture = new ResourceLocation("mts", "textures/rendering/lensflare.png");
    private static final ResourceLocation lightTexture = new ResourceLocation("mts", "textures/rendering/light.png");
    private static final ResourceLocation lightBeamTexture = new ResourceLocation("mts", "textures/rendering/lightbeam.png");
    private static final Map<BlockPos, BlockPos> trafficSignalControllers = new HashMap<BlockPos, BlockPos>();
    private static final Map<BlockPos, Integer> checkIndexList = new HashMap<BlockPos, Integer>();

    public void renderTileEntityAt(TileEntityPoleWallConnector polePart, double x, double y, double z, float partialTicks, int destroyStage) {
        super.func_180535_a((TileEntity)polePart, x, y, z, partialTicks, destroyStage);
        Vec3i facingVec = EnumFacing.field_82609_l[polePart.rotation].func_176730_m();
        Block block = polePart.func_145831_w().func_180495_p(polePart.func_174877_v()).func_177230_c();
        if (!(block instanceof BlockPoleAttachment)) {
            return;
        }
        BlockPoleAttachment decorBlock = (BlockPoleAttachment)block;
        float sunLight = polePart.func_145831_w().func_72971_b(0.0f) * polePart.func_145831_w().func_175724_o(polePart.func_174877_v());
        float blockLight = (float)polePart.func_145831_w().func_175705_a(EnumSkyBlock.BLOCK, polePart.func_174877_v()) / 15.0f;
        float lightBrightness = Math.min(1.0f - Math.max(sunLight, blockLight), 1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        if (facingVec.func_177958_n() == 1) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facingVec.func_177958_n() == -1) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facingVec.func_177952_p() == -1) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GL11.glDisable((int)2896);
        if (((Object)((Object)decorBlock)).equals(MTSRegistry.trafficSignal)) {
            this.renderTrafficSignal(polePart, facingVec, lightBrightness);
        } else if (((Object)((Object)decorBlock)).equals(MTSRegistry.streetLight)) {
            this.renderStreetLight(polePart, facingVec, lightBrightness);
        }
        GL11.glEnable((int)2896);
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderLightedSquare(float lightSize, float lightBrightness, Color lightColor) {
        float flareSize = lightSize * 4.0f;
        this.func_147499_a(lightTexture);
        GL11.glColor3f((float)((float)lightColor.getRed() / 255.0f), (float)((float)lightColor.getGreen() / 255.0f), (float)((float)lightColor.getBlue() / 255.0f));
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)(-lightSize / 2.0f), (float)(-lightSize / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)(lightSize / 2.0f), (float)(-lightSize / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(lightSize / 2.0f), (float)(lightSize / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-lightSize / 2.0f), (float)(lightSize / 2.0f), (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147499_a(lensFlareTexture);
        GL11.glColor4f((float)((float)lightColor.getRed() / 255.0f), (float)((float)lightColor.getGreen() / 255.0f), (float)((float)lightColor.getBlue() / 255.0f), (float)lightBrightness);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)(-flareSize / 2.0f), (float)(-flareSize / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)(flareSize / 2.0f), (float)(-flareSize / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(flareSize / 2.0f), (float)(flareSize / 2.0f), (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-flareSize / 2.0f), (float)(flareSize / 2.0f), (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
    }

    private void renderTrafficSignal(TileEntityPoleWallConnector signal, Vec3i facingVec, float lightBrightness) {
        Color lightColor;
        boolean shouldFlash;
        long worldTime = signal.func_145831_w().func_82737_E();
        BlockPos signalPos = signal.func_174877_v();
        if (!trafficSignalControllers.containsKey(signalPos)) {
            TileEntity testTile;
            int checkIndex;
            int n = checkIndex = checkIndexList.containsKey(signalPos) ? checkIndexList.get(signalPos) : 0;
            if (signal.func_145831_w().field_147482_g.size() <= checkIndex) {
                checkIndex = 0;
            }
            if ((testTile = (TileEntity)signal.func_145831_w().field_147482_g.get(checkIndex)) instanceof TileEntityTrafficSignalController && ((TileEntityTrafficSignalController)testTile).trafficSignalLocations.contains(signalPos)) {
                trafficSignalControllers.put(signalPos, testTile.func_174877_v());
            }
            checkIndexList.put(signalPos, checkIndex + 1);
        }
        if (trafficSignalControllers.containsKey(signalPos)) {
            TileEntity tile = signal.func_145831_w().func_175625_s(trafficSignalControllers.get(signalPos));
            if (tile instanceof TileEntityTrafficSignalController) {
                TileEntityTrafficSignalController controller = (TileEntityTrafficSignalController)tile;
                if (controller.trafficSignalLocations.contains(signalPos)) {
                    boolean isOnMainAxis;
                    shouldFlash = false;
                    boolean bl = isOnMainAxis = !(controller.orientedOnX ^ facingVec.func_177958_n() != 0);
                    if (controller.operationIndex == 0) {
                        Color color = lightColor = isOnMainAxis ? Color.GREEN : Color.RED;
                        if (controller.triggerMode) {
                            if (worldTime % 40L == 0L) {
                                int minX = Integer.MAX_VALUE;
                                int maxX = Integer.MIN_VALUE;
                                int minZ = Integer.MAX_VALUE;
                                int maxZ = Integer.MIN_VALUE;
                                for (BlockPos controllerSignalPos : controller.trafficSignalLocations) {
                                    minX = Math.min(minX, controllerSignalPos.func_177958_n());
                                    maxX = Math.max(maxX, controllerSignalPos.func_177958_n());
                                    minZ = Math.min(minX, controllerSignalPos.func_177952_p());
                                    maxZ = Math.max(maxX, controllerSignalPos.func_177952_p());
                                }
                                if (controller.orientedOnX) {
                                    minZ -= 10;
                                    maxZ += 10;
                                } else {
                                    minX -= 10;
                                    maxX += 10;
                                }
                                for (Entity entity : controller.func_145831_w().field_72996_f) {
                                    if (!(entity instanceof EntityVehicleF_Car)) continue;
                                    if (controller.orientedOnX) {
                                        if (!(entity.field_70161_v > (double)minZ && entity.field_70161_v < (double)((float)minZ + (float)(maxZ - minZ) / 2.0f)) && (!(entity.field_70161_v < (double)maxZ) || !(entity.field_70161_v > (double)((float)maxZ - (float)(maxZ - minZ) / 2.0f))) || !(entity.field_70165_t > (double)minX) || !(entity.field_70165_t < (double)maxX)) continue;
                                        controller.timeOperationStarted = worldTime;
                                        controller.operationIndex = 1;
                                        continue;
                                    }
                                    if (!(entity.field_70165_t > (double)minX && entity.field_70165_t < (double)((float)minX + (float)(maxX - minX) / 2.0f)) && (!(entity.field_70165_t < (double)maxX) || !(entity.field_70165_t > (double)((float)maxX - (float)(maxX - minX) / 2.0f))) || !(entity.field_70161_v > (double)minZ) || !(entity.field_70161_v < (double)maxZ)) continue;
                                    controller.timeOperationStarted = worldTime;
                                    controller.operationIndex = 1;
                                }
                            }
                        } else {
                            controller.timeOperationStarted = worldTime;
                            controller.operationIndex = 1;
                        }
                    } else if (controller.operationIndex == 1) {
                        Color color = lightColor = isOnMainAxis ? Color.YELLOW : Color.RED;
                        if (controller.timeOperationStarted + (long)controller.yellowTime <= worldTime) {
                            controller.timeOperationStarted = worldTime;
                            controller.operationIndex = (byte)2;
                        }
                    } else if (controller.operationIndex == 2) {
                        lightColor = Color.RED;
                        if (controller.timeOperationStarted + (long)controller.allRedTime <= worldTime) {
                            controller.timeOperationStarted = worldTime;
                            controller.operationIndex = (byte)3;
                        }
                    } else if (controller.operationIndex == 3) {
                        Color color = lightColor = isOnMainAxis ? Color.RED : Color.GREEN;
                        if (controller.timeOperationStarted + (long)controller.greenCrossTime <= worldTime) {
                            controller.timeOperationStarted = worldTime;
                            controller.operationIndex = (byte)4;
                        }
                    } else if (controller.operationIndex == 4) {
                        Color color = lightColor = isOnMainAxis ? Color.RED : Color.YELLOW;
                        if (controller.timeOperationStarted + (long)controller.yellowTime <= worldTime) {
                            controller.timeOperationStarted = worldTime;
                            controller.operationIndex = (byte)5;
                        }
                    } else if (controller.operationIndex == 5) {
                        lightColor = Color.RED;
                        if (controller.timeOperationStarted + (long)controller.allRedTime <= worldTime) {
                            controller.timeOperationStarted = worldTime;
                            if (controller.triggerMode) {
                                controller.operationIndex = 0;
                            } else {
                                controller.timeOperationStarted = worldTime;
                                controller.operationIndex = (byte)6;
                            }
                        }
                    } else {
                        Color color = lightColor = isOnMainAxis ? Color.GREEN : Color.RED;
                        if (controller.timeOperationStarted + (long)controller.greenMainTime <= worldTime) {
                            controller.timeOperationStarted = worldTime;
                            controller.operationIndex = 0;
                        }
                    }
                } else {
                    trafficSignalControllers.remove(signalPos);
                    shouldFlash = true;
                    lightColor = Color.RED;
                }
            } else {
                trafficSignalControllers.remove(signalPos);
                shouldFlash = true;
                lightColor = Color.RED;
            }
        } else {
            shouldFlash = true;
            lightColor = Color.RED;
        }
        if (!shouldFlash || shouldFlash && worldTime % 20L < 10L) {
            GL11.glTranslatef((float)0.0f, (float)(lightColor.equals(Color.RED) ? 0.8125f : (lightColor.equals(Color.YELLOW) ? 0.5f : 0.1875f)), (float)0.225f);
            this.renderLightedSquare(0.25f, lightBrightness, lightColor);
        }
    }

    private void renderStreetLight(TileEntityPoleWallConnector light, Vec3i facingVec, float lightBrightness) {
        GL11.glTranslatef((float)0.0f, (float)0.403125f, (float)0.375f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderLightedSquare(0.25f, lightBrightness, Color.WHITE);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        this.func_147499_a(lightBeamTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, lightBrightness / 2.0f));
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)774, (int)770);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
        Vec3d endpointVec = new Vec3d(0.0, 0.0, 6.0);
        GL11.glDepthMask((boolean)false);
        for (int j = 0; j <= 2; j = (int)((byte)(j + 1))) {
            RenderPoleLighted.drawLightCone(endpointVec, false);
        }
        RenderPoleLighted.drawLightCone(endpointVec, true);
        GL11.glPopMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private static void drawLightCone(Vec3d endPoint, boolean reverse) {
        GL11.glBegin((int)6);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        if (reverse) {
            float theta = 0.0f;
            while ((double)theta < 6.383185307179586) {
                GL11.glTexCoord2f((float)theta, (float)1.0f);
                GL11.glVertex3d((double)(endPoint.field_72450_a + 3.0 * Math.cos(theta)), (double)(endPoint.field_72448_b + 3.0 * Math.sin(theta)), (double)endPoint.field_72449_c);
                theta = (float)((double)theta + 0.15707963267948966);
            }
        } else {
            float theta = (float)Math.PI * 2;
            while ((double)theta >= -0.1) {
                GL11.glTexCoord2f((float)theta, (float)1.0f);
                GL11.glVertex3d((double)(endPoint.field_72450_a + 3.0 * Math.cos(theta)), (double)(endPoint.field_72448_b + 3.0 * Math.sin(theta)), (double)endPoint.field_72449_c);
                theta = (float)((double)theta - 0.15707963267948966);
            }
        }
        GL11.glEnd();
    }
}

