/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.guis.GUIPanelAircraft;
import minecrafttransportsimulator.packets.control.AileronPacket;
import minecrafttransportsimulator.packets.control.BrakePacket;
import minecrafttransportsimulator.packets.control.ElevatorPacket;
import minecrafttransportsimulator.packets.control.FlapPacket;
import minecrafttransportsimulator.packets.control.HornPacket;
import minecrafttransportsimulator.packets.control.LightPacket;
import minecrafttransportsimulator.packets.control.ReverseThrustPacket;
import minecrafttransportsimulator.packets.control.RudderPacket;
import minecrafttransportsimulator.packets.control.ShiftPacket;
import minecrafttransportsimulator.packets.control.SirenPacket;
import minecrafttransportsimulator.packets.control.SteeringPacket;
import minecrafttransportsimulator.packets.control.ThrottlePacket;
import minecrafttransportsimulator.packets.control.TrimPacket;
import minecrafttransportsimulator.packets.parts.PacketPartEngineSignal;
import minecrafttransportsimulator.packets.parts.PacketPartGunSignal;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartGun;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public final class ControlSystem {
    private static boolean joystickEnabled = false;
    private static final int NULL_COMPONENT = 999;
    private static final String KEYBOARD_CONFIG = "controls_keyboard";
    private static final String JOYSTICK_CONFIG = "controls_joystick";
    private static final Map<String, Controller> joystickMap = new HashMap<String, Controller>();
    private static KeyBinding configKey;
    private static short mousePosX;
    private static short mousePosY;
    private static final Map<ControlsKeyboard, Long> pressedKeyboardButtons;
    private static final Map<ControlsJoystick, Long> pressedJoystickButtons;

    public static void init() {
        configKey = new KeyBinding("key.config", 25, "key.categories.mts");
        ClientRegistry.registerKeyBinding((KeyBinding)configKey);
        for (Controller controller : ControllerEnvironment.getDefaultEnvironment().getControllers()) {
            joystickEnabled = true;
            if (controller.getType() == null || controller.getName() == null || controller.getType().equals(Controller.Type.MOUSE) || controller.getType().equals(Controller.Type.KEYBOARD) || controller.getComponents().length == 0) continue;
            joystickMap.put(controller.getName(), controller);
        }
        for (ControlsKeyboard controlsKeyboard : ControlsKeyboard.values()) {
            controlsKeyboard.button = ConfigSystem.config.get(KEYBOARD_CONFIG, controlsKeyboard.buttonName, controlsKeyboard.defaultButton).getInt();
        }
        for (ControlsJoystick controlsJoystick : ControlsJoystick.values()) {
            controlsJoystick.joystickAssigned = ConfigSystem.config.get(JOYSTICK_CONFIG, controlsJoystick.buttonName + "_joystick", "").getString();
            controlsJoystick.joystickButton = ConfigSystem.config.get(JOYSTICK_CONFIG, controlsJoystick.buttonName + "_button", 999).getInt();
            if (!controlsJoystick.isAxis) continue;
            controlsJoystick.joystickMinTravel = ConfigSystem.config.get(JOYSTICK_CONFIG, controlsJoystick.buttonName + "_mintravel", -1.0).getDouble();
            controlsJoystick.joystickMaxTravel = ConfigSystem.config.get(JOYSTICK_CONFIG, controlsJoystick.buttonName + "_maxtravel", 1.0).getDouble();
            controlsJoystick.joystickInverted = ConfigSystem.config.get(JOYSTICK_CONFIG, controlsJoystick.buttonName + "_inverted", false).getBoolean();
        }
        ConfigSystem.config.save();
    }

    public static boolean isMasterControlButttonPressed() {
        return configKey.func_151468_f();
    }

    public static boolean isJoystickSupportEnabled() {
        return joystickEnabled;
    }

    public static void setKeyboardKey(ControlsKeyboard control, int keyNumber) {
        control.button = keyNumber;
        ConfigSystem.config.getCategory(KEYBOARD_CONFIG).put(control.buttonName, new Property(control.buttonName, String.valueOf(keyNumber), Property.Type.INTEGER));
        ConfigSystem.config.save();
    }

    public static void setControlJoystick(ControlsJoystick control, String joystickName, int componentId) {
        for (ControlsJoystick cont : ControlsJoystick.values()) {
            if (!cont.joystickAssigned.equals(joystickName) || cont.joystickButton != componentId) continue;
            cont.joystickAssigned = "";
            cont.joystickButton = 999;
        }
        control.joystickAssigned = joystickName;
        control.joystickButton = componentId;
        ConfigSystem.config.getCategory(JOYSTICK_CONFIG).put(control.buttonName + "_joystick", new Property(control.buttonName + "_joystick", joystickName, Property.Type.STRING));
        ConfigSystem.config.getCategory(JOYSTICK_CONFIG).put(control.buttonName + "_button", new Property(control.buttonName + "_button", String.valueOf(componentId), Property.Type.INTEGER));
        ConfigSystem.config.save();
    }

    public static void setAxisJoystick(ControlsJoystick control, String joystickName, int componentId, double minBound, double maxBound, boolean inverted) {
        ControlSystem.setControlJoystick(control, joystickName, componentId);
        control.joystickMinTravel = minBound;
        control.joystickMaxTravel = maxBound;
        control.joystickInverted = inverted;
        ConfigSystem.config.getCategory(JOYSTICK_CONFIG).put(control.buttonName + "_mintravel", new Property(control.buttonName + "_mintravel", String.valueOf(control.joystickMinTravel), Property.Type.DOUBLE));
        ConfigSystem.config.getCategory(JOYSTICK_CONFIG).put(control.buttonName + "_maxtravel", new Property(control.buttonName + "_maxtravel", String.valueOf(control.joystickMaxTravel), Property.Type.DOUBLE));
        ConfigSystem.config.getCategory(JOYSTICK_CONFIG).put(control.buttonName + "_inverted", new Property(control.buttonName + "_inverted", String.valueOf(control.joystickInverted), Property.Type.BOOLEAN));
        ConfigSystem.config.save();
    }

    public static void clearControlJoystick(ControlsJoystick control) {
        ControlSystem.setControlJoystick(control, "", 999);
    }

    public static void controlVehicle(EntityVehicleE_Powered vehicle, boolean isPlayerController) {
        if (vehicle instanceof EntityVehicleF_Plane) {
            ControlSystem.controlAircraft((EntityVehicleF_Plane)vehicle, isPlayerController);
        } else if (vehicle instanceof EntityVehicleF_Car) {
            ControlSystem.controlCar((EntityVehicleF_Car)vehicle, isPlayerController);
        }
    }

    private static <ControlEnum> boolean getTrueButtonState(Map<ControlEnum, Long> buttonMap, ControlEnum button, boolean pressed) {
        if (pressed) {
            Long time = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if (!buttonMap.containsKey(button)) {
                buttonMap.put(button, time);
            }
            return buttonMap.get(button).longValue() == time.longValue();
        }
        buttonMap.remove(button);
        return false;
    }

    private static float getJoystickMultistateValue(ControlsJoystick control) {
        if (joystickMap.containsKey(control.joystickAssigned)) {
            joystickMap.get(control.joystickAssigned).poll();
            return joystickMap.get(control.joystickAssigned).getComponents()[control.joystickButton].getPollData();
        }
        return 0.0f;
    }

    private static short getJoystickAxisState(ControlsJoystick control, short pollBounds) {
        if (joystickMap.containsKey(control.joystickAssigned)) {
            joystickMap.get(control.joystickAssigned).poll();
            float pollValue = joystickMap.get(control.joystickAssigned).getComponents()[control.joystickButton].getPollData();
            if ((double)Math.abs(pollValue) > ConfigSystem.getDoubleConfig("JoystickDeadZone") || pollBounds == 0) {
                pollValue = (float)Math.max(control.joystickMinTravel, (double)pollValue);
                pollValue = (float)Math.min(control.joystickMaxTravel, (double)pollValue);
                if (pollBounds != 0) {
                    return (short)(control.joystickInverted ? (float)(-pollBounds) * pollValue : (float)pollBounds * pollValue);
                }
                pollValue = (float)(((double)pollValue - control.joystickMinTravel) / (control.joystickMaxTravel - control.joystickMinTravel));
                if (control.joystickInverted) {
                    pollValue = 1.0f - pollValue;
                }
                return (short)(pollValue * 100.0f);
            }
        }
        return 0;
    }

    private static void controlCamera(ControlsKeyboardDynamic dynamic, ControlsKeyboard zoomIn, ControlsKeyboard zoomOut, ControlsJoystick hudMode, ControlsJoystick changeView) {
        if (dynamic.isPressed() || hudMode.isPressed()) {
            CameraSystem.hudMode = CameraSystem.hudMode == 3 ? 0 : ++CameraSystem.hudMode;
        } else if (dynamic.mainControl.isPressed()) {
            CameraSystem.changeCameraLock();
        }
        if (zoomIn.isPressed()) {
            CameraSystem.changeCameraZoom(false);
        }
        if (zoomOut.isPressed()) {
            CameraSystem.changeCameraZoom(true);
        }
        if (changeView.isPressed()) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? 0 : ++Minecraft.func_71410_x().field_71474_y.field_74320_O;
        }
    }

    private static void rotateCamera(ControlsJoystick lookR, ControlsJoystick lookL, ControlsJoystick lookU, ControlsJoystick lookD, ControlsJoystick lookA) {
        float pollData;
        if (lookR.isPressed()) {
            Minecraft.func_71410_x().field_71439_g.field_70177_z += 3.0f;
        }
        if (lookL.isPressed()) {
            Minecraft.func_71410_x().field_71439_g.field_70177_z -= 3.0f;
        }
        if (lookU.isPressed()) {
            Minecraft.func_71410_x().field_71439_g.field_70125_A -= 3.0f;
        }
        if (lookD.isPressed()) {
            Minecraft.func_71410_x().field_71439_g.field_70125_A += 3.0f;
        }
        if ((pollData = ControlSystem.getJoystickMultistateValue(lookA)) != 0.0f) {
            if (pollData >= 0.125f && pollData <= 0.375f) {
                Minecraft.func_71410_x().field_71439_g.field_70125_A += 3.0f;
            }
            if (pollData >= 0.375f && pollData <= 0.625f) {
                Minecraft.func_71410_x().field_71439_g.field_70177_z += 3.0f;
            }
            if (pollData >= 0.625f && pollData <= 0.875f) {
                Minecraft.func_71410_x().field_71439_g.field_70125_A -= 3.0f;
            }
            if (pollData >= 0.875f || pollData <= 0.125f) {
                Minecraft.func_71410_x().field_71439_g.field_70177_z -= 3.0f;
            }
        }
    }

    private static void controlBrake(ControlsKeyboardDynamic dynamic, ControlsJoystick analogBrake, ControlsJoystick pBrake, int entityID) {
        if (joystickMap.containsKey(analogBrake.joystickAssigned) && analogBrake.joystickButton != 999) {
            if (pBrake.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new BrakePacket(entityID, 12));
            } else if (ControlSystem.getJoystickAxisState(analogBrake, (short)0) > 25) {
                MTS.MTSNet.sendToServer((IMessage)new BrakePacket(entityID, 11));
            } else {
                MTS.MTSNet.sendToServer((IMessage)new BrakePacket(entityID, 2));
            }
        } else if (dynamic.isPressed() || pBrake.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new BrakePacket(entityID, 12));
        } else if (dynamic.mainControl.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new BrakePacket(entityID, 11));
        } else {
            MTS.MTSNet.sendToServer((IMessage)new BrakePacket(entityID, 2));
        }
    }

    private static void controlGun(EntityVehicleE_Powered vehicle, ControlsKeyboard gun) {
        block4: {
            PartSeat seat = vehicle.getSeatForRider((Entity)Minecraft.func_71410_x().field_71439_g);
            if (seat == null) break block4;
            if (seat.isController) {
                for (APart part : vehicle.getVehicleParts()) {
                    if (!(part instanceof APartGun) || part.parentPart != null) continue;
                    MTS.MTSNet.sendToServer((IMessage)new PacketPartGunSignal((APartGun)part, gun.isPressed() ? Minecraft.func_71410_x().field_71439_g.func_145782_y() : -1));
                }
            } else {
                for (APart part : seat.childParts) {
                    if (!(part instanceof APartGun)) continue;
                    MTS.MTSNet.sendToServer((IMessage)new PacketPartGunSignal((APartGun)part, gun.isPressed() ? Minecraft.func_71410_x().field_71439_g.func_145782_y() : -1));
                }
            }
        }
    }

    private static void controlAircraft(EntityVehicleF_Plane aircraft, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboardDynamic.AIRCRAFT_CHANGEHUD, ControlsKeyboard.AIRCRAFT_ZOOM_I, ControlsKeyboard.AIRCRAFT_ZOOM_O, ControlsJoystick.AIRCRAFT_CHANGEHUD, ControlsJoystick.AIRCRAFT_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.AIRCRAFT_LOOK_R, ControlsJoystick.AIRCRAFT_LOOK_L, ControlsJoystick.AIRCRAFT_LOOK_U, ControlsJoystick.AIRCRAFT_LOOK_D, ControlsJoystick.AIRCRAFT_LOOK_A);
        if (!isPlayerController) {
            return;
        }
        ControlSystem.controlBrake(ControlsKeyboardDynamic.AIRCRAFT_PARK, ControlsJoystick.AIRCRAFT_BRAKE_ANALOG, ControlsJoystick.AIRCRAFT_PARK, aircraft.func_145782_y());
        ControlSystem.controlGun(aircraft, ControlsKeyboard.AIRCRAFT_GUN);
        if (ControlsKeyboard.AIRCRAFT_PANEL.isPressed()) {
            if (Minecraft.func_71410_x().field_71462_r == null) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GUIPanelAircraft(aircraft));
            } else if (Minecraft.func_71410_x().field_71462_r instanceof GUIPanelAircraft) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)null);
                Minecraft.func_71410_x().func_71381_h();
            }
        }
        if (ControlsJoystick.AIRCRAFT_REVERSE.isPressed()) {
            MTS.proxy.playSound(aircraft.func_174791_d(), "mts:panel_buzzer", 1.0f, 1.0f);
            MTS.MTSNet.sendToServer((IMessage)new ReverseThrustPacket(aircraft.func_145782_y(), !aircraft.reverseThrust));
        }
        if (joystickMap.containsKey(ControlsJoystick.AIRCRAFT_THROTTLE.joystickAssigned) && ControlsJoystick.AIRCRAFT_THROTTLE.joystickButton != 999) {
            MTS.MTSNet.sendToServer((IMessage)new ThrottlePacket(aircraft.func_145782_y(), (byte)ControlSystem.getJoystickAxisState(ControlsJoystick.AIRCRAFT_THROTTLE, (short)0)));
        } else {
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_U.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new ThrottlePacket(aircraft.func_145782_y(), 127));
            }
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_D.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new ThrottlePacket(aircraft.func_145782_y(), -128));
            }
        }
        if (aircraft.pack.general.type.equals("plane") && aircraft.pack.plane.hasFlaps) {
            if (ControlsKeyboard.AIRCRAFT_FLAPS_U.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new FlapPacket(aircraft.func_145782_y(), -50));
            }
            if (ControlsKeyboard.AIRCRAFT_FLAPS_D.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new FlapPacket(aircraft.func_145782_y(), 50));
            }
        }
        if (joystickMap.containsKey(ControlsJoystick.AIRCRAFT_YAW.joystickAssigned) && ControlsJoystick.AIRCRAFT_YAW.joystickButton != 999) {
            MTS.MTSNet.sendToServer((IMessage)new RudderPacket(aircraft.func_145782_y(), ControlSystem.getJoystickAxisState(ControlsJoystick.AIRCRAFT_YAW, (short)250)));
        } else {
            if (ControlsKeyboard.AIRCRAFT_YAW_R.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new RudderPacket(aircraft.func_145782_y(), true, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
            }
            if (ControlsKeyboard.AIRCRAFT_YAW_L.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new RudderPacket(aircraft.func_145782_y(), false, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
            }
        }
        if (ControlsJoystick.AIRCRAFT_TRIM_YAW_R.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new TrimPacket(aircraft.func_145782_y(), 10));
        }
        if (ControlsJoystick.AIRCRAFT_TRIM_YAW_L.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new TrimPacket(aircraft.func_145782_y(), 2));
        }
        if (ConfigSystem.getBooleanConfig("MouseYoke")) {
            if (CameraSystem.lockedView && Minecraft.func_71410_x().field_71462_r == null) {
                int dx = Mouse.getDX();
                int dy = Mouse.getDY();
                if (Math.abs(dx) < 100) {
                    mousePosX = (short)Math.max(Math.min((float)mousePosX + (float)dx / 5.0f, 250.0f), -250.0f);
                }
                if (Math.abs(dy) < 100) {
                    mousePosY = (short)Math.max(Math.min(mousePosY - dy, 250), -250);
                }
                MTS.MTSNet.sendToServer((IMessage)new AileronPacket(aircraft.func_145782_y(), mousePosX));
                MTS.MTSNet.sendToServer((IMessage)new ElevatorPacket(aircraft.func_145782_y(), mousePosY));
            }
        } else {
            if (joystickMap.containsKey(ControlsJoystick.AIRCRAFT_PITCH.joystickAssigned) && ControlsJoystick.AIRCRAFT_PITCH.joystickButton != 999) {
                MTS.MTSNet.sendToServer((IMessage)new ElevatorPacket(aircraft.func_145782_y(), ControlSystem.getJoystickAxisState(ControlsJoystick.AIRCRAFT_PITCH, (short)250)));
            } else {
                if (ControlsKeyboard.AIRCRAFT_PITCH_U.isPressed()) {
                    MTS.MTSNet.sendToServer((IMessage)new ElevatorPacket(aircraft.func_145782_y(), true, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
                }
                if (ControlsKeyboard.AIRCRAFT_PITCH_D.isPressed()) {
                    MTS.MTSNet.sendToServer((IMessage)new ElevatorPacket(aircraft.func_145782_y(), false, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
                }
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_PITCH_U.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(aircraft.func_145782_y(), 9));
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_PITCH_D.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(aircraft.func_145782_y(), 1));
            }
            if (joystickMap.containsKey(ControlsJoystick.AIRCRAFT_ROLL.joystickAssigned) && ControlsJoystick.AIRCRAFT_ROLL.joystickButton != 999) {
                MTS.MTSNet.sendToServer((IMessage)new AileronPacket(aircraft.func_145782_y(), ControlSystem.getJoystickAxisState(ControlsJoystick.AIRCRAFT_ROLL, (short)250)));
            } else {
                if (ControlsKeyboard.AIRCRAFT_ROLL_R.isPressed()) {
                    MTS.MTSNet.sendToServer((IMessage)new AileronPacket(aircraft.func_145782_y(), true, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
                }
                if (ControlsKeyboard.AIRCRAFT_ROLL_L.isPressed()) {
                    MTS.MTSNet.sendToServer((IMessage)new AileronPacket(aircraft.func_145782_y(), false, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
                }
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_ROLL_R.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(aircraft.func_145782_y(), 8));
            }
            if (ControlsJoystick.AIRCRAFT_TRIM_ROLL_L.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new TrimPacket(aircraft.func_145782_y(), 0));
            }
        }
    }

    private static void controlCar(EntityVehicleF_Car car, boolean isPlayerController) {
        ControlSystem.controlCamera(ControlsKeyboardDynamic.CAR_CHANGEHUD, ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsJoystick.CAR_CHANGEHUD, ControlsJoystick.CAR_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
        if (!isPlayerController) {
            return;
        }
        ControlSystem.controlBrake(ControlsKeyboardDynamic.CAR_PARK, ControlsJoystick.CAR_BRAKE_ANALOG, ControlsJoystick.CAR_PARK, car.func_145782_y());
        ControlSystem.controlGun(car, ControlsKeyboard.CAR_GUN);
        if (joystickMap.containsKey(ControlsJoystick.CAR_GAS.joystickAssigned) && ControlsJoystick.CAR_GAS.joystickButton != 999) {
            MTS.MTSNet.sendToServer((IMessage)new ThrottlePacket(car.func_145782_y(), (byte)ControlSystem.getJoystickAxisState(ControlsJoystick.CAR_GAS, (short)0)));
        } else if (ControlsKeyboard.CAR_GAS.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new ThrottlePacket(car.func_145782_y(), 100));
        } else {
            MTS.MTSNet.sendToServer((IMessage)new ThrottlePacket(car.func_145782_y(), 0));
        }
        if (ControlsKeyboardDynamic.CAR_SIREN.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new SirenPacket(car.func_145782_y()));
        } else if (ControlsKeyboard.CAR_LIGHTS_SPECIAL.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new LightPacket(car.func_145782_y(), EntityVehicleE_Powered.LightTypes.EMERGENCYLIGHT));
        }
        if (ControlsKeyboardDynamic.CAR_TURNSIGNAL_R.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new LightPacket(car.func_145782_y(), EntityVehicleE_Powered.LightTypes.RIGHTTURNLIGHT));
        } else if (ControlsKeyboardDynamic.CAR_TURNSIGNAL_L.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new LightPacket(car.func_145782_y(), EntityVehicleE_Powered.LightTypes.LEFTTURNLIGHT));
        } else {
            if (ControlsKeyboard.CAR_LIGHTS.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new LightPacket(car.func_145782_y(), EntityVehicleE_Powered.LightTypes.HEADLIGHT));
                MTS.MTSNet.sendToServer((IMessage)new LightPacket(car.func_145782_y(), EntityVehicleE_Powered.LightTypes.RUNNINGLIGHT));
            }
            if (ConfigSystem.getBooleanConfig("MouseYoke")) {
                if (CameraSystem.lockedView && Minecraft.func_71410_x().field_71462_r == null) {
                    int dx = Mouse.getDX();
                    if (Math.abs(dx) < 100) {
                        mousePosX = (short)Math.max(Math.min(mousePosX + dx * 10, 450), -450);
                    }
                    MTS.MTSNet.sendToServer((IMessage)new SteeringPacket(car.func_145782_y(), mousePosX));
                }
            } else if (joystickMap.containsKey(ControlsJoystick.CAR_TURN.joystickAssigned) && ControlsJoystick.CAR_TURN.joystickButton != 999) {
                MTS.MTSNet.sendToServer((IMessage)new SteeringPacket(car.func_145782_y(), ControlSystem.getJoystickAxisState(ControlsJoystick.CAR_TURN, (short)450)));
            } else {
                boolean turningRight = ControlsKeyboard.CAR_TURN_R.isPressed();
                boolean turningLeft = ControlsKeyboard.CAR_TURN_L.isPressed();
                if (turningRight && !turningLeft) {
                    MTS.MTSNet.sendToServer((IMessage)new SteeringPacket(car.func_145782_y(), true, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
                } else if (turningLeft && !turningRight) {
                    MTS.MTSNet.sendToServer((IMessage)new SteeringPacket(car.func_145782_y(), false, (short)ConfigSystem.getIntegerConfig("ControlSurfaceCooldown")));
                }
            }
        }
        if (car.getEngineByNumber((byte)0) != null) {
            if (ControlsKeyboardDynamic.CAR_STOP.isPressed() || ControlsJoystick.CAR_STOP.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(car.getEngineByNumber((byte)0), PacketPartEngineSignal.PacketEngineTypes.MAGNETO_OFF));
            } else if (ControlsKeyboard.CAR_START.isPressed()) {
                MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(car.getEngineByNumber((byte)0), PacketPartEngineSignal.PacketEngineTypes.MAGNETO_ON));
                MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(car.getEngineByNumber((byte)0), PacketPartEngineSignal.PacketEngineTypes.ES_ON));
            } else {
                MTS.MTSNet.sendToServer((IMessage)new PacketPartEngineSignal(car.getEngineByNumber((byte)0), PacketPartEngineSignal.PacketEngineTypes.ES_OFF));
            }
        }
        if (ControlsKeyboard.CAR_SHIFT_U.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new ShiftPacket(car.func_145782_y(), true));
        }
        if (ControlsKeyboard.CAR_SHIFT_D.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new ShiftPacket(car.func_145782_y(), false));
        }
        if (ControlsKeyboard.CAR_HORN.isPressed()) {
            MTS.MTSNet.sendToServer((IMessage)new HornPacket(car.func_145782_y(), true));
        } else {
            MTS.MTSNet.sendToServer((IMessage)new HornPacket(car.func_145782_y(), false));
        }
    }

    static {
        mousePosX = 0;
        mousePosY = 0;
        pressedKeyboardButtons = new HashMap<ControlsKeyboard, Long>();
        pressedJoystickButtons = new HashMap<ControlsJoystick, Long>();
    }

    public static enum ControlsKeyboardDynamic {
        AIRCRAFT_CHANGEHUD(ControlsKeyboard.AIRCRAFT_CAMLOCK, ControlsKeyboard.AIRCRAFT_MOD),
        AIRCRAFT_PARK(ControlsKeyboard.AIRCRAFT_BRAKE, ControlsKeyboard.AIRCRAFT_MOD),
        CAR_CHANGEHUD(ControlsKeyboard.CAR_CAMLOCK, ControlsKeyboard.CAR_MOD),
        CAR_PARK(ControlsKeyboard.CAR_BRAKE, ControlsKeyboard.CAR_MOD),
        CAR_STOP(ControlsKeyboard.CAR_START, ControlsKeyboard.CAR_MOD),
        CAR_SIREN(ControlsKeyboard.CAR_LIGHTS_SPECIAL, ControlsKeyboard.CAR_MOD),
        CAR_TURNSIGNAL_R(ControlsKeyboard.CAR_TURN_R, ControlsKeyboard.CAR_LIGHTS),
        CAR_TURNSIGNAL_L(ControlsKeyboard.CAR_TURN_L, ControlsKeyboard.CAR_LIGHTS);

        public final String buttonName = "input." + this.name().toLowerCase().substring(0, this.name().indexOf(95)) + "." + this.name().toLowerCase().substring(this.name().indexOf(95) + 1);
        public final ControlsKeyboard mainControl;
        public final ControlsKeyboard modControl;

        private ControlsKeyboardDynamic(ControlsKeyboard mainControl, ControlsKeyboard modControl) {
            this.mainControl = mainControl;
            this.modControl = modControl;
        }

        public boolean isPressed() {
            return this.modControl.isPressed() ? this.mainControl.isPressed() : false;
        }
    }

    public static enum ControlsJoystick {
        AIRCRAFT_MOD(false, false),
        AIRCRAFT_CAMLOCK(false, true),
        AIRCRAFT_YAW(true, false),
        AIRCRAFT_PITCH(true, false),
        AIRCRAFT_ROLL(true, false),
        AIRCRAFT_THROTTLE(true, false),
        AIRCRAFT_FLAPS_U(false, true),
        AIRCRAFT_FLAPS_D(false, true),
        AIRCRAFT_BRAKE(false, false),
        AIRCRAFT_BRAKE_ANALOG(true, false),
        AIRCRAFT_PANEL(false, true),
        AIRCRAFT_PARK(false, true),
        AIRCRAFT_GUN(false, false),
        AIRCRAFT_ZOOM_I(false, true),
        AIRCRAFT_ZOOM_O(false, true),
        AIRCRAFT_CHANGEVIEW(false, true),
        AIRCRAFT_CHANGEHUD(false, true),
        AIRCRAFT_LOOK_L(false, false),
        AIRCRAFT_LOOK_R(false, false),
        AIRCRAFT_LOOK_U(false, false),
        AIRCRAFT_LOOK_D(false, false),
        AIRCRAFT_LOOK_A(false, false),
        AIRCRAFT_TRIM_YAW_R(false, true),
        AIRCRAFT_TRIM_YAW_L(false, true),
        AIRCRAFT_TRIM_PITCH_U(false, true),
        AIRCRAFT_TRIM_PITCH_D(false, true),
        AIRCRAFT_TRIM_ROLL_R(false, true),
        AIRCRAFT_TRIM_ROLL_L(false, true),
        AIRCRAFT_REVERSE(false, true),
        CAR_MOD(false, false),
        CAR_CAMLOCK(false, true),
        CAR_TURN(true, false),
        CAR_GAS(true, false),
        CAR_BRAKE(false, false),
        CAR_BRAKE_ANALOG(true, false),
        CAR_SHIFT_U(false, true),
        CAR_SHIFT_D(false, true),
        CAR_HORN(false, false),
        CAR_START(false, false),
        CAR_STOP(false, false),
        CAR_LIGHTS(false, true),
        CAR_LIGHTS_SPECIAL(false, true),
        CAR_PARK(false, true),
        CAR_GUN(false, false),
        CAR_ZOOM_I(false, true),
        CAR_ZOOM_O(false, true),
        CAR_CHANGEVIEW(false, true),
        CAR_CHANGEHUD(false, true),
        CAR_LOOK_L(false, false),
        CAR_LOOK_R(false, false),
        CAR_LOOK_U(false, false),
        CAR_LOOK_D(false, false),
        CAR_LOOK_A(false, false);

        public final boolean isAxis;
        public final String buttonName = "input." + this.name().toLowerCase().substring(0, this.name().indexOf(95)) + "." + this.name().toLowerCase().substring(this.name().indexOf(95) + 1);
        private final boolean isMomentary;
        private boolean joystickInverted = false;
        private int joystickButton;
        private double joystickMaxTravel;
        private double joystickMinTravel;
        private String joystickAssigned;

        private ControlsJoystick(boolean isAxis, boolean isMomentary) {
            this.isAxis = isAxis;
            this.isMomentary = isMomentary;
        }

        public String getCurrentJoystick() {
            return this.joystickAssigned;
        }

        public int getCurrentButton() {
            return this.joystickButton;
        }

        public boolean isPressed() {
            return this.isMomentary ? ControlSystem.getTrueButtonState(pressedJoystickButtons, (Object)this, ControlSystem.getJoystickMultistateValue(this) > 0.0f) : ControlSystem.getJoystickMultistateValue(this) > 0.0f;
        }
    }

    public static enum ControlsKeyboard {
        AIRCRAFT_CAMLOCK(157, ControlsJoystick.AIRCRAFT_CAMLOCK, true),
        AIRCRAFT_YAW_R(38, ControlsJoystick.AIRCRAFT_YAW, false),
        AIRCRAFT_YAW_L(36, ControlsJoystick.AIRCRAFT_YAW, false),
        AIRCRAFT_PITCH_U(31, ControlsJoystick.AIRCRAFT_PITCH, false),
        AIRCRAFT_PITCH_D(17, ControlsJoystick.AIRCRAFT_PITCH, false),
        AIRCRAFT_ROLL_R(32, ControlsJoystick.AIRCRAFT_ROLL, false),
        AIRCRAFT_ROLL_L(30, ControlsJoystick.AIRCRAFT_ROLL, false),
        AIRCRAFT_THROTTLE_U(23, ControlsJoystick.AIRCRAFT_THROTTLE, false),
        AIRCRAFT_THROTTLE_D(37, ControlsJoystick.AIRCRAFT_THROTTLE, false),
        AIRCRAFT_FLAPS_U(21, ControlsJoystick.AIRCRAFT_FLAPS_U, true),
        AIRCRAFT_FLAPS_D(35, ControlsJoystick.AIRCRAFT_FLAPS_D, true),
        AIRCRAFT_BRAKE(48, ControlsJoystick.AIRCRAFT_BRAKE, false),
        AIRCRAFT_PANEL(22, ControlsJoystick.AIRCRAFT_PANEL, true),
        AIRCRAFT_GUN(57, ControlsJoystick.AIRCRAFT_GUN, false),
        AIRCRAFT_ZOOM_I(201, ControlsJoystick.AIRCRAFT_ZOOM_I, true),
        AIRCRAFT_ZOOM_O(209, ControlsJoystick.AIRCRAFT_ZOOM_O, true),
        AIRCRAFT_MOD(54, ControlsJoystick.AIRCRAFT_MOD, false),
        CAR_MOD(54, ControlsJoystick.CAR_MOD, false),
        CAR_CAMLOCK(157, ControlsJoystick.CAR_CAMLOCK, true),
        CAR_TURN_R(32, ControlsJoystick.CAR_TURN, false),
        CAR_TURN_L(30, ControlsJoystick.CAR_TURN, false),
        CAR_GAS(17, ControlsJoystick.CAR_GAS, false),
        CAR_BRAKE(31, ControlsJoystick.CAR_BRAKE, false),
        CAR_SHIFT_U(19, ControlsJoystick.CAR_SHIFT_U, true),
        CAR_SHIFT_D(33, ControlsJoystick.CAR_SHIFT_D, true),
        CAR_HORN(46, ControlsJoystick.CAR_HORN, false),
        CAR_START(44, ControlsJoystick.CAR_START, false),
        CAR_LIGHTS(45, ControlsJoystick.CAR_LIGHTS, true),
        CAR_LIGHTS_SPECIAL(47, ControlsJoystick.CAR_LIGHTS_SPECIAL, true),
        CAR_GUN(57, ControlsJoystick.CAR_GUN, false),
        CAR_ZOOM_I(201, ControlsJoystick.CAR_ZOOM_I, true),
        CAR_ZOOM_O(209, ControlsJoystick.CAR_ZOOM_O, true);

        public final String buttonName = "input." + this.name().toLowerCase().substring(0, this.name().indexOf(95)) + "." + this.name().toLowerCase().substring(this.name().indexOf(95) + 1);
        private final boolean isMomentary;
        private final int defaultButton;
        private final ControlsJoystick linkedJoystickControl;
        private int button;

        private ControlsKeyboard(int defaultButton, ControlsJoystick linkedJoystickControl, boolean momentary) {
            this.defaultButton = defaultButton;
            this.linkedJoystickControl = linkedJoystickControl;
            this.isMomentary = momentary;
        }

        public String getCurrentButton() {
            return Keyboard.getKeyName((int)this.button);
        }

        public boolean isPressed() {
            if (joystickMap.containsKey(this.linkedJoystickControl.joystickAssigned) && this.linkedJoystickControl.joystickButton != 999) {
                boolean pressed = false;
                if (!this.linkedJoystickControl.isAxis) {
                    pressed = this.linkedJoystickControl.isPressed();
                }
                if (pressed || ConfigSystem.getBooleanConfig("KeyboardOverride")) {
                    return pressed;
                }
            }
            return this.isMomentary ? ControlSystem.getTrueButtonState(pressedKeyboardButtons, (Object)this, Keyboard.isKeyDown((int)this.button)) : Keyboard.isKeyDown((int)this.button);
        }
    }
}

