/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.parts.PacketPartInteraction;
import minecrafttransportsimulator.packets.parts.PacketPartSeatRiderChange;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleWindowBreak;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleA_Base;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartBarrel;
import minecrafttransportsimulator.vehicles.parts.PartCrate;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public abstract class EntityVehicleB_Existing
extends EntityVehicleA_Base {
    public boolean locked;
    public byte brokenWindows;
    public float rotationRoll;
    public float prevRotationRoll;
    public double airDensity;
    public double currentMass;
    public String ownerName = "";
    public String displayText = "";
    public Vec3d headingVec = Vec3d.field_186680_a;
    private final BiMap<Integer, PartSeat> riderSeats = HashBiMap.create();
    private List<Double[]> riderSeatPositions = new ArrayList<Double[]>();
    private static final String[] ridingEntityNames = new String[]{"ridingEntity", "field_73141_v", "field_184239_as"};
    private int riderIDToDismountThisTick = -1;
    private boolean didRiderClickSeat;

    public EntityVehicleB_Existing(World world) {
        super(world);
    }

    public EntityVehicleB_Existing(World world, float posX, float posY, float posZ, float playerRotation, String vehicleName) {
        super(world, vehicleName);
        this.func_70080_a(posX, posY, posZ, playerRotation - 90.0f, 0.0f);
        this.displayText = this.pack.rendering.defaultDisplayText;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.pack != null) {
            this.currentMass = this.getCurrentMass();
            this.airDensity = 1.225 * Math.pow(2.0, -this.field_70163_u / (500.0 * (double)this.field_70170_p.func_72800_K() / 256.0));
            this.getBasicProperties();
        }
        if (this.riderIDToDismountThisTick != -1) {
            PartSeat seat;
            Entity riderToDismount = this.field_70170_p.func_73045_a(this.riderIDToDismountThisTick);
            if (riderToDismount != null && (seat = this.getSeatForRider(riderToDismount)) != null) {
                this.removeRiderFromSeat(riderToDismount, seat);
                this.riderIDToDismountThisTick = -1;
            }
            if (this.riderIDToDismountThisTick != -1) {
                Integer missingRiderID = -1;
                for (Integer entityID : this.riderSeats.keySet()) {
                    boolean passengerIsValid = false;
                    for (Entity passenger : this.func_184188_bt()) {
                        if (passenger.func_145782_y() != entityID.intValue()) continue;
                        passengerIsValid = true;
                        break;
                    }
                    if (passengerIsValid) continue;
                    missingRiderID = entityID;
                }
                this.riderSeats.remove((Object)missingRiderID);
            }
            this.riderIDToDismountThisTick = -1;
        }
        this.didRiderClickSeat = false;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            APart hitPart;
            if (hand.equals((Object)EnumHand.MAIN_HAND) && player.func_184614_ca().func_190926_b() && (hitPart = this.getHitPart((Entity)player)) != null && hitPart.interactPart(player)) {
                MTS.MTSNet.sendToServer((IMessage)new PacketPartInteraction(hitPart, player.func_145782_y()));
            }
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!this.field_70170_p.field_72995_K) {
            Entity damageSource;
            if (source.func_76364_f() != null && !source.func_76364_f().equals((Object)source.func_76346_g())) {
                Entity projectile = source.func_76364_f();
                for (APart part : this.getVehicleParts()) {
                    if (!part.getAABBWithOffset(Vec3d.field_186680_a).func_72314_b(Math.abs(projectile.field_70159_w), Math.abs(projectile.field_70181_x), Math.abs(projectile.field_70179_y)).func_72318_a(projectile.func_174791_d())) continue;
                    part.attackPart(source, damage);
                    return true;
                }
            } else {
                APart hitPart;
                Entity attacker = source.func_76346_g();
                if (attacker != null && (hitPart = this.getHitPart(attacker)) != null) {
                    hitPart.attackPart(source, damage);
                    return true;
                }
            }
            Entity entity = damageSource = source.func_76346_g() != null && !source.func_76346_g().equals((Object)source.func_76364_f()) ? source.func_76364_f() : source.func_76346_g();
            if (damageSource != null && this.brokenWindows < this.pack.rendering.numberWindows) {
                this.brokenWindows = (byte)(this.brokenWindows + 1);
                this.func_184185_a(SoundEvents.field_187561_bM, 2.0f, 1.0f);
                MTS.MTSNet.sendToAll((IMessage)new PacketVehicleWindowBreak(this));
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void on(EntityMountEvent event) {
        if (event.getEntityBeingMounted() instanceof EntityVehicleB_Existing && event.isDismounting() && event.getEntityMounting() != null && !event.getWorldObj().field_72995_K && !event.getEntityBeingMounted().field_70128_L) {
            EntityVehicleB_Existing vehicle = (EntityVehicleB_Existing)event.getEntityBeingMounted();
            if (!vehicle.didRiderClickSeat) {
                if (vehicle.riderIDToDismountThisTick == -1) {
                    vehicle.riderIDToDismountThisTick = event.getEntityMounting().func_145782_y();
                    event.setCanceled(true);
                } else {
                    vehicle.riderIDToDismountThisTick = -1;
                    event.setCanceled(false);
                }
            }
            vehicle.didRiderClickSeat = false;
        }
    }

    public void func_184232_k(Entity passenger) {
        PartSeat seat = this.getSeatForRider(passenger);
        if (seat != null) {
            Vec3d posVec = RotationSystem.getRotatedPoint(seat.offset.func_72441_c(0.0, (double)(-seat.getHeight() / 2.0f) + passenger.func_70033_W() + (double)passenger.field_70131_O, 0.0), this.field_70125_A, this.field_70177_z, this.rotationRoll);
            passenger.func_70107_b(this.field_70165_t + posVec.field_72450_a, this.field_70163_u + posVec.field_72448_b - (double)passenger.field_70131_O, this.field_70161_v + posVec.field_72449_c);
            passenger.field_70159_w = this.field_70159_w;
            passenger.field_70181_x = this.field_70181_x;
            passenger.field_70179_y = this.field_70179_y;
        } else if (this.pack != null && !this.riderSeatPositions.isEmpty()) {
            Double[] seatLocation = this.riderSeatPositions.get(this.func_184188_bt().indexOf(passenger));
            APart part = this.getPartAtLocation(seatLocation[0], seatLocation[1], seatLocation[2]);
            if (part instanceof PartSeat) {
                this.riderSeats.put((Object)passenger.func_145782_y(), (Object)((PartSeat)part));
            } else {
                MTS.MTSLog.error("ERROR: NO SEAT FOUND WHEN LINKING RIDER TO SEAT IN VEHICLE!");
                if (!this.field_70170_p.field_72995_K) {
                    passenger.func_184210_p();
                }
                return;
            }
        }
    }

    @Override
    public void addPart(APart part, boolean ignoreCollision) {
        if (!ignoreCollision && part.isPartCollidingWithBlocks(Vec3d.field_186680_a)) {
            this.rotationRoll = 0.0f;
        }
        super.addPart(part, ignoreCollision);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public APart getHitPart(Entity entity) {
        Vec3d lookVec = entity.func_70676_i(1.0f);
        Vec3d hitVec = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        for (float f = 1.0f; f < 4.0f; f += 0.1f) {
            for (APart part : this.getVehicleParts()) {
                if (!part.getAABBWithOffset(Vec3d.field_186680_a).func_72318_a(hitVec)) continue;
                return part;
            }
            hitVec = hitVec.func_72441_c(lookVec.field_72450_a * (double)0.1f, lookVec.field_72448_b * (double)0.1f, lookVec.field_72449_c * (double)0.1f);
        }
        return null;
    }

    public void setRiderInSeat(Entity rider, PartSeat seat) {
        this.didRiderClickSeat = true;
        this.riderSeats.put((Object)rider.func_145782_y(), (Object)seat);
        rider.func_184205_a((Entity)this, true);
        rider.field_70177_z = (float)((double)this.field_70177_z + seat.partRotation.field_72448_b);
        if (!this.field_70170_p.field_72995_K) {
            MTS.MTSNet.sendToAll((IMessage)new PacketPartSeatRiderChange(seat, rider, true));
        }
    }

    public void removeRiderFromSeat(Entity rider, PartSeat seat) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)rider, null, (String[])ridingEntityNames);
        }
        catch (Exception e) {
            MTS.MTSLog.fatal("ERROR IN VEHICLE RIDER REFLECTION!");
            return;
        }
        this.riderSeats.remove((Object)rider.func_145782_y());
        this.func_184225_p(rider);
        rider.func_70095_a(false);
        if (!this.field_70170_p.field_72995_K) {
            PackVehicleObject.PackPart packPart = this.getPackDefForLocation(seat.offset.field_72450_a, seat.offset.field_72448_b, seat.offset.field_72449_c);
            Vec3d placePosition = packPart.dismountPos != null ? RotationSystem.getRotatedPoint(new Vec3d((double)packPart.dismountPos[0], (double)packPart.dismountPos[1], (double)packPart.dismountPos[2]), this.field_70125_A, this.field_70177_z, this.rotationRoll).func_178787_e(this.func_174791_d()) : RotationSystem.getRotatedPoint(seat.offset.func_72441_c(seat.offset.field_72450_a > 0.0 ? 2.0 : -2.0, 0.0, 0.0), this.field_70125_A, this.field_70177_z, this.rotationRoll).func_178787_e(this.func_174791_d());
            AxisAlignedBB collisionDetectionBox = new AxisAlignedBB(new BlockPos(placePosition));
            if (!this.field_70170_p.func_184143_b(collisionDetectionBox)) {
                rider.func_70080_a(placePosition.field_72450_a, collisionDetectionBox.field_72338_b, placePosition.field_72449_c, rider.field_70177_z, rider.field_70125_A);
            } else if (rider instanceof EntityLivingBase) {
                ((EntityLivingBase)rider).func_110145_l((Entity)this);
            }
            MTS.MTSNet.sendToAll((IMessage)new PacketPartSeatRiderChange(seat, rider, false));
        }
    }

    public Entity getRiderForSeat(PartSeat seat) {
        return this.riderSeats.inverse().containsKey((Object)seat) ? this.field_70170_p.func_73045_a(((Integer)this.riderSeats.inverse().get((Object)seat)).intValue()) : null;
    }

    public PartSeat getSeatForRider(Entity rider) {
        return (PartSeat)this.riderSeats.get((Object)rider.func_145782_y());
    }

    public void destroyAtPosition(double x, double y, double z) {
        this.func_70106_y();
        for (APart part : this.getVehicleParts()) {
            if (part.getItemForPart() == null) continue;
            ItemStack partStack = new ItemStack(part.getItemForPart());
            NBTTagCompound stackTag = part.getPartNBTTag();
            if (stackTag != null) {
                partStack.func_77982_d(stackTag);
            }
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, part.partPos.field_72450_a, part.partPos.field_72448_b, part.partPos.field_72449_c, partStack));
        }
        double crashItemDropPercentage = ConfigSystem.getDoubleConfig("CrashItemDropPercentage");
        for (ItemStack craftingStack : PackParserSystem.getMaterials(this.vehicleName)) {
            for (int i = 0; i < craftingStack.func_190916_E(); i = (int)((byte)(i + 1))) {
                if (!(this.field_70146_Z.nextDouble() < crashItemDropPercentage)) continue;
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(craftingStack.func_77973_b(), 1, craftingStack.func_77960_j())));
            }
        }
    }

    public void attackManuallyAtPosition(double x, double y, double z, DamageSource source, float damage) {
        for (APart part : this.getVehicleParts()) {
            if (!part.getAABBWithOffset(Vec3d.field_186680_a).func_72318_a(new Vec3d(x, y, z))) continue;
            part.attackPart(source, damage);
            return;
        }
        if (this.brokenWindows < this.pack.rendering.numberWindows) {
            this.brokenWindows = (byte)(this.brokenWindows + 1);
            this.func_184185_a(SoundEvents.field_187561_bM, 2.0f, 1.0f);
            MTS.MTSNet.sendToAll((IMessage)new PacketVehicleWindowBreak(this));
        }
    }

    protected float getCurrentMass() {
        int currentMass = this.pack.general.emptyMass;
        for (APart part : this.getVehicleParts()) {
            if (part instanceof PartCrate) {
                currentMass = (int)((float)currentMass + EntityVehicleB_Existing.calculateInventoryWeight((IInventory)((PartCrate)part).crateInventory));
                continue;
            }
            if (part instanceof PartBarrel) {
                currentMass += ((PartBarrel)part).getFluidAmount() / 50;
                continue;
            }
            currentMass += 50;
        }
        for (Entity passenger : this.func_184188_bt()) {
            if (passenger instanceof EntityPlayer) {
                currentMass = (int)((float)currentMass + (100.0f + EntityVehicleB_Existing.calculateInventoryWeight((IInventory)((EntityPlayer)passenger).field_71071_by)));
                continue;
            }
            currentMass += 100;
        }
        return currentMass;
    }

    private static float calculateInventoryWeight(IInventory inventory) {
        float weight = 0.0f;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            weight += 1.2f * (float)stack.func_190916_E() / (float)stack.func_77976_d() * (float)(ConfigSystem.getStringConfig("HeavyItems").contains(stack.func_77973_b().func_77658_a().substring(5)) ? 2 : 1);
        }
        return weight;
    }

    protected void updateHeadingVec() {
        double f1 = Math.cos(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI);
        double f2 = Math.sin(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI);
        double f3 = -Math.cos(-this.field_70125_A * ((float)Math.PI / 180));
        double f4 = Math.sin(-this.field_70125_A * ((float)Math.PI / 180));
        this.headingVec = new Vec3d(f2 * f3, f4, f1 * f3);
    }

    protected abstract void getBasicProperties();

    public abstract float getSteerAngle();

    @Override
    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.locked = tagCompound.func_74767_n("locked");
        this.brokenWindows = tagCompound.func_74771_c("brokenWindows");
        this.rotationRoll = tagCompound.func_74760_g("rotationRoll");
        this.ownerName = tagCompound.func_74779_i("ownerName");
        this.displayText = tagCompound.func_74779_i("displayText");
        this.riderSeatPositions.clear();
        while (tagCompound.func_74764_b("Seat" + String.valueOf(this.riderSeatPositions.size()) + "0")) {
            Double[] seatPosition = new Double[]{tagCompound.func_74769_h("Seat" + String.valueOf(this.riderSeatPositions.size()) + "0"), tagCompound.func_74769_h("Seat" + String.valueOf(this.riderSeatPositions.size()) + "1"), tagCompound.func_74769_h("Seat" + String.valueOf(this.riderSeatPositions.size()) + "2")};
            this.riderSeatPositions.add(seatPosition);
        }
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74757_a("locked", this.locked);
        tagCompound.func_74774_a("brokenWindows", this.brokenWindows);
        tagCompound.func_74776_a("rotationRoll", this.rotationRoll);
        tagCompound.func_74778_a("ownerName", this.ownerName);
        tagCompound.func_74778_a("displayText", this.displayText);
        for (int i = 0; i < this.func_184188_bt().size(); i = (int)((byte)(i + 1))) {
            Entity rider = (Entity)this.func_184188_bt().get(i);
            PartSeat seat = this.getSeatForRider(rider);
            if (seat == null) continue;
            tagCompound.func_74780_a("Seat" + String.valueOf(i) + "0", seat.offset.field_72450_a);
            tagCompound.func_74780_a("Seat" + String.valueOf(i) + "1", seat.offset.field_72448_b);
            tagCompound.func_74780_a("Seat" + String.valueOf(i) + "2", seat.offset.field_72449_c);
        }
        return tagCompound;
    }
}

