/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBB;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBBCollective;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleB_Existing;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevicePontoon;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityVehicleC_Colliding
extends EntityVehicleB_Existing {
    private VehicleAxisAlignedBBCollective collisionFrame;
    private final List<VehicleAxisAlignedBB> currentCollisionBoxes = new ArrayList<VehicleAxisAlignedBB>();
    private final List<VehicleAxisAlignedBB> currentInteractionBoxes = new ArrayList<VehicleAxisAlignedBB>();
    protected final Map<VehicleAxisAlignedBB, APartGroundDevice> groundDeviceCollisionBoxMap = new HashMap<VehicleAxisAlignedBB, APartGroundDevice>();
    public final double speedFactor = ConfigSystem.getDoubleConfig("SpeedFactor");
    private float hardnessHitThisTick = 0.0f;

    public EntityVehicleC_Colliding(World world) {
        super(world);
    }

    public EntityVehicleC_Colliding(World world, float posX, float posY, float posZ, float playerRotation, String vehicleName) {
        super(world, posX, posY, posZ, playerRotation, vehicleName);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.pack != null) {
            if (World.MAX_ENTITY_RADIUS < 32.0) {
                World.MAX_ENTITY_RADIUS = 32.0;
            }
            this.currentCollisionBoxes.clear();
            this.currentInteractionBoxes.clear();
            this.groundDeviceCollisionBoxMap.clear();
            this.currentCollisionBoxes.addAll(this.getUpdatedCollisionBoxes());
            this.hardnessHitThisTick = 0.0f;
            for (APart part : this.getVehicleParts()) {
                if (part instanceof APartGroundDevice) {
                    this.currentCollisionBoxes.add(part.getAABBWithOffset(Vec3d.field_186680_a));
                    this.groundDeviceCollisionBoxMap.put(this.currentCollisionBoxes.get(this.currentCollisionBoxes.size() - 1), (APartGroundDevice)part);
                    continue;
                }
                this.currentInteractionBoxes.add(part.getAABBWithOffset(Vec3d.field_186680_a));
            }
        }
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.getCollisionBoundingBox();
    }

    @Nullable
    public VehicleAxisAlignedBBCollective getCollisionBoundingBox() {
        return this.collisionFrame != null ? this.collisionFrame : new VehicleAxisAlignedBBCollective(this, 1.0f, 1.0f);
    }

    public List<VehicleAxisAlignedBB> getCurrentCollisionBoxes() {
        return this.currentCollisionBoxes;
    }

    public List<VehicleAxisAlignedBB> getCurrentInteractionBoxes() {
        return this.currentInteractionBoxes;
    }

    private List<VehicleAxisAlignedBB> getUpdatedCollisionBoxes() {
        if (this.pack != null) {
            double furthestWidth = 0.0;
            double furthestHeight = 0.0;
            ArrayList<VehicleAxisAlignedBB> boxList = new ArrayList<VehicleAxisAlignedBB>();
            for (PackVehicleObject.PackCollisionBox box : this.pack.collision) {
                Vec3d partOffset = new Vec3d((double)box.pos[0], (double)box.pos[1], (double)box.pos[2]);
                Vec3d offset = RotationSystem.getRotatedPoint(partOffset, this.field_70125_A, this.field_70177_z, this.rotationRoll);
                VehicleAxisAlignedBB newBox = new VehicleAxisAlignedBB(this.func_174791_d().func_178787_e(offset), partOffset, box.width, box.height, box.isInterior);
                boxList.add(newBox);
                furthestWidth = (float)Math.max(furthestWidth, Math.abs(newBox.rel.field_72450_a) + (double)(box.width / 2.0f));
                furthestHeight = (float)Math.max(furthestHeight, Math.abs(newBox.rel.field_72448_b) + (double)(box.height / 2.0f));
                furthestWidth = (float)Math.max(furthestWidth, Math.abs(newBox.rel.field_72449_c) + (double)(box.width / 2.0f));
            }
            this.collisionFrame = new VehicleAxisAlignedBBCollective(this, (float)furthestWidth * 2.0f + 0.5f, (float)furthestHeight * 2.0f + 0.5f);
            return boxList;
        }
        return new ArrayList<VehicleAxisAlignedBB>(0);
    }

    public boolean wasVehicleClicked(Entity entity) {
        Vec3d lookVec = entity.func_70676_i(1.0f);
        Vec3d hitVec = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        for (float f = 1.0f; f < 4.0f; f += 0.1f) {
            for (VehicleAxisAlignedBB box : this.currentCollisionBoxes) {
                if (!box.func_72318_a(hitVec)) continue;
                return true;
            }
            for (VehicleAxisAlignedBB box : this.currentInteractionBoxes) {
                if (!box.func_72318_a(hitVec)) continue;
                return true;
            }
            hitVec = hitVec.func_72441_c(lookVec.field_72450_a * (double)0.1f, lookVec.field_72448_b * (double)0.1f, lookVec.field_72449_c * (double)0.1f);
        }
        return false;
    }

    protected float getCollisionForAxis(VehicleAxisAlignedBB box, boolean xAxis, boolean yAxis, boolean zAxis, APartGroundDevice optionalGroundDevice) {
        Vec3d motion = new Vec3d(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor);
        box = box.offset(xAxis ? motion.field_72450_a : 0.0, yAxis ? motion.field_72448_b : 0.0, zAxis ? motion.field_72449_c : 0.0);
        if (xAxis || zAxis) {
            box = box.offset(0.0, 0.05f, 0.0);
        }
        ArrayList<BlockPos> collidedBlockPos = new ArrayList<BlockPos>();
        List<AxisAlignedBB> collidingAABBList = this.getAABBCollisions(box, optionalGroundDevice, collidedBlockPos);
        float collisionDepth = 0.0f;
        for (AxisAlignedBB box2 : collidingAABBList) {
            if (xAxis) {
                collisionDepth = (float)Math.max((double)collisionDepth, motion.field_72450_a > 0.0 ? box.field_72336_d - box2.field_72340_a : box2.field_72336_d - box.field_72340_a);
            }
            if (yAxis) {
                collisionDepth = (float)Math.max((double)collisionDepth, motion.field_72448_b > 0.0 ? box.field_72337_e - box2.field_72338_b : box2.field_72337_e - box.field_72338_b);
            }
            if (zAxis) {
                collisionDepth = (float)Math.max((double)collisionDepth, motion.field_72449_c > 0.0 ? box.field_72334_f - box2.field_72339_c : box2.field_72334_f - box.field_72339_c);
            }
            if (!((double)collisionDepth > 0.3) || !(xAxis && Math.abs(motion.field_72450_a) < (double)collisionDepth || yAxis && Math.abs(motion.field_72448_b) < (double)collisionDepth) && (!zAxis || !(Math.abs(motion.field_72449_c) < (double)collisionDepth)) || optionalGroundDevice != null) continue;
            return 0.0f;
        }
        if (collisionDepth > 0.0f) {
            if (optionalGroundDevice != null && !yAxis) {
                collidingAABBList = this.getAABBCollisions(box.offset(xAxis ? motion.field_72450_a : 0.0, optionalGroundDevice.getHeight() * 1.5f, zAxis ? motion.field_72449_c : 0.0).expandXyz(0.05f), optionalGroundDevice, null);
                if (collidingAABBList.isEmpty()) {
                    return -3.0f;
                }
                if ((double)collisionDepth > 0.3) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.removePart(optionalGroundDevice, true);
                    }
                    return -1.0f;
                }
            } else if (optionalGroundDevice == null) {
                double velocity = Math.hypot(motion.field_72450_a, motion.field_72449_c);
                if (velocity > 0.0 && !yAxis) {
                    int blockPosIndex = 0;
                    while (blockPosIndex < collidedBlockPos.size()) {
                        BlockPos pos = (BlockPos)collidedBlockPos.get(blockPosIndex);
                        float hardness = this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos);
                        if ((double)hardness <= velocity * this.currentMass / 250.0 && hardness >= 0.0f) {
                            this.hardnessHitThisTick += hardness;
                            if (ConfigSystem.getBooleanConfig("BlockBreakage")) {
                                collidedBlockPos.remove(blockPosIndex);
                                this.field_70159_w *= Math.max(1.0 - (double)(hardness * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0);
                                this.field_70181_x *= Math.max(1.0 - (double)(hardness * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0);
                                this.field_70179_y *= Math.max(1.0 - (double)(hardness * 0.5f) / ((1000.0 + this.currentMass) / 1000.0), 0.0);
                                if (this.field_70170_p.field_72995_K) continue;
                                this.field_70170_p.func_175655_b(pos, true);
                                continue;
                            }
                            blockPosIndex = (byte)(blockPosIndex + 1);
                            continue;
                        }
                        blockPosIndex = (byte)(blockPosIndex + 1);
                    }
                    if ((double)this.hardnessHitThisTick > this.currentMass / (0.75 + velocity) / 250.0) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.destroyAtPosition(box.pos.field_72450_a, box.pos.field_72448_b, box.pos.field_72449_c);
                        }
                        return -2.0f;
                    }
                    if (collidedBlockPos.isEmpty()) {
                        return 0.0f;
                    }
                }
                if ((double)collisionDepth > 0.3) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.destroyAtPosition(box.pos.field_72450_a, box.pos.field_72448_b, box.pos.field_72449_c);
                    }
                    return -2.0f;
                }
            }
        }
        return collisionDepth;
    }

    protected List<AxisAlignedBB> getAABBCollisions(AxisAlignedBB box, APartGroundDevice optionalGroundDevice, List<BlockPos> collidedBlockPos) {
        int minX = (int)Math.floor(box.field_72340_a);
        int maxX = (int)Math.floor(box.field_72336_d + 1.0);
        int minY = (int)Math.floor(box.field_72338_b);
        int maxY = (int)Math.floor(box.field_72337_e + 1.0);
        int minZ = (int)Math.floor(box.field_72339_c);
        int maxZ = (int)Math.floor(box.field_72334_f + 1.0);
        ArrayList<AxisAlignedBB> collidingAABBList = new ArrayList<AxisAlignedBB>();
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c().func_176209_a(state, false)) {
                        state.func_185908_a(this.field_70170_p, pos, box, collidingAABBList, null, false);
                        if (collidedBlockPos != null) {
                            collidedBlockPos.add(pos);
                        }
                    }
                    if (!(optionalGroundDevice instanceof PartGroundDevicePontoon) || !state.func_185904_a().func_76224_d()) continue;
                    collidingAABBList.add(state.func_185900_c((IBlockAccess)this.field_70170_p, pos).func_186670_a(pos));
                }
            }
        }
        return collidingAABBList;
    }
}

