/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.packets.control.AileronPacket;
import minecrafttransportsimulator.packets.control.ElevatorPacket;
import minecrafttransportsimulator.packets.control.RudderPacket;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class EntityVehicleF_Plane
extends EntityVehicleE_Powered {
    public boolean reverseThrust;
    public short reversePercent;
    public short aileronAngle;
    public short elevatorAngle;
    public short rudderAngle;
    public short flapDesiredAngle;
    public short flapCurrentAngle;
    public short aileronTrim;
    public short elevatorTrim;
    public short rudderTrim;
    public short aileronCooldown;
    public short elevatorCooldown;
    public short rudderCooldown;
    public double trackAngle;
    public Vec3d verticalVec = Vec3d.field_186680_a;
    public Vec3d sideVec = Vec3d.field_186680_a;
    private float momentRoll;
    private float momentPitch;
    private float momentYaw;
    private double currentWingArea;
    private double dragCoeff;
    private double wingLiftCoeff;
    private double aileronLiftCoeff;
    private double elevatorLiftCoeff;
    private double rudderLiftCoeff;
    private double thrust;
    private double thrustForce;
    private double dragForce;
    private double wingForce;
    private double aileronForce;
    private double elevatorForce;
    private double rudderForce;
    private double gravitationalForce;
    private double thrustTorque;
    private double aileronTorque;
    private double elevatorTorque;
    private double rudderTorque;
    private double gravitationalTorque;

    public EntityVehicleF_Plane(World world) {
        super(world);
    }

    public EntityVehicleF_Plane(World world, float posX, float posY, float posZ, float rotation, String name) {
        super(world, posX, posY, posZ, rotation, name);
    }

    @Override
    protected void getBasicProperties() {
        if (this.reverseThrust && this.reversePercent < 100) {
            this.reversePercent = (short)(this.reversePercent + 1);
        } else if (!this.reverseThrust && this.reversePercent > 0) {
            this.reversePercent = (short)(this.reversePercent - 1);
        }
        if (this.flapCurrentAngle < this.flapDesiredAngle) {
            this.flapCurrentAngle = (short)(this.flapCurrentAngle + 1);
        } else if (this.flapCurrentAngle > this.flapDesiredAngle) {
            this.flapCurrentAngle = (short)(this.flapCurrentAngle - 1);
        }
        this.momentRoll = (float)((double)this.pack.general.emptyMass * (1.5 + this.fuel / 10000.0));
        this.momentPitch = (float)(2.0 * this.currentMass);
        this.momentYaw = (float)(3.0 * this.currentMass);
        this.currentWingArea = this.pack.plane.wingArea + this.pack.plane.wingArea * (float)this.flapCurrentAngle / 250.0f;
        this.verticalVec = RotationSystem.getRotatedY(this.field_70125_A, this.field_70177_z, this.rotationRoll);
        this.sideVec = this.headingVec.func_72431_c(this.verticalVec);
        this.velocityVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.velocity = this.velocityVec.func_72430_b(this.headingVec);
        this.velocityVec = this.velocityVec.func_72432_b();
        this.trackAngle = Math.toDegrees(Math.atan2(this.velocityVec.func_72430_b(this.verticalVec), this.velocityVec.func_72430_b(this.headingVec)));
        this.dragCoeff = (double)4.0E-4f * Math.pow(this.trackAngle, 2.0) + (double)0.03f;
        this.wingLiftCoeff = this.getLiftCoeff(-this.trackAngle, 2.0f + (float)this.flapCurrentAngle / 350.0f);
        this.aileronLiftCoeff = this.getLiftCoeff((float)(this.aileronAngle + this.aileronTrim) / 10.0f, 2.0);
        this.elevatorLiftCoeff = this.getLiftCoeff((double)this.pack.plane.defaultElevatorAngle - this.trackAngle - (double)((float)(this.elevatorAngle + this.elevatorTrim) / 10.0f), 2.0);
        this.rudderLiftCoeff = this.getLiftCoeff((double)((float)(this.rudderAngle + this.rudderTrim) / 10.0f) + Math.toDegrees(Math.atan2(this.velocityVec.func_72430_b(this.sideVec), this.velocityVec.func_72430_b(this.headingVec))), 2.0);
    }

    @Override
    protected void getForcesAndMotions() {
        this.thrustTorque = 0.0;
        this.thrustForce = 0.0;
        for (byte i = 0; i < this.getNumberEngineBays(); i = (byte)(i + 1)) {
            APartEngine engine = this.getEngineByNumber(i);
            if (engine == null) continue;
            this.thrust = engine.getForceOutput();
            this.thrustForce += this.thrust;
            this.thrustTorque += this.thrust * engine.offset.field_72450_a;
        }
        this.dragForce = 0.5 * this.airDensity * this.velocity * this.velocity * this.currentWingArea * (this.dragCoeff + this.wingLiftCoeff * this.wingLiftCoeff / (Math.PI * (double)this.pack.plane.wingSpan * (double)this.pack.plane.wingSpan / this.currentWingArea * 0.8));
        this.wingForce = 0.5 * this.airDensity * this.velocity * this.velocity * this.currentWingArea * this.wingLiftCoeff;
        this.aileronForce = 0.5 * this.airDensity * this.velocity * this.velocity * (double)this.pack.plane.wingArea / 5.0 * this.aileronLiftCoeff;
        this.elevatorForce = 0.5 * this.airDensity * this.velocity * this.velocity * (double)this.pack.plane.elevatorArea * this.elevatorLiftCoeff;
        this.rudderForce = 0.5 * this.airDensity * this.velocity * this.velocity * (double)this.pack.plane.rudderArea * this.rudderLiftCoeff;
        this.gravitationalForce = this.currentMass * 0.0245;
        this.aileronTorque = this.aileronForce * (double)this.pack.plane.wingSpan * 0.5 * 0.75;
        this.elevatorTorque = this.elevatorForce * (double)this.pack.plane.tailDistance;
        this.rudderTorque = this.rudderForce * (double)this.pack.plane.tailDistance;
        this.gravitationalTorque = this.gravitationalForce * 1.0;
        if (this.velocity < 0.0 && this.groundedGroundDevices.isEmpty() && this.field_70125_A < 0.0f && this.field_70125_A >= -120.0f) {
            this.elevatorTorque += 100.0;
        }
        this.field_70159_w += (this.headingVec.field_72450_a * this.thrustForce - this.velocityVec.field_72450_a * this.dragForce + this.verticalVec.field_72450_a * (this.wingForce + this.elevatorForce)) / this.currentMass;
        this.field_70179_y += (this.headingVec.field_72449_c * this.thrustForce - this.velocityVec.field_72449_c * this.dragForce + this.verticalVec.field_72449_c * (this.wingForce + this.elevatorForce)) / this.currentMass;
        this.field_70181_x += (this.headingVec.field_72448_b * this.thrustForce - this.velocityVec.field_72448_b * this.dragForce + this.verticalVec.field_72448_b * (this.wingForce + this.elevatorForce) - this.gravitationalForce) / this.currentMass;
        this.motionRoll = (float)(57.29577951308232 * ((1.0 - this.headingVec.field_72448_b) * this.aileronTorque) / (double)this.momentRoll);
        this.motionPitch = (float)(57.29577951308232 * ((1.0 - Math.abs(this.sideVec.field_72448_b)) * this.elevatorTorque - this.sideVec.field_72448_b * (this.thrustTorque + this.rudderTorque) + (1.0 - Math.abs(this.headingVec.field_72448_b)) * this.gravitationalTorque) / (double)this.momentPitch);
        this.motionYaw = (float)(57.29577951308232 * (this.headingVec.field_72448_b * this.aileronTorque - this.verticalVec.field_72448_b * (-this.thrustTorque - this.rudderTorque) + this.sideVec.field_72448_b * this.elevatorTorque) / (double)this.momentYaw);
    }

    @Override
    protected void dampenControlSurfaces() {
        if (this.aileronCooldown == 0) {
            if (this.aileronAngle != 0) {
                MTS.MTSNet.sendToAll((IMessage)new AileronPacket(this.func_145782_y(), this.aileronAngle < 0, 0));
                this.aileronAngle = (short)(this.aileronAngle + (this.aileronAngle < 0 ? 6 : -6));
            }
        } else {
            this.aileronCooldown = (short)(this.aileronCooldown - 1);
        }
        if (this.elevatorCooldown == 0) {
            if (this.elevatorAngle != 0) {
                MTS.MTSNet.sendToAll((IMessage)new ElevatorPacket(this.func_145782_y(), this.elevatorAngle < 0, 0));
                this.elevatorAngle = (short)(this.elevatorAngle + (this.elevatorAngle < 0 ? 6 : -6));
            }
        } else {
            this.elevatorCooldown = (short)(this.elevatorCooldown - 1);
        }
        if (this.rudderCooldown == 0) {
            if (this.rudderAngle != 0) {
                MTS.MTSNet.sendToAll((IMessage)new RudderPacket(this.func_145782_y(), this.rudderAngle < 0, 0));
                this.rudderAngle = (short)(this.rudderAngle + (this.rudderAngle < 0 ? 6 : -6));
            }
        } else {
            this.rudderCooldown = (short)(this.rudderCooldown - 1);
        }
    }

    @Override
    public float getSteerAngle() {
        return (float)(-this.rudderAngle) / 10.0f;
    }

    private double getLiftCoeff(double angleOfAttack, double maxLiftCoeff) {
        if (Math.abs(angleOfAttack) <= 18.75) {
            return maxLiftCoeff * Math.sin(1.5707963267948966 * angleOfAttack / 15.0);
        }
        if (Math.abs(angleOfAttack) <= 22.5) {
            if (angleOfAttack > 0.0) {
                return maxLiftCoeff * (0.4 + 1.0 / (angleOfAttack - 15.0));
            }
            return maxLiftCoeff * (-0.4 + 1.0 / (angleOfAttack + 15.0));
        }
        return maxLiftCoeff * Math.sin(0.5235987755982988 * angleOfAttack / 15.0);
    }

    @Override
    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.aileronAngle = tagCompound.func_74765_d("aileronAngle");
        this.elevatorAngle = tagCompound.func_74765_d("elevatorAngle");
        this.rudderAngle = tagCompound.func_74765_d("rudderAngle");
        this.flapDesiredAngle = tagCompound.func_74765_d("flapDesiredAngle");
        this.flapCurrentAngle = tagCompound.func_74765_d("flapCurrentAngle");
        this.aileronTrim = tagCompound.func_74765_d("aileronTrim");
        this.elevatorTrim = tagCompound.func_74765_d("elevatorTrim");
        this.rudderTrim = tagCompound.func_74765_d("rudderTrim");
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74777_a("aileronAngle", this.aileronAngle);
        tagCompound.func_74777_a("elevatorAngle", this.elevatorAngle);
        tagCompound.func_74777_a("rudderAngle", this.rudderAngle);
        tagCompound.func_74777_a("flapDesiredAngle", this.flapDesiredAngle);
        tagCompound.func_74777_a("flapCurrentAngle", this.flapCurrentAngle);
        tagCompound.func_74777_a("aileronTrim", this.aileronTrim);
        tagCompound.func_74777_a("elevatorTrim", this.elevatorTrim);
        tagCompound.func_74777_a("rudderTrim", this.rudderTrim);
        return tagCompound;
    }
}

