/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBB;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public abstract class APart {
    public final boolean isController;
    public final boolean turnsWithSteer;
    public final Vec3d offset;
    public final EntityVehicleE_Powered vehicle;
    public final String partName;
    public final PackPartObject pack;
    public final Vec3d partRotation;
    public final boolean overrideMirror;
    public final APart parentPart;
    public final List<APart> childParts = new ArrayList<APart>();
    public Vec3d partPos;
    private boolean isValid;
    private ResourceLocation modelLocation;

    public APart(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        this.vehicle = vehicle;
        this.offset = new Vec3d((double)packPart.pos[0], (double)packPart.pos[1], (double)packPart.pos[2]);
        this.partName = partName;
        this.pack = PackParserSystem.getPartPack(partName);
        this.partPos = RotationSystem.getRotatedPoint(this.offset, vehicle.field_70125_A, vehicle.field_70177_z, vehicle.rotationRoll).func_178787_e(this.vehicle.func_174791_d());
        this.partRotation = packPart.rot != null ? new Vec3d((double)packPart.rot[0], (double)packPart.rot[1], (double)packPart.rot[2]) : Vec3d.field_186680_a;
        this.isController = packPart.isController;
        this.turnsWithSteer = packPart.turnsWithSteer;
        this.overrideMirror = packPart.overrideMirror;
        this.isValid = true;
        if (this.isValid()) {
            for (PackVehicleObject.PackPart parentPackPart : vehicle.pack.parts) {
                if (!packPart.equals(parentPackPart.additionalPart)) continue;
                this.parentPart = vehicle.getPartAtLocation(parentPackPart.pos[0], parentPackPart.pos[1], parentPackPart.pos[2]);
                this.parentPart.childParts.add(this);
                return;
            }
            for (APart part : vehicle.getVehicleParts()) {
                if (part.pack.subParts == null) continue;
                for (PackVehicleObject.PackPart partSubPartPack : part.pack.subParts) {
                    if ((float)part.offset.field_72450_a + partSubPartPack.pos[0] != (float)this.offset.field_72450_a || (float)part.offset.field_72448_b + partSubPartPack.pos[1] != (float)this.offset.field_72448_b || (float)part.offset.field_72449_c + partSubPartPack.pos[2] != (float)this.offset.field_72449_c) continue;
                    this.parentPart = part;
                    this.parentPart.childParts.add(this);
                    return;
                }
            }
        }
        this.parentPart = null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean interactPart(EntityPlayer player) {
        return false;
    }

    public void attackPart(DamageSource source, float damage) {
    }

    public void updatePart() {
        this.partPos = RotationSystem.getRotatedPoint(this.offset, this.vehicle.field_70125_A, this.vehicle.field_70177_z, this.vehicle.rotationRoll).func_178787_e(this.vehicle.func_174791_d());
    }

    public void removePart() {
        this.isValid = false;
        while (this.childParts.size() > 0) {
            Item droppedItem;
            APart childPart = this.childParts.get(0);
            childPart.removePart();
            this.vehicle.removePart(childPart, false);
            if (this.vehicle.field_70170_p.field_72995_K || (droppedItem = childPart.getItemForPart()) == null) continue;
            ItemStack droppedStack = new ItemStack(droppedItem);
            droppedStack.func_77982_d(childPart.getPartNBTTag());
            this.vehicle.field_70170_p.func_72838_d((Entity)new EntityItem(this.vehicle.field_70170_p, childPart.partPos.field_72450_a, childPart.partPos.field_72448_b, childPart.partPos.field_72449_c, droppedStack));
        }
        if (this.parentPart != null) {
            this.parentPart.childParts.remove(this);
        }
    }

    public abstract NBTTagCompound getPartNBTTag();

    public abstract float getWidth();

    public abstract float getHeight();

    public Item getItemForPart() {
        return MTSRegistry.partItemMap.get(this.partName);
    }

    public ResourceLocation getModelLocation() {
        if (this.modelLocation == null) {
            this.modelLocation = this.pack.general.modelName != null ? new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/parts/" + this.pack.general.modelName + ".obj") : new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/parts/" + this.partName.substring(this.partName.indexOf(58) + 1) + ".obj");
        }
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation() {
        return new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "textures/parts/" + this.partName.substring(this.partName.indexOf(58) + 1) + ".png");
    }

    public final VehicleAxisAlignedBB getAABBWithOffset(Vec3d boxOffset) {
        Vec3d totalOffset = this.partPos.func_178787_e(boxOffset);
        return new VehicleAxisAlignedBB(totalOffset, this.offset, this.getWidth(), this.getHeight(), false);
    }

    public Vec3d getActionRotation(float partialTicks) {
        return Vec3d.field_186680_a;
    }

    public boolean isPartCollidingWithBlocks(Vec3d collisionOffset) {
        return !this.vehicle.field_70170_p.func_184144_a(null, (AxisAlignedBB)this.getAABBWithOffset(collisionOffset)).isEmpty();
    }
}

