/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.core.ItemJumperCable;
import minecrafttransportsimulator.packets.general.PacketChat;
import minecrafttransportsimulator.packets.parts.PacketPartEngineDamage;
import minecrafttransportsimulator.packets.parts.PacketPartEngineLinked;
import minecrafttransportsimulator.packets.parts.PacketPartEngineSignal;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.SFXSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class APartEngine
extends APart
implements SFXSystem.FXPart {
    public boolean isCreative;
    public boolean oilLeak;
    public boolean fuelLeak;
    public boolean brokenStarter;
    public double hours;
    public EngineStates state = EngineStates.ENGINE_OFF;
    public boolean backfired;
    public byte starterLevel;
    public int internalFuel;
    public double fuelFlow;
    public double RPM;
    public double temp = 20.0;
    public double oilPressure = 90.0;
    private double ambientTemp;
    private double engineHeat;
    private double coolingFactor;
    public APartEngine linkedEngine;
    protected double engineRotationLast;
    protected double engineRotation;
    protected double engineDriveshaftRotation;
    protected double engineDriveshaftRotationLast;
    public static final float engineColdTemp = 30.0f;
    public static final float engineOverheatTemp1 = 115.556f;
    public static final float engineOverheatTemp2 = 121.111f;
    public static final float engineFailureTemp = 132.222f;
    public static final float engineOilDanger = 40.0f;
    public final float engineStallRPM;
    public final float engineStartRPM;

    public APartEngine(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.engineStallRPM = this.pack.engine.maxRPM < 15000 ? 300.0f : 1500.0f;
        this.engineStartRPM = this.pack.engine.maxRPM < 15000 ? 500.0f : 2000.0f;
        this.state = dataTag.func_74764_b("engineState") ? EngineStates.values()[dataTag.func_74771_c("engineState")] : EngineStates.ENGINE_OFF;
        this.isCreative = dataTag.func_74767_n("isCreative");
        this.oilLeak = dataTag.func_74767_n("oilLeak");
        this.fuelLeak = dataTag.func_74767_n("fuelLeak");
        this.brokenStarter = dataTag.func_74767_n("brokenStarter");
        this.hours = dataTag.func_74769_h("hours");
        this.RPM = dataTag.func_74769_h("rpm");
        MTS.proxy.addVehicleEngineSound(vehicle, this);
    }

    @Override
    public boolean interactPart(EntityPlayer player) {
        ItemStack heldStack;
        if (!this.vehicle.field_70170_p.field_72995_K && (heldStack = player.func_184614_ca()) != null && heldStack.func_77973_b() instanceof ItemJumperCable) {
            ItemJumperCable jumperCableItem = (ItemJumperCable)heldStack.func_77973_b();
            if (this.linkedEngine == null) {
                if (ItemJumperCable.lastEngineClicked == null) {
                    ItemJumperCable.lastEngineClicked = this;
                    MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.jumpercable.firstlink"), (EntityPlayerMP)player);
                } else if (!ItemJumperCable.lastEngineClicked.equals(this)) {
                    if (ItemJumperCable.lastEngineClicked.vehicle.equals((Object)this.vehicle)) {
                        MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.jumpercable.samevehicle"), (EntityPlayerMP)player);
                        ItemJumperCable.lastEngineClicked = null;
                    } else if (this.partPos.func_72438_d(ItemJumperCable.lastEngineClicked.partPos) < 15.0) {
                        this.linkedEngine = ItemJumperCable.lastEngineClicked;
                        ItemJumperCable.lastEngineClicked.linkedEngine = this;
                        ItemJumperCable.lastEngineClicked = null;
                        MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineLinked(this, this.linkedEngine));
                        MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.jumpercable.secondlink"), (EntityPlayerMP)player);
                    } else {
                        MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.jumpercable.toofar"), (EntityPlayerMP)player);
                        ItemJumperCable.lastEngineClicked = null;
                    }
                }
            } else {
                MTS.MTSNet.sendTo((IMessage)new PacketChat("interact.jumpercable.alreadylinked"), (EntityPlayerMP)player);
            }
        }
        return true;
    }

    @Override
    public void attackPart(DamageSource source, float damage) {
        if (source.func_94541_c()) {
            this.hours += (double)(damage * 10.0f);
            if (!this.oilLeak) {
                boolean bl = this.oilLeak = Math.random() < ConfigSystem.getDoubleConfig("EngineLeakProbability") * 10.0;
            }
            if (!this.fuelLeak) {
                boolean bl = this.fuelLeak = Math.random() < ConfigSystem.getDoubleConfig("EngineLeakProbability") * 10.0;
            }
            if (!this.brokenStarter) {
                this.brokenStarter = Math.random() < 0.05;
            }
            MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineDamage(this, damage * 10.0f));
        } else {
            this.hours += (double)damage;
            if (source.func_76352_a()) {
                if (!this.oilLeak) {
                    boolean bl = this.oilLeak = Math.random() < ConfigSystem.getDoubleConfig("EngineLeakProbability");
                }
                if (!this.fuelLeak) {
                    this.fuelLeak = Math.random() < ConfigSystem.getDoubleConfig("EngineLeakProbability");
                }
            }
            MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineDamage(this, damage));
        }
    }

    @Override
    public void updatePart() {
        super.updatePart();
        this.fuelFlow = 0.0;
        if (this.linkedEngine != null) {
            if (this.linkedEngine.partPos.func_72438_d(this.partPos) > 16.0) {
                this.linkedEngine.linkedEngine = null;
                this.linkedEngine = null;
                if (this.vehicle.field_70170_p.field_72995_K) {
                    MTS.MTSNet.sendToAllAround((IMessage)new PacketChat("interact.jumpercable.linkdropped"), new NetworkRegistry.TargetPoint(this.vehicle.field_70170_p.field_73011_w.getDimension(), this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, 16.0));
                }
            } else if (this.vehicle.electricPower + 0.5 < this.linkedEngine.vehicle.electricPower) {
                this.linkedEngine.vehicle.electricPower -= (double)0.005f;
                this.vehicle.electricPower += (double)0.005f;
            } else if (this.vehicle.electricPower > this.linkedEngine.vehicle.electricPower + 0.5) {
                this.vehicle.electricPower -= (double)0.005f;
                this.linkedEngine.vehicle.electricPower += (double)0.005f;
            } else {
                this.linkedEngine.linkedEngine = null;
                this.linkedEngine = null;
                if (this.vehicle.field_70170_p.field_72995_K) {
                    MTS.MTSNet.sendToAllAround((IMessage)new PacketChat("interact.jumpercable.powerequal"), new NetworkRegistry.TargetPoint(this.vehicle.field_70170_p.field_73011_w.getDimension(), this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, 16.0));
                }
            }
        }
        if (this.state.esOn) {
            if (this.starterLevel == 0 && this.vehicle.electricPower > 2.0) {
                this.starterLevel = (byte)(this.starterLevel + this.pack.engine.starterDuration);
                if (this.vehicle.field_70170_p.field_72995_K) {
                    MTS.proxy.playSound(this.partPos, this.partName + "_cranking", 1.0f, (float)(this.RPM / (double)this.engineStartRPM));
                }
            }
            if (this.starterLevel > 0) {
                this.vehicle.electricUsage += (double)0.05f;
                if (this.vehicle.fuel > (double)this.pack.engine.fuelConsumption * ConfigSystem.getDoubleConfig("FuelUsageFactor") && !this.isCreative) {
                    this.vehicle.fuel -= (double)this.pack.engine.fuelConsumption * ConfigSystem.getDoubleConfig("FuelUsageFactor");
                    this.fuelFlow += (double)this.pack.engine.fuelConsumption * ConfigSystem.getDoubleConfig("FuelUsageFactor");
                }
            }
        } else if (this.state.hsOn && this.starterLevel == 0) {
            EngineStates engineStates = this.state = this.state.magnetoOn ? EngineStates.MAGNETO_ON_STARTERS_OFF : EngineStates.ENGINE_OFF;
        }
        if (this.starterLevel > 0) {
            this.starterLevel = (byte)(this.starterLevel - 1);
            this.RPM = this.RPM < (double)this.engineStartRPM * 1.2 ? Math.min(this.RPM + (double)this.pack.engine.starterPower, (double)this.engineStartRPM * 1.2) : Math.max(this.RPM - (double)this.pack.engine.starterPower, (double)this.engineStartRPM * 1.2);
        }
        this.ambientTemp = (double)(25.0f * this.vehicle.field_70170_p.func_180494_b(this.vehicle.func_180425_c()).func_185353_n()) - 5.0 * (Math.pow(2.0, this.vehicle.field_70163_u / 400.0) - 1.0);
        this.coolingFactor = 0.001 + this.vehicle.velocity / 500.0;
        this.temp -= (this.temp - this.ambientTemp) * this.coolingFactor;
        this.vehicle.electricUsage -= 0.05 * this.RPM / (double)this.pack.engine.maxRPM;
        if (this.state.running) {
            this.oilPressure = Math.min(90.0 - this.temp / 10.0, this.oilPressure + this.RPM / (double)this.engineStartRPM - 0.5 * (double)(this.oilLeak ? 5.0f : 1.0f) * (this.oilPressure / 40.0));
            if (this.oilPressure < 40.0) {
                this.temp += Math.max(0.0, 20.0 * this.RPM / (double)this.pack.engine.maxRPM / 20.0);
                this.hours += 0.01;
            } else {
                this.temp += Math.max(0.0, (7.0 * this.RPM / (double)this.pack.engine.maxRPM - this.temp / 60.0) / 20.0);
                this.hours += 0.001;
            }
            if (this.RPM > (double)this.engineStartRPM * 1.5 && this.temp < 30.0) {
                this.hours += 0.001 * (this.RPM / (double)this.engineStartRPM - 1.0);
            }
            if (this.RPM > (double)APartEngine.getSafeRPMFromMax(this.pack.engine.maxRPM)) {
                this.hours += 0.001 * (this.RPM - (double)APartEngine.getSafeRPMFromMax(this.pack.engine.maxRPM)) / 10.0;
            }
            if (this.temp > (double)115.556f) {
                this.hours += 0.001 * (this.temp - (double)115.556f);
                if (this.temp > (double)132.222f && !this.vehicle.field_70170_p.field_72995_K) {
                    this.explodeEngine();
                }
            }
            if (this.hours > 200.0 && !this.vehicle.field_70170_p.field_72995_K && Math.random() < this.hours / 10000.0 * ((double)APartEngine.getSafeRPMFromMax(this.pack.engine.maxRPM) / (this.RPM + (double)(APartEngine.getSafeRPMFromMax(this.pack.engine.maxRPM) / 2)))) {
                this.backfireEngine();
            }
            if (!this.isCreative) {
                this.fuelFlow = Math.min((double)this.pack.engine.fuelConsumption * ConfigSystem.getDoubleConfig("FuelUsageFactor") * this.RPM * (double)(this.fuelLeak ? 1.5f : 1.0f) / (double)this.pack.engine.maxRPM, this.vehicle.fuel);
                this.vehicle.fuel -= this.fuelFlow;
            }
            if (!this.vehicle.field_70170_p.field_72995_K) {
                if (this.vehicle.fuel == 0.0 && this.pack.engine.fuelConsumption != 0.0f && !this.isCreative) {
                    this.stallEngine(PacketPartEngineSignal.PacketEngineTypes.FUEL_OUT);
                } else if (this.RPM < (double)this.engineStallRPM) {
                    this.stallEngine(PacketPartEngineSignal.PacketEngineTypes.TOO_SLOW);
                } else if (this.isInLiquid()) {
                    this.stallEngine(PacketPartEngineSignal.PacketEngineTypes.DROWN);
                }
            }
        } else {
            this.oilPressure = 0.0;
            if (this.RPM > (double)this.engineStartRPM && (this.vehicle.fuel > 0.0 || this.isCreative) && !this.isInLiquid() && this.state.magnetoOn && !this.vehicle.field_70170_p.field_72995_K) {
                this.startEngine();
            }
            if (this.internalFuel > 0) {
                --this.internalFuel;
                if (this.RPM < (double)this.engineStartRPM) {
                    this.internalFuel = 0;
                }
            }
        }
    }

    @Override
    public void removePart() {
        super.removePart();
        this.state = EngineStates.ENGINE_OFF;
    }

    @Override
    public NBTTagCompound getPartNBTTag() {
        NBTTagCompound partData = new NBTTagCompound();
        partData.func_74757_a("isCreative", this.isCreative);
        partData.func_74757_a("oilLeak", this.oilLeak);
        partData.func_74757_a("fuelLeak", this.fuelLeak);
        partData.func_74757_a("brokenStarter", this.brokenStarter);
        partData.func_74780_a("hours", this.hours);
        partData.func_74774_a("engineState", (byte)this.state.ordinal());
        partData.func_74780_a("rpm", this.RPM);
        return partData;
    }

    @Override
    public float getWidth() {
        return 1.0f;
    }

    @Override
    public float getHeight() {
        return 1.0f;
    }

    public void setMagnetoStatus(boolean on) {
        if (on) {
            if (this.state.equals((Object)EngineStates.MAGNETO_OFF_ES_ON)) {
                this.state = EngineStates.MAGNETO_ON_ES_ON;
            } else if (this.state.equals((Object)EngineStates.MAGNETO_OFF_HS_ON)) {
                this.state = EngineStates.MAGNETO_ON_HS_ON;
            } else if (this.state.equals((Object)EngineStates.ENGINE_OFF)) {
                this.state = EngineStates.MAGNETO_ON_STARTERS_OFF;
            }
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_ES_ON)) {
            this.state = EngineStates.MAGNETO_OFF_ES_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_HS_ON)) {
            this.state = EngineStates.MAGNETO_OFF_HS_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
            this.state = EngineStates.ENGINE_OFF;
        } else if (this.state.equals((Object)EngineStates.RUNNING)) {
            this.state = EngineStates.ENGINE_OFF;
            this.internalFuel = 100;
            MTS.proxy.playSound(this.partPos, this.partName + "_starting", 1.0f, 1.0f);
        }
    }

    public void setElectricStarterStatus(boolean engaged) {
        if (!this.brokenStarter) {
            if (engaged) {
                if (this.state.equals((Object)EngineStates.ENGINE_OFF)) {
                    this.state = EngineStates.MAGNETO_OFF_ES_ON;
                } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
                    this.state = EngineStates.MAGNETO_ON_ES_ON;
                } else if (this.state.equals((Object)EngineStates.RUNNING)) {
                    this.state = EngineStates.RUNNING_ES_ON;
                }
            } else if (this.state.equals((Object)EngineStates.MAGNETO_OFF_ES_ON)) {
                this.state = EngineStates.ENGINE_OFF;
            } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_ES_ON)) {
                this.state = EngineStates.MAGNETO_ON_STARTERS_OFF;
            } else if (this.state.equals((Object)EngineStates.RUNNING_ES_ON)) {
                this.state = EngineStates.RUNNING;
            }
        }
    }

    public void handStartEngine() {
        if (this.state.equals((Object)EngineStates.ENGINE_OFF)) {
            this.state = EngineStates.MAGNETO_OFF_HS_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
            this.state = EngineStates.MAGNETO_ON_HS_ON;
        } else if (this.state.equals((Object)EngineStates.RUNNING)) {
            this.state = EngineStates.RUNNING_HS_ON;
        } else {
            return;
        }
        this.starterLevel = (byte)(this.starterLevel + this.pack.engine.starterDuration);
        if (this.vehicle.field_70170_p.field_72995_K) {
            MTS.proxy.playSound(this.partPos, this.partName + "_cranking", 1.0f, (float)(this.RPM / (double)this.engineStartRPM));
        }
    }

    public void backfireEngine() {
        this.RPM -= this.pack.engine.maxRPM < 15000 ? 100.0 : 500.0;
        if (!this.vehicle.field_70170_p.field_72995_K) {
            MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineSignal(this, PacketPartEngineSignal.PacketEngineTypes.BACKFIRE));
        } else {
            MTS.proxy.playSound(this.partPos, this.partName + "_sputter", 0.5f, 1.0f);
            this.backfired = true;
        }
    }

    public void startEngine() {
        if (this.state.equals((Object)EngineStates.MAGNETO_ON_STARTERS_OFF)) {
            this.state = EngineStates.RUNNING;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_ES_ON)) {
            this.state = EngineStates.RUNNING_ES_ON;
        } else if (this.state.equals((Object)EngineStates.MAGNETO_ON_HS_ON)) {
            this.state = EngineStates.RUNNING;
        }
        this.starterLevel = 0;
        this.oilPressure = 60.0;
        if (!this.vehicle.field_70170_p.field_72995_K) {
            MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineSignal(this, PacketPartEngineSignal.PacketEngineTypes.START));
        } else {
            MTS.proxy.playSound(this.partPos, this.partName + "_starting", 1.0f, 1.0f);
        }
    }

    public void stallEngine(PacketPartEngineSignal.PacketEngineTypes packetType) {
        if (this.state.equals((Object)EngineStates.RUNNING)) {
            this.state = EngineStates.MAGNETO_ON_STARTERS_OFF;
        } else if (this.state.equals((Object)EngineStates.RUNNING_ES_ON)) {
            this.state = EngineStates.MAGNETO_ON_ES_ON;
        } else if (this.state.equals((Object)EngineStates.RUNNING_HS_ON)) {
            this.state = EngineStates.MAGNETO_ON_HS_ON;
        }
        if (!this.vehicle.field_70170_p.field_72995_K) {
            MTS.MTSNet.sendToAll((IMessage)new PacketPartEngineSignal(this, packetType));
        } else {
            if (!packetType.equals((Object)PacketPartEngineSignal.PacketEngineTypes.DROWN)) {
                this.internalFuel = 100;
                if (packetType.equals((Object)PacketPartEngineSignal.PacketEngineTypes.FUEL_OUT)) {
                    this.vehicle.fuel = 0.0;
                }
            }
            MTS.proxy.playSound(this.partPos, this.partName + "_starting", 1.0f, 1.0f);
        }
    }

    protected void explodeEngine() {
        if (ConfigSystem.getBooleanConfig("Explosions")) {
            this.vehicle.field_70170_p.func_72885_a((Entity)this.vehicle, this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, 1.0f, true, true);
        } else {
            this.vehicle.field_70170_p.func_72885_a((Entity)this.vehicle, this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, 0.0f, true, true);
        }
        this.vehicle.removePart(this, true);
    }

    public static int getSafeRPMFromMax(int maxRPM) {
        return maxRPM < 15000 ? maxRPM - (maxRPM - 2500) / 2 : (int)((double)maxRPM / 1.1);
    }

    protected boolean isInLiquid() {
        return this.vehicle.field_70170_p.func_180495_p(new BlockPos(this.partPos)).func_185904_a().func_76224_d();
    }

    public double getEngineRotation(float partialTicks) {
        return this.engineRotation + (this.engineRotation - this.engineRotationLast) * (double)partialTicks;
    }

    public double getDriveshaftRotation(float partialTicks) {
        return this.engineDriveshaftRotation + (this.engineDriveshaftRotation - this.engineDriveshaftRotationLast) * (double)partialTicks;
    }

    public abstract double getForceOutput();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        if (Minecraft.func_71410_x().field_71452_i != null) {
            if (this.temp > (double)115.556f) {
                Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.partPos.field_72450_a, this.partPos.field_72448_b + 0.5, this.partPos.field_72449_c, 0.0, 0.15, 0.0, new int[0]);
                if (this.temp > (double)121.111f) {
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.partPos.field_72450_a, this.partPos.field_72448_b + 0.5, this.partPos.field_72449_c, 0.0, 0.15, 0.0, new int[0]);
                }
            }
            if (this.oilLeak && this.vehicle.field_70173_aa % 20 == 0) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SFXSystem.OilDropParticleFX(this.vehicle.field_70170_p, this.partPos.field_72450_a - 0.25 * Math.sin(Math.toRadians(this.vehicle.field_70177_z)), this.partPos.field_72448_b, this.partPos.field_72449_c + 0.25 * Math.cos(Math.toRadians(this.vehicle.field_70177_z))));
            }
            if (this.fuelLeak && (this.vehicle.field_70173_aa + 5) % 20 == 0) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SFXSystem.FuelDropParticleFX(this.vehicle.field_70170_p, this.partPos.field_72448_b, this.partPos.field_72448_b, this.partPos.field_72449_c));
            }
            if (this.backfired) {
                this.backfired = false;
                for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.partPos.field_72450_a, this.partPos.field_72448_b + 0.5, this.partPos.field_72449_c, Math.random() * 0.15, 0.15, Math.random() * 0.15, new int[0]);
                }
            }
        }
    }

    public static enum EngineStates {
        ENGINE_OFF(false, false, false, false),
        MAGNETO_ON_STARTERS_OFF(true, false, false, false),
        MAGNETO_OFF_ES_ON(false, true, false, false),
        MAGNETO_OFF_HS_ON(false, false, true, false),
        MAGNETO_ON_ES_ON(true, true, false, false),
        MAGNETO_ON_HS_ON(true, false, true, false),
        RUNNING(true, false, false, true),
        RUNNING_ES_ON(true, true, false, true),
        RUNNING_HS_ON(true, false, true, true);

        public final boolean magnetoOn;
        public final boolean esOn;
        public final boolean hsOn;
        public final boolean running;

        private EngineStates(boolean magnetoOn, boolean esOn, boolean hsOn, boolean running) {
            this.magnetoOn = magnetoOn;
            this.esOn = esOn;
            this.hsOn = hsOn;
            this.running = running;
        }
    }
}

