/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.List;
import minecrafttransportsimulator.dataclasses.DamageSources;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGroundDeviceFake;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public abstract class APartGroundDevice
extends APart {
    private static final Vec3d groundDetectionOffset = new Vec3d(0.0, (double)-0.05f, 0.0);
    private static final Vec3d mirrorRotation = new Vec3d(0.0, 180.0, 0.0);
    private final PartGroundDeviceFake fakePart;
    public boolean skipAngularCalcs = false;
    public float angularPosition;
    public float angularVelocity;

    public APartGroundDevice(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        if (this.isValid() && this.getLongPartOffset() != 0.0f) {
            packPart.pos[2] = packPart.pos[2] + this.getLongPartOffset();
            this.fakePart = new PartGroundDeviceFake(this, packPart, partName, dataTag);
            vehicle.addPart(this.fakePart, false);
            packPart.pos[2] = packPart.pos[2] - this.getLongPartOffset();
        } else {
            this.fakePart = null;
        }
    }

    @Override
    public void updatePart() {
        super.updatePart();
        if (this.isOnGround()) {
            List collidedEntites;
            if (!this.skipAngularCalcs) {
                this.angularVelocity = (float)(this.vehicle.velocity / ((double)this.getHeight() * Math.PI));
            }
            if (!this.vehicle.field_70170_p.field_72995_K && this.vehicle.velocity > (double)0.2f && !(collidedEntites = this.vehicle.field_70170_p.func_72872_a(EntityLivingBase.class, this.getAABBWithOffset(Vec3d.field_186680_a).func_72314_b(0.25, 0.0, 0.25))).isEmpty()) {
                Entity attacker = null;
                for (Entity passenger : this.vehicle.func_184188_bt()) {
                    PartSeat seat = this.vehicle.getSeatForRider(passenger);
                    if (!seat.isController) continue;
                    attacker = passenger;
                    break;
                }
                for (int i = 0; i < collidedEntites.size(); ++i) {
                    if (this.vehicle.func_184196_w((Entity)collidedEntites.get(i))) continue;
                    ((EntityLivingBase)collidedEntites.get(i)).func_70097_a((DamageSource)new DamageSources.DamageSourceWheel(attacker), (float)(ConfigSystem.getDoubleConfig("WheelDamageFactor") * this.vehicle.velocity * this.vehicle.currentMass / 1000.0));
                }
            }
        } else if (!(this.vehicle instanceof EntityVehicleF_Car)) {
            if (this.vehicle.brakeOn || this.vehicle.parkingBrakeOn) {
                this.angularVelocity = 0.0f;
            } else if (this.angularVelocity > 0.0f) {
                this.angularVelocity = (float)Math.max((double)this.angularVelocity - 0.05, 0.0);
            }
        }
        this.angularPosition += this.angularVelocity;
    }

    @Override
    public void removePart() {
        super.removePart();
        if (this.fakePart != null) {
            this.vehicle.removePart(this.fakePart, false);
        }
    }

    public float getFrictionLoss() {
        BlockPos pos = new BlockPos(this.partPos.func_72441_c(0.0, -1.0, 0.0));
        return 0.6f - this.vehicle.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c().field_149765_K;
    }

    public boolean isOnGround() {
        return this.isPartCollidingWithBlocks(groundDetectionOffset);
    }

    public abstract float getMotiveFriction();

    public abstract float getLateralFriction();

    public abstract float getLongPartOffset();

    public abstract boolean canBeDrivenByEngine();
}

