/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.ArrayList;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.packets.general.PacketBulletHit;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class PartBullet
extends Particle {
    private final String bulletName;
    private final PackPartObject.PartBulletConfig bulletPackData;
    private final int playerID;
    private final EntityVehicleE_Powered vehicle;
    private final float minU;
    private final float maxU;
    private final float minV;
    private final float maxV;

    public PartBullet(World world, double x, double y, double z, double motionX, double motionY, double motionZ, String bulletName, int playerID, EntityVehicleE_Powered vehicle) {
        super(world, x, y, z);
        this.field_70547_e = 60;
        this.bulletName = bulletName;
        this.bulletPackData = PackParserSystem.getPartPack((String)this.bulletName).bullet;
        if (this.bulletPackData.type.equals("tracer")) {
            this.func_70538_b(1.0f, 0.0f, 0.0f);
        } else {
            this.func_70538_b(1.0f, 1.0f, 1.0f);
        }
        this.func_187117_a(Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a((Item)MTSRegistry.partItemMap.get(bulletName), 0));
        float vSpan = this.field_187119_C.func_94210_h() - this.field_187119_C.func_94206_g();
        float vMid = this.field_187119_C.func_94206_g() + vSpan / 2.0f;
        this.minU = this.field_187119_C.func_94209_e();
        this.maxU = this.field_187119_C.func_94212_f();
        this.minV = vMid - vSpan * this.bulletPackData.texturePercentage / 2.0f;
        this.maxV = vMid + vSpan * this.bulletPackData.texturePercentage / 2.0f;
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.func_187115_a(this.bulletPackData.diameter / 1000.0f, this.bulletPackData.diameter / 1000.0f);
        this.func_187108_a(new AxisAlignedBB(this.field_187126_f - (double)(this.field_187134_n / 2.0f), this.field_187127_g - (double)(this.field_187135_o / 2.0f), this.field_187128_h - (double)(this.field_187134_n / 2.0f), this.field_187126_f + (double)(this.field_187134_n / 2.0f), this.field_187127_g + (double)(this.field_187135_o / 2.0f), this.field_187128_h + (double)(this.field_187134_n / 2.0f)));
        this.playerID = playerID;
        this.vehicle = vehicle;
    }

    public void func_189213_a() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        if (!this.field_187133_m) {
            double velocity = Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k);
            double increments = Math.floor(velocity);
            Entity collidedEntity = null;
            BlockPos collidedBlockPos = null;
            for (double d = 0.0; d < increments; d += 0.25) {
                BlockPos pos;
                IBlockState state;
                for (Entity entity : this.field_187122_b.func_72839_b((Entity)this.vehicle, this.func_187116_l().func_72317_d(this.field_187129_i * d / increments, this.field_187130_j * d / increments, this.field_187131_k * d / increments))) {
                    if (collidedEntity == null) {
                        collidedEntity = entity;
                        continue;
                    }
                    if (entity instanceof EntityVehicleE_Powered || !(collidedEntity.func_70092_e(this.field_187126_f, this.field_187127_g, this.field_187128_h) > entity.func_70092_e(this.field_187126_f, this.field_187127_g, this.field_187128_h))) continue;
                    collidedEntity = entity;
                }
                if (collidedEntity == null && (state = this.field_187122_b.func_180495_p(pos = new BlockPos(this.field_187126_f + this.field_187129_i * d / increments, this.field_187127_g + this.field_187130_j * d / increments, this.field_187128_h + this.field_187131_k * d / increments))).func_177230_c().func_176209_a(state, true)) {
                    ArrayList collidingAABBList = new ArrayList();
                    AxisAlignedBB box = this.func_187116_l().func_72317_d(this.field_187129_i * d / increments, this.field_187130_j * d / increments, this.field_187131_k * d / increments);
                    state.func_185908_a(this.field_187122_b, pos, box, collidingAABBList, null, false);
                    if (!collidingAABBList.isEmpty()) {
                        collidedBlockPos = pos;
                    }
                }
                if (collidedEntity != null) {
                    if (this.playerID == Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
                        MTS.MTSNet.sendToServer((IMessage)new PacketBulletHit(this.field_187126_f + this.field_187129_i * d / increments, this.field_187127_g + this.field_187130_j * d / increments, this.field_187128_h + this.field_187131_k * d / increments, velocity, this.bulletName, this.playerID, collidedEntity.func_145782_y()));
                    }
                    this.func_187112_i();
                    return;
                }
                if (collidedBlockPos == null) continue;
                if (this.playerID == Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
                    MTS.MTSNet.sendToServer((IMessage)new PacketBulletHit(collidedBlockPos.func_177958_n(), collidedBlockPos.func_177956_o(), collidedBlockPos.func_177952_p(), velocity, this.bulletName, this.playerID, -1));
                }
                this.func_187112_i();
                return;
            }
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.field_187129_i *= (double)0.98f;
            this.field_187130_j *= (double)0.98f;
            this.field_187131_k *= (double)0.98f;
            this.field_187130_j -= (double)0.0245f;
            this.field_187126_f += this.field_187129_i;
            this.field_187127_g += this.field_187130_j;
            this.field_187128_h += this.field_187131_k;
            this.func_187108_a(this.func_187116_l().func_72317_d(this.field_187129_i, this.field_187130_j, this.field_187131_k));
        }
    }

    public void func_180434_a(VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float renderPosX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float renderPosY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float renderPosZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.bulletPackData.type.equals("tracer") ? 0xF000F0 : this.func_189214_a(partialTicks);
        int skyLight = brightness >> 16 & 0xFFFF;
        int blockLight = brightness & 0xFFFF;
        float realRadius = Math.max(this.bulletPackData.diameter / 1000.0f / 2.0f, 0.0625f);
        Vec3d[] texturePointCoords = new Vec3d[]{new Vec3d(0.0, (double)(-realRadius), (double)(-realRadius)), new Vec3d(0.0, (double)realRadius, (double)(-realRadius)), new Vec3d(0.0, (double)realRadius, (double)realRadius), new Vec3d(0.0, (double)(-realRadius), (double)realRadius), new Vec3d((double)(-realRadius), 0.0, (double)(-realRadius)), new Vec3d((double)realRadius, 0.0, (double)(-realRadius)), new Vec3d((double)realRadius, 0.0, (double)realRadius), new Vec3d((double)(-realRadius), 0.0, (double)realRadius)};
        Vec3d velocityVec = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k).func_72432_b();
        double yaw = -Math.toDegrees(Math.atan2(this.field_187129_i, this.field_187131_k));
        double pitch = -Math.toDegrees(Math.asin(this.field_187130_j / Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k)));
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            texturePointCoords[i] = RotationSystem.getRotatedPoint(texturePointCoords[i], (float)pitch, (float)yaw, 0.0f);
        }
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[0].field_72450_a, (double)renderPosY + texturePointCoords[0].field_72448_b, (double)renderPosZ + texturePointCoords[0].field_72449_c).func_187315_a((double)this.maxU, (double)this.maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[1].field_72450_a, (double)renderPosY + texturePointCoords[1].field_72448_b, (double)renderPosZ + texturePointCoords[1].field_72449_c).func_187315_a((double)this.maxU, (double)this.minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[2].field_72450_a, (double)renderPosY + texturePointCoords[2].field_72448_b, (double)renderPosZ + texturePointCoords[2].field_72449_c).func_187315_a((double)this.minU, (double)this.minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[3].field_72450_a, (double)renderPosY + texturePointCoords[3].field_72448_b, (double)renderPosZ + texturePointCoords[3].field_72449_c).func_187315_a((double)this.minU, (double)this.maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[4].field_72450_a, (double)renderPosY + texturePointCoords[4].field_72448_b, (double)renderPosZ + texturePointCoords[4].field_72449_c).func_187315_a((double)this.maxU, (double)this.maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[5].field_72450_a, (double)renderPosY + texturePointCoords[5].field_72448_b, (double)renderPosZ + texturePointCoords[5].field_72449_c).func_187315_a((double)this.maxU, (double)this.minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[6].field_72450_a, (double)renderPosY + texturePointCoords[6].field_72448_b, (double)renderPosZ + texturePointCoords[6].field_72449_c).func_187315_a((double)this.minU, (double)this.minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
        worldRendererIn.func_181662_b((double)renderPosX + texturePointCoords[7].field_72450_a, (double)renderPosY + texturePointCoords[7].field_72448_b, (double)renderPosZ + texturePointCoords[7].field_72449_c).func_187315_a((double)this.minU, (double)this.maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLight, blockLight).func_181675_d();
    }

    public int func_70537_b() {
        return 1;
    }
}

