/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import java.util.List;
import minecrafttransportsimulator.dataclasses.DamageSources;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

public class PartEngineJet
extends APartEngine {
    private final EntityVehicleF_Plane plane;

    public PartEngineJet(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.plane = (EntityVehicleF_Plane)vehicle;
    }

    @Override
    public void updatePart() {
        super.updatePart();
        if (this.state.running) {
            double engineTargetRPM = (double)((float)this.plane.throttle / 100.0f) * ((double)this.pack.engine.maxRPM - (double)this.engineStartRPM * 1.25 - this.hours * 10.0) + (double)this.engineStartRPM * 1.25;
            double engineRPMDifference = engineTargetRPM - this.RPM;
            this.RPM += (double)this.pack.engine.fuelConsumption * engineRPMDifference / (double)(10.0f + this.pack.engine.gearRatios[0]) / this.vehicle.airDensity;
        } else if (!this.state.esOn) {
            this.RPM = Math.max(this.RPM + (this.plane.velocity - 6.35 * this.RPM / 60.0 / 20.0) * 15.0 - 10.0, 0.0);
        }
        if (!this.vehicle.field_70170_p.field_72995_K && this.RPM >= 5000.0) {
            Entity attacker;
            List collidedEntites = this.vehicle.field_70170_p.func_72872_a(EntityLivingBase.class, this.getAABBWithOffset(this.vehicle.headingVec).func_72314_b(-0.25, -0.25, -0.25));
            if (!collidedEntites.isEmpty()) {
                attacker = null;
                for (Entity passenger : this.vehicle.func_184188_bt()) {
                    if (!this.vehicle.getSeatForRider((Entity)passenger).isController) continue;
                    attacker = passenger;
                    break;
                }
                for (int i = 0; i < collidedEntites.size(); ++i) {
                    if (this.vehicle.equals(((EntityLivingBase)collidedEntites.get(i)).func_184187_bx())) continue;
                    ((EntityLivingBase)collidedEntites.get(i)).func_70097_a((DamageSource)new DamageSources.DamageSourceJet(attacker, true), (float)(ConfigSystem.getDoubleConfig("JetDamageFactor") * this.RPM / 1000.0));
                }
            }
            if (!(collidedEntites = this.vehicle.field_70170_p.func_72872_a(EntityLivingBase.class, this.getAABBWithOffset(this.vehicle.headingVec.func_186678_a(-1.0)).func_72314_b(0.25, 0.25, 0.25))).isEmpty()) {
                attacker = null;
                for (Entity passenger : this.vehicle.func_184188_bt()) {
                    if (!this.vehicle.getSeatForRider((Entity)passenger).isController) continue;
                    attacker = passenger;
                    break;
                }
                for (int i = 0; i < collidedEntites.size(); ++i) {
                    if (this.vehicle.equals(((EntityLivingBase)collidedEntites.get(i)).func_184187_bx())) continue;
                    ((EntityLivingBase)collidedEntites.get(i)).func_70097_a((DamageSource)new DamageSources.DamageSourceJet(attacker, false), (float)(ConfigSystem.getDoubleConfig("JetDamageFactor") * this.RPM / 2000.0));
                    ((EntityLivingBase)collidedEntites.get(i)).func_70015_d(5);
                }
            }
        }
        this.engineRotationLast = this.engineRotation;
        this.engineRotation += this.RPM * 1200.0 / 360.0;
        this.engineDriveshaftRotationLast = this.engineDriveshaftRotation;
        this.engineDriveshaftRotation += this.RPM * 1200.0 / 360.0;
    }

    @Override
    public double getForceOutput() {
        if (this.state.running) {
            double safeRPMFactor = this.RPM / (double)PartEngineJet.getSafeRPMFromMax(this.pack.engine.maxRPM);
            double coreContribution = Math.max(10.0 * this.vehicle.airDensity * (double)this.pack.engine.fuelConsumption * safeRPMFactor - (double)this.pack.engine.gearRatios[0], 0.0);
            double fanVelocityFactor = (6.35 * this.RPM / 60.0 / 20.0 - this.plane.velocity) / 200.0;
            double fanContribution = 10.0 * this.vehicle.airDensity * safeRPMFactor * fanVelocityFactor * (double)this.pack.engine.gearRatios[0];
            return this.plane.reverseThrust ? -(coreContribution + fanContribution) : coreContribution + fanContribution;
        }
        return 0.0;
    }
}

