/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.parts.PacketPartGroundDeviceWheelFlat;
import minecrafttransportsimulator.systems.SFXSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APartGroundDevice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PartGroundDeviceWheel
extends APartGroundDevice
implements SFXSystem.FXPart {
    private ResourceLocation flatModelLocation;
    private boolean isFlat;
    private boolean contactThisTick = false;
    private int ticksCalcsSkipped = 0;
    private float prevAngularVelocity;

    public PartGroundDeviceWheel(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.isFlat = dataTag.func_74767_n("isFlat");
    }

    @Override
    public void attackPart(DamageSource source, float damage) {
        if (!this.isFlat && (source.func_94541_c() || Math.random() < 0.1) && !this.vehicle.field_70170_p.field_72995_K) {
            this.setFlat();
            Vec3d explosionPosition = this.partPos;
            this.vehicle.field_70170_p.func_72885_a((Entity)this.vehicle, explosionPosition.field_72450_a, explosionPosition.field_72448_b, explosionPosition.field_72449_c, 0.25f, false, false);
            MTS.MTSNet.sendToAll((IMessage)new PacketPartGroundDeviceWheelFlat(this));
        }
    }

    @Override
    public void updatePart() {
        this.prevAngularVelocity = this.angularVelocity;
        super.updatePart();
        if (this.isOnGround()) {
            BlockPos blockBelow;
            if ((double)this.prevAngularVelocity / (this.vehicle.velocity / ((double)this.getHeight() * Math.PI)) < 0.25 && this.vehicle.velocity > 0.3 && (double)this.vehicle.field_70170_p.func_180495_p(blockBelow = new BlockPos(this.partPos).func_177977_b()).func_185887_b(this.vehicle.field_70170_p, blockBelow) >= 1.25) {
                this.contactThisTick = true;
            }
            if (!this.skipAngularCalcs) {
                if (this.ticksCalcsSkipped > 0 && !this.isFlat) {
                    --this.ticksCalcsSkipped;
                }
            } else if (!this.isFlat) {
                ++this.ticksCalcsSkipped;
                if (Math.random() * 50000.0 < (double)this.ticksCalcsSkipped && !this.vehicle.field_70170_p.field_72995_K) {
                    this.setFlat();
                    Vec3d explosionPosition = this.partPos;
                    this.vehicle.field_70170_p.func_72885_a((Entity)this.vehicle, explosionPosition.field_72450_a, explosionPosition.field_72448_b, explosionPosition.field_72449_c, 0.25f, false, false);
                    MTS.MTSNet.sendToAll((IMessage)new PacketPartGroundDeviceWheelFlat(this));
                }
            }
        }
    }

    @Override
    public NBTTagCompound getPartNBTTag() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74757_a("isFlat", this.isFlat);
        return dataTag;
    }

    @Override
    public float getWidth() {
        return this.pack.wheel.diameter / 2.0f;
    }

    @Override
    public float getHeight() {
        return this.isFlat ? this.pack.wheel.diameter / 2.0f : this.pack.wheel.diameter;
    }

    @Override
    public Item getItemForPart() {
        return this.isFlat ? null : super.getItemForPart();
    }

    @Override
    public ResourceLocation getModelLocation() {
        if (this.isFlat) {
            if (this.flatModelLocation == null) {
                this.flatModelLocation = this.pack.general.modelName != null ? new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/parts/" + this.pack.general.modelName + "_flat.obj") : new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/parts/" + this.partName.substring(this.partName.indexOf(58) + 1) + "_flat.obj");
            }
            return this.flatModelLocation;
        }
        return super.getModelLocation();
    }

    @Override
    public Vec3d getActionRotation(float partialTicks) {
        return new Vec3d(this.vehicle.speedFactor * (double)(this.angularPosition + this.angularVelocity * partialTicks) * 360.0, 0.0, 0.0);
    }

    @Override
    public float getMotiveFriction() {
        return !this.isFlat ? this.pack.wheel.motiveFriction : this.pack.wheel.motiveFriction / 10.0f;
    }

    @Override
    public float getLateralFriction() {
        return !this.isFlat ? this.pack.wheel.lateralFriction : this.pack.wheel.lateralFriction / 10.0f;
    }

    @Override
    public float getLongPartOffset() {
        return 0.0f;
    }

    @Override
    public boolean canBeDrivenByEngine() {
        return true;
    }

    public void setFlat() {
        this.isFlat = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        int i;
        if (this.contactThisTick) {
            for (i = 0; i < 4; i = (int)((byte)(i + 1))) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SFXSystem.WhiteSmokeFX(this.vehicle.field_70170_p, this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, Math.random() * 0.1 - 0.05, 0.15, Math.random() * 0.1 - 0.05));
            }
            MTS.proxy.playSound(this.partPos, "mts:wheel_striking", 1.0f, 1.0f);
            this.contactThisTick = false;
        }
        if (this.skipAngularCalcs && this.isOnGround()) {
            for (i = 0; i < 4; i = (int)((byte)(i + 1))) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new SFXSystem.WhiteSmokeFX(this.vehicle.field_70170_p, this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, Math.random() * 0.1 - 0.05, 0.15, Math.random() * 0.1 - 0.05));
            }
        }
    }
}

