/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1122.BuilderBlockFakeLight;
import mcinterface1122.BuilderItem;
import mcinterface1122.BuilderTileEntity;
import mcinterface1122.BuilderTileEntityFluidTank;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.IFluidTankProvider;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.IBlockTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityTickable;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
class BuilderBlock
extends Block {
    static final Map<ABlockBase, BuilderBlock> blockWrapperMap = new HashMap<ABlockBase, BuilderBlock>();
    static final Map<String, IBlockTileEntity<?>> tileEntityMap = new HashMap();
    final ABlockBase block;
    private static final Map<BlockPos, List<ItemStack>> dropsAtPositions = new HashMap<BlockPos, List<ItemStack>>();
    protected static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    BuilderBlock(ABlockBase block) {
        super(Material.field_151576_e);
        this.block = block;
        this.field_149787_q = false;
        this.func_149711_c(block.hardness);
        this.func_149752_b(block.blastResistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.block instanceof IBlockTileEntity;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        Class teClass = ((IBlockTileEntity)((Object)this.block)).getTileEntityClass();
        if (IFluidTankProvider.class.isAssignableFrom(teClass)) {
            return BuilderBlock.getTileEntityTankWrapper(this.block);
        }
        return BuilderBlock.getTileEntityGenericWrapper(this.block);
    }

    private static <TileEntityType extends ATileEntityBase<?>> BuilderTileEntity<TileEntityType> getTileEntityGenericWrapper(ABlockBase block) {
        Class teClass = ((IBlockTileEntity)((Object)block)).getTileEntityClass();
        if (ITileEntityTickable.class.isAssignableFrom(teClass)) {
            return new BuilderTileEntity.Tickable();
        }
        return new BuilderTileEntity();
    }

    private static <TileEntityType extends ATileEntityBase<?>> BuilderTileEntity<TileEntityType> getTileEntityTankWrapper(ABlockBase block) {
        return new BuilderTileEntityFluidTank();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.block.onClicked(WrapperWorld.getWrapperFor(world), new Point3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), ABlockBase.Axis.valueOf(side.name()), WrapperWorld.getWrapperFor(world).getWrapperFor(player));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        AItemPack item;
        TileEntity tile;
        if (this.block instanceof IBlockTileEntity && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null && (item = ((ATileEntityBase)((BuilderTileEntity)tile).tileEntity).item) != null) {
            ItemStack stack = new ItemStack((Item)BuilderItem.itemWrapperMap.get(item));
            WrapperNBT data = new WrapperNBT(new NBTTagCompound());
            ((ATileEntityBase)((BuilderTileEntity)tile).tileEntity).save(data);
            stack.func_77982_d(data.tag);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.block instanceof IBlockTileEntity) {
            if (dropsAtPositions.containsKey(pos)) {
                drops.addAll((Collection)dropsAtPositions.get(pos));
                dropsAtPositions.remove(pos);
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (this.block instanceof IBlockTileEntity && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (AItemPack item : ((ATileEntityBase)((BuilderTileEntity)tile).tileEntity).getDrops()) {
                drops.add(new ItemStack((Item)BuilderItem.itemWrapperMap.get(item)));
            }
            dropsAtPositions.put(pos, drops);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        ArrayList<BoundingBox> collisionBoxes = new ArrayList<BoundingBox>();
        this.block.addCollisionBoxes(WrapperWorld.getWrapperFor(world), new Point3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), collisionBoxes);
        for (BoundingBox box : collisionBoxes) {
            AxisAlignedBB mcBox = new AxisAlignedBB((double)pos.func_177958_n() + 0.5 + box.globalCenter.x - box.widthRadius, (double)pos.func_177956_o() + 0.5 + box.globalCenter.y - box.heightRadius, (double)pos.func_177952_p() + 0.5 + box.globalCenter.z - box.depthRadius, (double)pos.func_177958_n() + 0.5 + box.globalCenter.x + box.widthRadius, (double)pos.func_177956_o() + 0.5 + box.globalCenter.y + box.heightRadius, (double)pos.func_177952_p() + 0.5 + box.globalCenter.z + box.depthRadius);
            if (!mcBox.func_72326_a(entityBox)) continue;
            collidingBoxes.add(mcBox);
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.block instanceof IBlockTileEntity ? EnumBlockRenderType.ENTITYBLOCK_ANIMATED : EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        BuilderTileEntity builder;
        if (this.block instanceof IBlockTileEntity && (builder = (BuilderTileEntity)world.func_175625_s(pos)) != null && builder.tileEntity != null) {
            return (int)(((ATileEntityBase)builder.tileEntity).lightLevel * 15.0f);
        }
        return super.getLightValue(state, world, pos);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GameRegistry.registerTileEntity(BuilderTileEntity.class, (ResourceLocation)new ResourceLocation("mts", BuilderTileEntity.class.getSimpleName()));
        GameRegistry.registerTileEntity(BuilderTileEntity.Tickable.class, (ResourceLocation)new ResourceLocation("mts", BuilderTileEntity.class.getSimpleName() + BuilderTileEntity.Tickable.class.getSimpleName()));
        GameRegistry.registerTileEntity(BuilderTileEntityFluidTank.class, (ResourceLocation)new ResourceLocation("mts", BuilderTileEntityFluidTank.class.getSimpleName()));
        ArrayList<ABlockBase> blocksRegistred = new ArrayList<ABlockBase>();
        for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
            ABlockBase itemBlockBlock;
            if (!(packItem instanceof IItemBlock) || blocksRegistred.contains(itemBlockBlock = ((IItemBlock)((Object)packItem)).getBlock())) continue;
            BuilderBlock wrapper = new BuilderBlock(itemBlockBlock);
            String name = itemBlockBlock.getClass().getSimpleName();
            name = "mts:" + name.substring("Block".length());
            event.getRegistry().register((IForgeRegistryEntry)((Block)wrapper.setRegistryName(name)).func_149663_c(name));
            blockWrapperMap.put(itemBlockBlock, wrapper);
            blocksRegistred.add(itemBlockBlock);
            if (!(itemBlockBlock instanceof IBlockTileEntity)) continue;
            tileEntityMap.put(((IBlockTileEntity)((Object)itemBlockBlock)).getTileEntityClass().getSimpleName(), (IBlockTileEntity)((Object)itemBlockBlock));
        }
        event.getRegistry().register(BuilderBlockFakeLight.instance.setRegistryName("mts:fake_light"));
    }
}

