/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1122.BuilderBlockFakeLight;
import mcinterface1122.BuilderItem;
import mcinterface1122.MasterInterface;
import mcinterface1122.PacketEntityCSHandshake;
import mcinterface1122.WrapperAABBCollective;
import mcinterface1122.WrapperEntity;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.packets.instances.PacketVehicleInteract;
import minecrafttransportsimulator.sound.IRadioProvider;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class BuilderEntity
extends Entity {
    public static Map<AEntityBase, BuilderEntity> createdClientBuilders = new HashMap<AEntityBase, BuilderEntity>();
    public static Map<AEntityBase, BuilderEntity> createdServerBuilders = new HashMap<AEntityBase, BuilderEntity>();
    static final Map<String, IItemEntityProvider<?>> entityMap = new HashMap();
    AEntityBase entity;
    private boolean requestDataFromServer;
    private static Point3d lastExplosionPosition;
    private BlockPos fakeLightPosition;
    private WrapperAABBCollective interactionBoxes;
    private WrapperAABBCollective collisionBoxes;

    public BuilderEntity(World world) {
        super(world);
    }

    public void func_70030_z() {
        if (this.entity != null) {
            this.entity.update();
            double furthestWidthRadius = 0.0;
            double furthestHeightRadius = 0.0;
            for (BoundingBox box : this.entity.interactionBoxes) {
                furthestWidthRadius = (float)Math.max(furthestWidthRadius, box.localCenter.x + box.widthRadius);
                furthestHeightRadius = (float)Math.max(furthestHeightRadius, box.localCenter.y + box.heightRadius);
                furthestWidthRadius = (float)Math.max(furthestWidthRadius, box.localCenter.z + box.depthRadius);
            }
            this.func_70105_a((float)furthestWidthRadius * 2.0f, (float)furthestHeightRadius * 2.0f);
            this.interactionBoxes = new WrapperAABBCollective(this, this.entity.interactionBoxes);
            this.collisionBoxes = new WrapperAABBCollective(this, this.entity.collisionBoxes);
            if (World.MAX_ENTITY_RADIUS < furthestWidthRadius || World.MAX_ENTITY_RADIUS < furthestHeightRadius) {
                World.MAX_ENTITY_RADIUS = Math.max(furthestWidthRadius, furthestHeightRadius);
            }
            this.func_70107_b(this.entity.position.x, this.entity.position.y, this.entity.position.z);
            this.field_70177_z = (float)(-this.entity.angles.y);
            this.field_70125_A = (float)this.entity.angles.x;
            if (!this.field_70170_p.field_72995_K) {
                Iterator<IWrapperEntity> riderIterator = this.entity.locationRiderMap.inverse().keySet().iterator();
                while (riderIterator.hasNext()) {
                    WrapperEntity rider = (WrapperEntity)riderIterator.next();
                    if (this.equals(rider.entity.func_184187_bx())) continue;
                    this.entity.removeRider(rider, riderIterator);
                }
            }
            if (this.field_70170_p.field_72995_K) {
                if (this.entity.isLitUp()) {
                    BlockPos newPos = this.func_180425_c();
                    if (!newPos.equals((Object)this.fakeLightPosition)) {
                        if (this.fakeLightPosition != null) {
                            this.field_70170_p.func_175698_g(this.fakeLightPosition);
                            this.field_70170_p.func_175664_x(this.fakeLightPosition);
                            this.fakeLightPosition = null;
                        }
                        if (this.field_70170_p.func_175623_d(newPos)) {
                            this.field_70170_p.func_175656_a(newPos, BuilderBlockFakeLight.instance.func_176223_P());
                            this.field_70170_p.func_175664_x(newPos);
                            this.fakeLightPosition = newPos;
                        }
                    }
                } else if (this.fakeLightPosition != null) {
                    this.field_70170_p.func_175698_g(this.fakeLightPosition);
                    this.field_70170_p.func_175664_x(this.fakeLightPosition);
                    this.fakeLightPosition = null;
                }
            }
            if (!this.entity.isValid || this.entity.position.y < -5.0) {
                this.func_70106_y();
            }
        } else if (this.requestDataFromServer) {
            MasterInterface.networkInterface.sendToServer(new PacketEntityCSHandshake(this.func_145782_y(), null));
            this.requestDataFromServer = false;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.fakeLightPosition != null) {
            this.field_70170_p.func_175698_g(this.fakeLightPosition);
        }
        if (this.entity != null) {
            this.entity.isValid = false;
            if (this.field_70170_p.field_72995_K) {
                AEntityBase.createdClientEntities.remove(this.entity);
            } else {
                AEntityBase.createdServerEntities.remove(this.entity);
            }
            if (this.entity instanceof IRadioProvider && this.field_70170_p.field_72995_K) {
                ((IRadioProvider)((Object)this.entity)).getRadio().stop();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.entity != null) {
            WrapperPlayer playerSource;
            Entity attacker = source.func_76364_f();
            Entity trueSource = source.func_76346_g();
            WrapperPlayer wrapperPlayer = playerSource = trueSource instanceof EntityPlayer ? WrapperWorld.getWrapperFor(trueSource.field_70170_p).getWrapperFor((EntityPlayer)trueSource) : null;
            if (lastExplosionPosition != null && source.func_94541_c()) {
                BoundingBox explosiveBounds = new BoundingBox(lastExplosionPosition, amount, amount, amount);
                for (BoundingBox box : this.entity.interactionBoxes) {
                    if (!box.intersects(explosiveBounds)) continue;
                    this.entity.attack(new Damage(source.field_76373_n, amount, box, playerSource).setExplosive());
                }
                lastExplosionPosition = null;
            } else if (attacker != null) {
                Damage damage = null;
                Point3d attackerPosition = new Point3d(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v);
                for (BoundingBox box : this.entity.interactionBoxes) {
                    if (!box.isPointInside(attackerPosition)) continue;
                    damage = new Damage(source.field_76373_n, amount, box, playerSource);
                    break;
                }
                if (damage == null) {
                    attackerPosition.add(attacker.field_70159_w, attacker.field_70181_x, attacker.field_70179_y);
                    for (BoundingBox box : this.entity.interactionBoxes) {
                        if (!box.isPointInside(attackerPosition)) continue;
                        damage = new Damage(source.field_76373_n, amount, box, playerSource);
                        break;
                    }
                }
                if (damage != null) {
                    this.entity.attack(damage);
                }
            }
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.entity != null) {
            Iterator<IWrapperEntity> iterator = this.entity.locationRiderMap.inverse().keySet().iterator();
            while (iterator.hasNext()) {
                IWrapperEntity rider = (IWrapperEntity)iterator.next();
                if (!rider.equals(passenger)) continue;
                this.entity.updateRider(rider, iterator);
                return;
            }
            this.entity.addRider(passenger instanceof EntityPlayer ? WrapperWorld.getWrapperFor(this.field_70170_p).getWrapperFor((EntityPlayer)passenger) : WrapperWorld.getWrapperFor(this.field_70170_p).getWrapperFor(passenger), null);
        }
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.interactionBoxes != null ? this.interactionBoxes : super.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.collisionBoxes != null ? this.collisionBoxes : super.func_70046_E();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.entity instanceof EntityVehicleF_Physics) {
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)this.entity;
            for (BoundingBox box : vehicle.interactionBoxes) {
                if (!box.isPointInside(new Point3d(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c))) continue;
                APart part = vehicle.getPartAtLocation(box.localCenter);
                if (part == null) {
                    for (Map.Entry partCollisionEntry : vehicle.partCollisionBoxes.entrySet()) {
                        for (BoundingBox collisionBox : (List)partCollisionEntry.getValue()) {
                            if (!collisionBox.equals(box)) continue;
                            part = (APart)partCollisionEntry.getKey();
                            break;
                        }
                        if (part == null) continue;
                        break;
                    }
                }
                if (part == null) continue;
                ItemStack stack = new ItemStack((Item)BuilderItem.itemWrapperMap.get(part.getItem()));
                stack.func_77982_d(((WrapperNBT)part.getData()).tag);
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        this.requestDataFromServer = this.field_70170_p.field_72995_K;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void func_180426_a(double posX, double posY, double posZ, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BuilderEntity.func_184227_b((double)100.0);
        this.field_70158_ak = true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        if (this.entity == null && tag.func_74764_b("entityid")) {
            this.entity = entityMap.get(tag.func_74779_i("entityid")).createEntity(WrapperWorld.getWrapperFor(this.field_70170_p), new WrapperNBT(tag));
            if (!this.field_70128_L) {
                if (this.field_70170_p.field_72995_K) {
                    createdClientBuilders.put(this.entity, this);
                } else {
                    createdServerBuilders.put(this.entity, this);
                }
            }
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        this.entity.save(new WrapperNBT(tag));
        tag.func_74778_a("entityid", this.entity.getClass().getSimpleName());
        return tag;
    }

    @SubscribeEvent
    public static void on(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K) {
            lastExplosionPosition = new Point3d(event.getExplosion().getPosition().field_72450_a, event.getExplosion().getPosition().field_72448_b, event.getExplosion().getPosition().field_72449_c);
        }
    }

    @SubscribeEvent
    public static void on(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof BuilderEntity && ((BuilderEntity)event.getTarget()).entity instanceof EntityVehicleF_Physics) {
            BuilderEntity builder = (BuilderEntity)event.getTarget();
            if (event.getEntityPlayer().field_70170_p.field_72995_K && event.getHand().equals((Object)EnumHand.MAIN_HAND) && builder.interactionBoxes != null) {
                BoundingBox boxClicked = builder.interactionBoxes.lastBoxRayTraced;
                if (boxClicked != null) {
                    MasterInterface.networkInterface.sendToServer(new PacketVehicleInteract((EntityVehicleF_Physics)builder.entity, boxClicked.localCenter, true));
                } else {
                    MasterInterface.logger.error("ERROR: A vehicle was clicked (interacted) without doing RayTracing first, or AABBs in vehicle are corrupt!");
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void on(AttackEntityEvent event) {
        if (event.getTarget() instanceof BuilderEntity && ((BuilderEntity)event.getTarget()).entity instanceof EntityVehicleF_Physics) {
            BuilderEntity builder = (BuilderEntity)event.getTarget();
            if (event.getEntityPlayer().field_70170_p.field_72995_K) {
                BoundingBox boxClicked = builder.interactionBoxes.lastBoxRayTraced;
                if (boxClicked != null) {
                    MasterInterface.networkInterface.sendToServer(new PacketVehicleInteract((EntityVehicleF_Physics)builder.entity, boxClicked.localCenter, false));
                } else {
                    MasterInterface.logger.error("ERROR: A vehicle was clicked (attacked) without doing RayTracing first, or AABBs in vehicle are corrupt!");
                }
                event.getEntityPlayer().func_184185_a(SoundEvents.field_187724_dU, 1.0f, 1.0f);
            }
            event.setCanceled(true);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (AItemPack<?> packItem : PackParserSystem.getAllPackItems()) {
            if (!(packItem instanceof IItemEntityProvider)) continue;
            entityMap.put(((IItemEntityProvider)((Object)packItem)).getEntityClass().getSimpleName(), (IItemEntityProvider)((Object)packItem));
        }
        int entityNumber = 0;
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(BuilderEntity.class).id(new ResourceLocation("mts", "mts_entity"), entityNumber++).name("mts_entity").tracker(512, 5, false).build());
    }
}

