/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcinterface1122.MasterInterface;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IInterfaceAudio;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.sound.ISoundProvider;
import minecrafttransportsimulator.sound.IStreamDecoder;
import minecrafttransportsimulator.sound.OGGDecoderOutput;
import minecrafttransportsimulator.sound.Radio;
import minecrafttransportsimulator.sound.RadioStation;
import minecrafttransportsimulator.sound.SoundInstance;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

@Mod.EventBusSubscriber(value={Side.CLIENT})
class InterfaceAudio
implements IInterfaceAudio {
    private static boolean isSystemPaused;
    private static final Map<String, Integer> dataSourceBuffers;
    private static final List<SoundInstance> playingSounds;
    private static final List<RadioStation> playingStations;
    private static volatile List<SoundInstance> queuedSounds;
    private static byte sourceGetFailures;

    InterfaceAudio() {
    }

    @Override
    public void update() {
        boolean bl;
        if (!AL.isCreated()) {
            return;
        }
        if (MasterInterface.gameInterface.isGamePaused()) {
            if (!isSystemPaused) {
                for (SoundInstance soundInstance : playingSounds) {
                    AL10.alSourcePause((int)soundInstance.sourceIndex);
                }
                isSystemPaused = true;
            }
            return;
        }
        if (isSystemPaused) {
            for (SoundInstance soundInstance : playingSounds) {
                AL10.alSourcePlay((int)soundInstance.sourceIndex);
            }
            isSystemPaused = false;
        }
        if (MasterInterface.gameInterface.getClientWorld() == null) {
            Iterator<SoundInstance> iterator = queuedSounds.iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
            for (SoundInstance playingSound : playingSounds) {
                playingSound.stop();
            }
        }
        if (!queuedSounds.isEmpty()) {
            for (SoundInstance soundInstance : queuedSounds) {
                AL10.alSourcePlay((int)soundInstance.sourceIndex);
                playingSounds.add(soundInstance);
            }
            queuedSounds.clear();
        }
        IWrapperPlayer player = MasterInterface.gameInterface.getClientPlayer();
        boolean bl2 = false;
        Iterator<SoundInstance> soundIterator = playingSounds.iterator();
        while (soundIterator.hasNext()) {
            int boundBuffers;
            SoundInstance sound = soundIterator.next();
            AL10.alGetError();
            int state = AL10.alGetSourcei((int)sound.sourceIndex, (int)4112);
            if (AL10.alGetError() == 40961) {
                bl = true;
                break;
            }
            if (state == 4114) {
                sound.provider.updateProviderSound(sound);
                if (sound.stopSound) {
                    AL10.alSourceStop((int)sound.sourceIndex);
                    continue;
                }
                FloatBuffer providerPosbuffer = sound.provider.getProviderPosition();
                AL10.alSource((int)sound.sourceIndex, (int)4100, (FloatBuffer)providerPosbuffer);
                if (sound.shouldBeDampened()) {
                    AL10.alSourcef((int)sound.sourceIndex, (int)4106, (float)(sound.volume / 2.0f));
                } else {
                    AL10.alSourcef((int)sound.sourceIndex, (int)4106, (float)sound.volume);
                }
                if (sound.looping && !sound.provider.equals(player.getEntityRiding())) {
                    double finalDelta;
                    Point3d providerVelocity = sound.provider.getProviderVelocity();
                    Point3d playerVelocity = player.getVelocity();
                    playerVelocity.y = 0.0;
                    double initalDelta = player.getPosition().add(-providerPosbuffer.get(0), -providerPosbuffer.get(1), -providerPosbuffer.get(2)).length();
                    float dopplerFactor = (float)(initalDelta > (finalDelta = player.getPosition().add(playerVelocity).add(-providerPosbuffer.get(0), -providerPosbuffer.get(1), -providerPosbuffer.get(2)).add(-providerVelocity.x, 0.0, -providerVelocity.z).length()) ? 1.0 + (initalDelta - finalDelta) / initalDelta : 1.0 - (finalDelta - initalDelta) / finalDelta);
                    AL10.alSourcef((int)sound.sourceIndex, (int)4099, (float)(sound.pitch * dopplerFactor));
                } else {
                    AL10.alSourcef((int)sound.sourceIndex, (int)4099, (float)sound.pitch);
                }
                AL10.alSourcef((int)sound.sourceIndex, (int)4129, (float)(1.0f / (0.25f + 3.0f * sound.pitch)));
                continue;
            }
            if (sound.radio == null) {
                AL10.alSourcei((int)sound.sourceIndex, (int)4105, (int)0);
                sound.stop();
            } else if (sound.stopSound && (boundBuffers = AL10.alGetSourcei((int)sound.sourceIndex, (int)4118)) > 0) {
                IntBuffer buffers = BufferUtils.createIntBuffer((int)boundBuffers);
                AL10.alSourceUnqueueBuffers((int)sound.sourceIndex, (IntBuffer)buffers);
            }
            if (!sound.stopSound) continue;
            IntBuffer sourceBuffer = (IntBuffer)BufferUtils.createIntBuffer((int)1).put(sound.sourceIndex).flip();
            AL10.alDeleteSources((IntBuffer)sourceBuffer);
            soundIterator.remove();
        }
        for (RadioStation station : playingStations) {
            station.update();
        }
        if (bl) {
            dataSourceBuffers.clear();
            HashSet<ISoundProvider> providers = new HashSet<ISoundProvider>();
            for (SoundInstance sound : playingSounds) {
                providers.add(sound.provider);
            }
            playingSounds.clear();
            sourceGetFailures = 0;
            for (ISoundProvider provider : providers) {
                provider.startSounds();
            }
        }
    }

    @Override
    public void playQuickSound(SoundInstance sound) {
        Integer dataBufferPointer;
        if (AL.isCreated() && sourceGetFailures < 10 && (dataBufferPointer = InterfaceAudio.loadOGGJarSound(sound.soundName)) != null) {
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGetError();
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() != 0) {
                sourceGetFailures = (byte)(sourceGetFailures + 1);
                AL10.alDeleteBuffers((int)dataBufferPointer);
                MasterInterface.gameInterface.getClientPlayer().displayChatMessage("IMMERSIVE VEHICLES ERROR: Tried to play a sound, but was told no sound slots were available.  Some mod is taking up all the sound slots.  Probabaly Immersive Railroading.  Sound will not play.");
                return;
            }
            sound.sourceIndex = sourceBuffer.get(0);
            AL10.alGetError();
            AL10.alSourcei((int)sound.sourceIndex, (int)4103, (int)(sound.looping ? 1 : 0));
            AL10.alSource((int)sound.sourceIndex, (int)4100, (FloatBuffer)sound.provider.getProviderPosition());
            AL10.alSourcei((int)sound.sourceIndex, (int)4105, (int)dataBufferPointer);
            queuedSounds.add(sound);
        }
    }

    @Override
    public void addRadioStation(RadioStation station) {
        playingStations.add(station);
    }

    @Override
    public void addRadioSound(SoundInstance sound, List<Integer> buffers) {
        if (AL.isCreated() && sourceGetFailures < 10) {
            IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGetError();
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() != 0) {
                sourceGetFailures = (byte)(sourceGetFailures + 1);
                MasterInterface.gameInterface.getClientPlayer().displayChatMessage("IMMERSIVE VEHICLES ERROR: Tried to play a sound, but was told no sound slots were available.  Some mod is taking up all the slots.  Probabaly Immersive Railroading.  Sound will not play.");
                return;
            }
            sound.sourceIndex = sourceBuffer.get(0);
            for (int bufferIndex : buffers) {
                this.bindBuffer(sound, bufferIndex);
            }
            AL10.alSourcePlay((int)sound.sourceIndex);
            playingSounds.add(sound);
        }
    }

    @Override
    public int createBuffer(ByteBuffer buffer, IStreamDecoder decoder) {
        if (decoder.isStereo()) {
            buffer = InterfaceAudio.stereoToMono(buffer);
        }
        IntBuffer newDataBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)newDataBuffer);
        AL10.alBufferData((int)newDataBuffer.get(0), (int)4353, (ByteBuffer)buffer, (int)decoder.getSampleRate());
        return newDataBuffer.get(0);
    }

    @Override
    public void deleteBuffer(int bufferIndex) {
        AL10.alDeleteBuffers((int)bufferIndex);
    }

    @Override
    public void bindBuffer(SoundInstance sound, int bufferIndex) {
        AL10.alSourceQueueBuffers((int)sound.sourceIndex, (int)bufferIndex);
    }

    @Override
    public int getFreeStationBuffer(Set<Radio> playingRadios) {
        boolean freeBuffer = true;
        Radio badRadio = null;
        AL10.alGetError();
        for (Radio radio : playingRadios) {
            SoundInstance sound = radio.getPlayingSound();
            if (AL10.alGetSourcei((int)sound.sourceIndex, (int)4118) == 0) {
                freeBuffer = false;
                break;
            }
            if (AL10.alGetError() != 40961) continue;
            badRadio = radio;
        }
        if (badRadio != null) {
            badRadio.stop();
            return 0;
        }
        if (freeBuffer) {
            int freeBufferIndex = 0;
            IntBuffer oldDataBuffer = BufferUtils.createIntBuffer((int)1);
            for (Radio radio : playingRadios) {
                SoundInstance sound = radio.getPlayingSound();
                AL10.alSourceUnqueueBuffers((int)sound.sourceIndex, (IntBuffer)oldDataBuffer);
                if (freeBufferIndex == 0) {
                    freeBufferIndex = oldDataBuffer.get(0);
                    continue;
                }
                if (freeBufferIndex == oldDataBuffer.get(0)) continue;
                badRadio = radio;
                break;
            }
            if (badRadio != null) {
                badRadio.stop();
                return 0;
            }
            return freeBufferIndex;
        }
        return 0;
    }

    private static ByteBuffer stereoToMono(ByteBuffer stereoBuffer) {
        ByteBuffer monoBuffer = ByteBuffer.allocateDirect(stereoBuffer.limit() / 2);
        while (stereoBuffer.hasRemaining()) {
            byte[] sampleSet = new byte[4];
            stereoBuffer.get(sampleSet);
            int leftSample = sampleSet[1] << 8 | sampleSet[0] & 0xFF;
            int rightSample = sampleSet[3] << 8 | sampleSet[2] & 0xFF;
            int combinedSample = (leftSample + rightSample) / 2;
            monoBuffer.put((byte)(combinedSample & 0xFF));
            monoBuffer.put((byte)(combinedSample >> 8));
        }
        return (ByteBuffer)monoBuffer.flip();
    }

    private static Integer loadOGGJarSound(String soundName) {
        if (dataSourceBuffers.containsKey(soundName)) {
            return dataSourceBuffers.get(soundName);
        }
        OGGDecoderOutput decoderOutput = MasterInterface.oggDecoderInterface.parseWholeOGGFile(soundName);
        if (decoderOutput != null) {
            IntBuffer dataBufferPointers = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)dataBufferPointers);
            ByteBuffer decoderData = decoderOutput.isStereo ? InterfaceAudio.stereoToMono(decoderOutput.decodedData) : decoderOutput.decodedData;
            AL10.alBufferData((int)dataBufferPointers.get(0), (int)4353, (ByteBuffer)decoderData, (int)decoderOutput.sampleRate);
            dataSourceBuffers.put(soundName, dataBufferPointers.get(0));
            return dataSourceBuffers.get(soundName);
        }
        return null;
    }

    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            try {
                MasterInterface.audioInterface.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void on(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            Iterator<SoundInstance> iterator = queuedSounds.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().provider.getProviderWorld().getDimensionID() != event.getWorld().field_73011_w.getDimension()) continue;
                iterator.remove();
            }
            for (SoundInstance playingSound : playingSounds) {
                if (playingSound.provider.getProviderWorld().getDimensionID() != event.getWorld().field_73011_w.getDimension()) continue;
                if (playingSound.radio != null) {
                    playingSound.radio.stop();
                    continue;
                }
                playingSound.stop();
            }
            isSystemPaused = false;
            MasterInterface.audioInterface.update();
        }
    }

    static {
        dataSourceBuffers = new HashMap<String, Integer>();
        playingSounds = new ArrayList<SoundInstance>();
        playingStations = new ArrayList<RadioStation>();
        queuedSounds = new ArrayList<SoundInstance>();
        sourceGetFailures = 0;
    }
}

