/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.List;
import mcinterface1122.BuilderItem;
import mcinterface1122.MasterInterface;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperTileEntity;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.IInterfaceCore;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperTileEntity;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

class InterfaceCore
implements IInterfaceCore {
    private final List<String> queuedLogs = new ArrayList<String>();

    InterfaceCore() {
    }

    @Override
    public String getGameVersion() {
        return Loader.instance().getMCVersionString().substring("Minecraft ".length());
    }

    @Override
    public boolean isModPresent(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    @Override
    public String getModName(String modID) {
        return ((ModContainer)Loader.instance().getIndexedModList().get(modID)).getName();
    }

    @Override
    public String getFluidName(String fluidID) {
        return FluidRegistry.getFluid((String)fluidID) != null ? new FluidStack(FluidRegistry.getFluid((String)fluidID), 1).getLocalizedName() : "INVALID";
    }

    @Override
    public String translate(String text) {
        return I18n.func_74838_a((String)text);
    }

    @Override
    public void logError(String message) {
        if (MasterInterface.logger == null) {
            this.queuedLogs.add(message);
        } else {
            MasterInterface.logger.error(message);
        }
    }

    @Override
    public IWrapperNBT createNewTag() {
        return new WrapperNBT(new NBTTagCompound());
    }

    @Override
    public IWrapperItemStack getStack(AItemBase item) {
        return new WrapperItemStack(new ItemStack((Item)BuilderItem.itemWrapperMap.get(item)));
    }

    @Override
    public List<IWrapperItemStack> parseFromJSON(AItemPack<?> item, boolean includeMain, boolean includeSub) {
        ArrayList<IWrapperItemStack> stackList = new ArrayList<IWrapperItemStack>();
        String currentSubName = "";
        try {
            int itemMetadata;
            int itemQty;
            if (includeMain) {
                for (String itemText : ((AJSONItem.General)((AJSONItem)item.definition).general).materials) {
                    itemQty = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
                    itemText = itemText.substring(0, itemText.lastIndexOf(58));
                    itemMetadata = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
                    itemText = itemText.substring(0, itemText.lastIndexOf(58));
                    stackList.add(new WrapperItemStack(new ItemStack(Item.func_111206_d((String)itemText), itemQty, itemMetadata)));
                }
            }
            if (includeSub && item instanceof AItemSubTyped) {
                for (String itemText : ((AItemSubTyped)item).getExtraMaterials()) {
                    itemQty = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
                    itemText = itemText.substring(0, itemText.lastIndexOf(58));
                    itemMetadata = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
                    itemText = itemText.substring(0, itemText.lastIndexOf(58));
                    stackList.add(new WrapperItemStack(new ItemStack(Item.func_111206_d((String)itemText), itemQty, itemMetadata)));
                }
            }
            return stackList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NullPointerException("ERROR: Could not parse crafting ingredients for item: " + ((AJSONItem)item.definition).packID + ((AJSONItem)item.definition).systemName + currentSubName + ".  Report this to the pack author!");
        }
    }

    @Override
    public IWrapperTileEntity getFakeTileEntity(String type, IWrapperWorld world, IWrapperNBT data, int inventoryUnits) {
        switch (type) {
            case "chest": {
                return new WrapperTileEntity.WrapperEntityChest((WrapperWorld)world, (WrapperNBT)data, inventoryUnits);
            }
            case "furnace": {
                return new WrapperTileEntity.WrapperEntityFurnace((WrapperWorld)world, (WrapperNBT)data);
            }
            case "brewing_stand": {
                return new WrapperTileEntity.WrapperEntityBrewingStand((WrapperWorld)world, (WrapperNBT)data);
            }
        }
        return null;
    }

    public void flushLogQueue() {
        for (String log : this.queuedLogs) {
            this.logError(log);
        }
    }
}

