/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcinterface1122.MasterInterface;
import minecrafttransportsimulator.guis.instances.GUIConfig;
import minecrafttransportsimulator.mcinterface.IInterfaceInput;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.MouseHelper;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
class InterfaceInput
implements IInterfaceInput {
    private static KeyBinding configKey;
    private static boolean enableMouse;
    private static int mousePosX;
    private static int mousePosY;
    private static InhibitableMouseHelper customMouseHelper;
    private static boolean joystickEnabled;
    private static boolean joystickInhibited;
    private static final Map<String, Controller> joystickMap;
    private static final Map<String, Integer> joystickNameCounters;

    InterfaceInput() {
    }

    @Override
    public String getNameForKeyCode(int keyCode) {
        return Keyboard.getKeyName((int)keyCode);
    }

    @Override
    public int getKeyCodeForName(String name) {
        return Keyboard.getKeyIndex((String)name);
    }

    @Override
    public boolean isKeyPressed(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode);
    }

    @Override
    public boolean isJoystickSupportEnabled() {
        return joystickEnabled;
    }

    @Override
    public boolean isJoystickPresent(String joystickName) {
        return !joystickInhibited && joystickMap.containsKey(joystickName);
    }

    @Override
    public Set<String> getAllJoysticks() {
        return joystickMap.keySet();
    }

    @Override
    public int getJoystickInputCount(String joystickName) {
        return joystickMap.get(joystickName).getComponents().length;
    }

    @Override
    public String getJoystickInputName(String joystickName, int buttonIndex) {
        return joystickMap.get(joystickName).getComponents()[buttonIndex].getName();
    }

    @Override
    public boolean isJoystickInputAnalog(String joystickName, int buttonIndex) {
        return joystickMap.get(joystickName).getComponents()[buttonIndex].isAnalog();
    }

    @Override
    public boolean isJoystickButtonPressed(String joystickName, int buttonIndex) {
        joystickMap.get(joystickName).poll();
        return joystickMap.get(joystickName).getComponents()[buttonIndex].getPollData() > 0.0f;
    }

    @Override
    public float getJoystickInputValue(String joystickName, int axisIndex) {
        if (joystickMap.containsKey(joystickName)) {
            joystickMap.get(joystickName).poll();
            return joystickMap.get(joystickName).getComponents()[axisIndex].getPollData();
        }
        return 0.0f;
    }

    @Override
    public void inhibitJoysticks(boolean inhibited) {
        joystickInhibited = inhibited;
    }

    @Override
    public void setMouseEnabled(boolean enabled) {
        enableMouse = enabled;
        Minecraft.func_71410_x().field_71417_B = customMouseHelper;
    }

    @Override
    public long getTrackedMouseInfo() {
        if (Math.abs(customMouseHelper.deltaXForced) < 100) {
            mousePosX = Math.max(Math.min(mousePosX + customMouseHelper.deltaXForced, 250), -250);
        }
        if (Math.abs(customMouseHelper.deltaYForced) < 100) {
            mousePosY = Math.max(Math.min(mousePosY + customMouseHelper.deltaYForced, 250), -250);
        }
        if (mousePosX > 0) {
            --mousePosX;
        } else if (mousePosX < 0) {
            ++mousePosX;
        }
        if (mousePosY > 0) {
            --mousePosY;
        } else if (mousePosY < 0) {
            ++mousePosY;
        }
        return 2L * (long)mousePosX << 32 | (long)(2 * mousePosY) & 0xFFFFFFFFL;
    }

    @Override
    public int getTrackedMouseWheel() {
        return Mouse.hasWheel() ? Mouse.getDWheel() : 0;
    }

    @SubscribeEvent
    public static void on(InputEvent.KeyInputEvent event) {
        if (configKey.func_151468_f() && MasterInterface.guiInterface.isGUIActive(null)) {
            MasterInterface.guiInterface.openGUI(new GUIConfig());
        }
    }

    static {
        enableMouse = false;
        mousePosX = 0;
        mousePosY = 0;
        customMouseHelper = new InhibitableMouseHelper();
        joystickEnabled = false;
        joystickInhibited = false;
        joystickMap = new HashMap<String, Controller>();
        joystickNameCounters = new HashMap<String, Integer>();
        configKey = new KeyBinding("key.mts.config", 25, "key.categories.mts");
        ClientRegistry.registerKeyBinding((KeyBinding)configKey);
        for (Controller joystick : ControllerEnvironment.getDefaultEnvironment().getControllers()) {
            joystickEnabled = true;
            if (joystick.getType() == null || joystick.getName() == null || joystick.getType().equals(Controller.Type.MOUSE) || joystick.getType().equals(Controller.Type.KEYBOARD) || joystick.getType().equals(Controller.Type.UNKNOWN) || joystick.getComponents().length == 0) continue;
            String joystickName = joystick.getName();
            if (!joystickNameCounters.containsKey(joystickName)) {
                joystickNameCounters.put(joystickName, 0);
            }
            joystickMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick);
            joystickNameCounters.put(joystickName, joystickNameCounters.get(joystickName) + 1);
        }
    }

    private static class InhibitableMouseHelper
    extends MouseHelper {
        private int deltaXForced;
        private int deltaYForced;

        private InhibitableMouseHelper() {
        }

        public void func_74374_c() {
            super.func_74374_c();
            if (!enableMouse) {
                this.deltaXForced = this.field_74377_a;
                this.deltaYForced = this.field_74375_b;
                this.field_74377_a = 0;
                this.field_74375_b = 0;
            }
        }
    }
}

