/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mcinterface1122.MasterInterface;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfaceNetwork;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.packets.components.APacketBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

class InterfaceNetwork
implements IInterfaceNetwork {
    private static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("mts");
    private static final BiMap<Byte, Class<? extends APacketBase>> packetMappings = HashBiMap.create();

    InterfaceNetwork() {
    }

    public void init() {
        network.registerMessage(WrapperHandler.class, WrapperPacket.class, 0, Side.CLIENT);
        network.registerMessage(WrapperHandler.class, WrapperPacket.class, 1, Side.SERVER);
    }

    @Override
    public void registerPacket(byte packetIndex, Class<? extends APacketBase> packetClass) {
        packetMappings.put((Object)packetIndex, packetClass);
    }

    @Override
    public byte getPacketIndex(APacketBase packet) {
        return (Byte)packetMappings.inverse().get(packet.getClass());
    }

    @Override
    public void sendToServer(APacketBase packet) {
        network.sendToServer((IMessage)new WrapperPacket(packet));
    }

    @Override
    public void sendToAllClients(APacketBase packet) {
        network.sendToAll((IMessage)new WrapperPacket(packet));
    }

    @Override
    public IWrapperNBT createDataFromBuffer(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        try {
            return new WrapperNBT(pb.func_150793_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void sendToPlayer(APacketBase packet, EntityPlayerMP player) {
        network.sendTo((IMessage)new WrapperPacket(packet), player);
    }

    private static WrapperWorld getServerWorld(MessageContext ctx) {
        return WrapperWorld.getWrapperFor(ctx.getServerHandler().field_147369_b.field_70170_p);
    }

    private static WrapperPlayer getServerPlayer(MessageContext ctx) {
        return InterfaceNetwork.getServerWorld(ctx).getWrapperFor((EntityPlayer)ctx.getServerHandler().field_147369_b);
    }

    public static class WrapperHandler
    implements IMessageHandler<WrapperPacket, IMessage> {
        public IMessage onMessage(final WrapperPacket message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (ctx.side.isServer()) {
                        message.packet.handle(InterfaceNetwork.getServerWorld(ctx), InterfaceNetwork.getServerPlayer(ctx));
                    } else {
                        message.packet.handle(MasterInterface.gameInterface.getClientWorld(), MasterInterface.gameInterface.getClientPlayer());
                    }
                }
            });
            return null;
        }
    }

    public static class WrapperPacket
    implements IMessage {
        private APacketBase packet;

        public WrapperPacket() {
        }

        public WrapperPacket(APacketBase packet) {
            this.packet = packet;
        }

        public void fromBytes(ByteBuf buf) {
            byte packetIndex = buf.readByte();
            try {
                Class packetClass = (Class)packetMappings.get((Object)packetIndex);
                this.packet = (APacketBase)packetClass.getConstructor(ByteBuf.class).newInstance(buf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            this.packet.writeToBuffer(buf);
        }
    }
}

