/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcinterface1122.BuilderEntity;
import mcinterface1122.BuilderGUI;
import mcinterface1122.BuilderItem;
import mcinterface1122.BuilderParticle;
import mcinterface1122.BuilderTileEntity;
import mcinterface1122.BuilderTileEntityRender;
import mcinterface1122.MasterInterface;
import mcinterface1122.WrapperEntity;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIHUD;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IInterfaceRender;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.rendering.components.AParticle;
import minecrafttransportsimulator.rendering.components.RenderTickData;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.VehicleAnimationSystem;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartInteractable;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
class InterfaceRender
implements IInterfaceRender {
    private static final Map<String, Integer> textures = new HashMap<String, Integer>();
    private static final Map<BuilderEntity, RenderTickData> renderData = new HashMap<BuilderEntity, RenderTickData>();
    private static String pushedTextureLocation;
    private static int zoomLevel;
    private static int customCameraIndex;
    private static boolean runningCustomCameras;
    private static BuilderGUI currentHUD;

    InterfaceRender() {
    }

    @Override
    public int getRenderPass() {
        return MinecraftForgeClient.getRenderPass();
    }

    @Override
    public boolean shouldRenderBoundingBoxes() {
        return Minecraft.func_71410_x().func_175598_ae().func_178634_b() && this.getRenderPass() != 1;
    }

    @Override
    public void bindTexture(String textureLocation) {
        if (textureLocation.indexOf(":") != -1) {
            textureLocation = "/assets/" + textureLocation.replace(":", "/");
        }
        if (!textures.containsKey(textureLocation)) {
            try {
                BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)InterfaceRender.class.getResourceAsStream(textureLocation));
                int glTexturePointer = TextureUtil.func_110996_a();
                TextureUtil.func_110989_a((int)glTexturePointer, (BufferedImage)bufferedimage, (boolean)false, (boolean)false);
                textures.put(textureLocation, glTexturePointer);
            }
            catch (Exception e) {
                MasterInterface.coreInterface.logError("ERROR: Could not find texture: " + textureLocation + " Reverting to fallback texture.");
                textures.put(textureLocation, TextureUtil.field_111001_a.func_110552_b());
            }
        }
        GlStateManager.func_179144_i((int)textures.get(textureLocation));
    }

    @Override
    public void setTexture(String textureLocation) {
        pushedTextureLocation = textureLocation;
        this.bindTexture(textureLocation);
    }

    @Override
    public void recallTexture() {
        if (pushedTextureLocation != null) {
            GlStateManager.func_179144_i((int)textures.get(pushedTextureLocation));
        }
    }

    @Override
    public void setLightingState(boolean enabled) {
        this.setSystemLightingState(enabled);
        this.setInternalLightingState(enabled);
    }

    @Override
    public void setSystemLightingState(boolean enabled) {
        if (enabled) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    @Override
    public void setInternalLightingState(boolean enabled) {
        if (enabled) {
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
        } else {
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
    }

    @Override
    public void setLightingToEntity(AEntityBase entity) {
        if (this.getRenderPass() == -1) {
            RenderHelper.func_74519_b();
            this.setLightingState(true);
        }
        int lightVar = BuilderEntity.createdClientBuilders.get(entity).func_70070_b();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightVar % 65536), (float)(lightVar / 65536));
    }

    @Override
    public void setLightingToBlock(Point3i location) {
        if (this.getRenderPass() == -1) {
            RenderHelper.func_74519_b();
            this.setLightingState(true);
        }
        int lightVar = Minecraft.func_71410_x().field_71441_e.func_175626_b(new BlockPos(location.x, location.y, location.z), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightVar % 65536), (float)(lightVar / 65536));
    }

    @Override
    public void setBlendState(boolean enabled, boolean brightBlend) {
        if (enabled) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179132_a((boolean)false);
            if (brightBlend) {
                GlStateManager.func_179112_b((int)774, (int)770);
            } else {
                GlStateManager.func_179112_b((int)770, (int)771);
            }
        } else {
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179112_b((int)770, (int)771);
        }
    }

    @Override
    public void setColorState(float red, float green, float blue, float alpha) {
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    @Override
    public void resetStates() {
        this.setColorState(1.0f, 1.0f, 1.0f, 1.0f);
        this.setBlendState(this.getRenderPass() == 1, false);
        GL11.glEnable((int)3553);
        if (this.getRenderPass() != -1) {
            this.setLightingState(true);
        } else {
            this.setLightingState(false);
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public void changeCameraZoom(boolean zoomIn) {
        if (zoomIn && zoomLevel > 0) {
            zoomLevel -= 2;
        } else if (!zoomIn) {
            zoomLevel += 2;
        }
    }

    @Override
    public void renderEntityRiders(AEntityBase entity, float partialTicks) {
        for (IWrapperEntity rider : entity.locationRiderMap.values()) {
            Entity riderEntity = ((WrapperEntity)rider).entity;
            if (MasterInterface.gameInterface.getClientPlayer().equals(rider) && MasterInterface.gameInterface.inFirstPerson() || !(riderEntity.field_70163_u > (double)riderEntity.field_70170_p.func_72800_K())) continue;
            GL11.glPushMatrix();
            Point3d riderPosition = rider.getRenderedPosition(partialTicks);
            GL11.glTranslated((double)riderPosition.x, (double)riderPosition.y, (double)riderPosition.z);
            Minecraft.func_71410_x().func_175598_ae().func_188388_a(riderEntity, partialTicks, false);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void spawnParticle(AParticle particle) {
        if (Minecraft.func_71410_x().field_71452_i != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new BuilderParticle(particle));
        }
    }

    @Override
    public void spawnBlockBreakParticles(Point3i point) {
        if (Minecraft.func_71410_x().field_71452_i != null) {
            BlockPos pos = new BlockPos(point.x, point.y, point.z);
            SoundType soundType = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c().getSoundType(Minecraft.func_71410_x().field_71441_e.func_180495_p(pos), Minecraft.func_71410_x().field_71439_g.field_70170_p, pos, null);
            Minecraft.func_71410_x().field_71441_e.func_184133_a(null, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
            Minecraft.func_71410_x().field_71452_i.func_180532_a(pos, EnumFacing.UP);
        }
    }

    @Override
    public boolean renderTextMarkings(List<JSONText> textDefinitions, List<String> textLines, String objectRendering, boolean lightsOn) {
        if (this.getRenderPass() != 1) {
            boolean systemLightingEnabled = true;
            boolean internalLightingEnabled = true;
            if (textDefinitions != null) {
                for (int i = 0; i < textDefinitions.size(); i = (int)((byte)(i + 1))) {
                    JSONText textDefinition = textDefinitions.get(i);
                    String text = textLines.get(i);
                    if (!(textDefinition.attachedTo == null ? objectRendering == null : textDefinition.attachedTo.equals(objectRendering))) continue;
                    if (systemLightingEnabled) {
                        this.setSystemLightingState(false);
                        systemLightingEnabled = false;
                    }
                    if (textDefinition.lightsUp && lightsOn) {
                        if (internalLightingEnabled) {
                            internalLightingEnabled = false;
                            this.setInternalLightingState(internalLightingEnabled);
                        }
                    } else if (!internalLightingEnabled) {
                        internalLightingEnabled = true;
                        this.setInternalLightingState(internalLightingEnabled);
                    }
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)textDefinition.pos.x, (double)textDefinition.pos.y, (double)textDefinition.pos.z);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotated((double)(-textDefinition.rot.y), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)textDefinition.rot.x, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)textDefinition.rot.z, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                    MasterInterface.guiInterface.drawScaledText(text, 0, 0, Color.decode(textDefinition.color), AGUIBase.TextPosition.values()[textDefinition.renderPosition], textDefinition.wrapWidth, textDefinition.scale, textDefinition.autoScale);
                    GL11.glPopMatrix();
                }
            }
            if (!internalLightingEnabled) {
                this.setInternalLightingState(true);
            }
            if (!systemLightingEnabled) {
                this.setSystemLightingState(true);
                this.setColorState(1.0f, 1.0f, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    @SubscribeEvent
    public static void on(RenderPlayerEvent.Pre event) {
        EntityPlayer renderedPlayer = event.getEntityPlayer();
        if (renderedPlayer.func_184187_bx() instanceof BuilderEntity) {
            AEntityBase ridingEntity = ((BuilderEntity)renderedPlayer.func_184187_bx()).entity;
            GL11.glPushMatrix();
            if (ridingEntity != null) {
                Point3d totalAngles = ridingEntity.angles.copy();
                if (ridingEntity instanceof EntityVehicleF_Physics) {
                    for (IWrapperEntity rider : ridingEntity.locationRiderMap.values()) {
                        if (!Minecraft.func_71410_x().field_71439_g.equals((Object)((WrapperEntity)rider).entity)) continue;
                        PartSeat seat = (PartSeat)((EntityVehicleF_Physics)ridingEntity).getPartAtLocation((Point3d)ridingEntity.locationRiderMap.inverse().get((Object)rider));
                        totalAngles = ridingEntity.angles.copy().add(seat.placementRotation).add(seat.getPositionRotation(event.getPartialRenderTick()).add(seat.getActionRotation(event.getPartialRenderTick())));
                        if (seat.parentPart == null) continue;
                        totalAngles.add(seat.parentPart.placementRotation).add(seat.parentPart.getPositionRotation(event.getPartialRenderTick()).add(seat.parentPart.getActionRotation(event.getPartialRenderTick())));
                    }
                }
                renderedPlayer.field_70761_aq = 0.0f;
                renderedPlayer.field_70759_as = (float)((double)renderedPlayer.field_70177_z + totalAngles.y);
                if (!renderedPlayer.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                    EntityPlayerSP masterPlayer = Minecraft.func_71410_x().field_71439_g;
                    double playerDistanceX = renderedPlayer.field_70142_S + -masterPlayer.field_70142_S + (renderedPlayer.field_70165_t - renderedPlayer.field_70142_S - (masterPlayer.field_70165_t - masterPlayer.field_70142_S)) * (double)event.getPartialRenderTick();
                    double playerDistanceY = renderedPlayer.field_70137_T + -masterPlayer.field_70137_T + (renderedPlayer.field_70163_u - renderedPlayer.field_70137_T - (masterPlayer.field_70163_u - masterPlayer.field_70137_T)) * (double)event.getPartialRenderTick();
                    double playerDistanceZ = renderedPlayer.field_70136_U + -masterPlayer.field_70136_U + (renderedPlayer.field_70161_v - renderedPlayer.field_70136_U - (masterPlayer.field_70161_v - masterPlayer.field_70136_U)) * (double)event.getPartialRenderTick();
                    GL11.glTranslated((double)playerDistanceX, (double)playerDistanceY, (double)playerDistanceZ);
                    GL11.glTranslated((double)0.0, (double)renderedPlayer.func_70047_e(), (double)0.0);
                    GL11.glRotated((double)totalAngles.y, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)totalAngles.x, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)totalAngles.z, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glTranslated((double)0.0, (double)(-renderedPlayer.func_70047_e()), (double)0.0);
                    GL11.glTranslated((double)(-playerDistanceX), (double)(-playerDistanceY), (double)(-playerDistanceZ));
                } else {
                    GL11.glTranslated((double)0.0, (double)renderedPlayer.func_70047_e(), (double)0.0);
                    GL11.glRotated((double)totalAngles.y, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)totalAngles.x, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)totalAngles.z, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glTranslated((double)0.0, (double)(-renderedPlayer.func_70047_e()), (double)0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(RenderPlayerEvent.Post event) {
        if (event.getEntityPlayer().func_184187_bx() instanceof BuilderEntity) {
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public static void on(EntityViewRenderEvent.CameraSetup event) {
        AEntityBase entity;
        Entity player = event.getEntity();
        if (player.func_184187_bx() instanceof BuilderEntity && (entity = ((BuilderEntity)player.func_184187_bx()).entity) instanceof EntityVehicleF_Physics) {
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
            Point3d riderLocation = (Point3d)vehicle.locationRiderMap.inverse().get((Object)WrapperWorld.getWrapperFor(event.getEntity().field_70170_p).getWrapperFor(event.getEntity()));
            if (riderLocation != null) {
                if (MasterInterface.gameInterface.inFirstPerson()) {
                    if (runningCustomCameras) {
                        JSONVehicle.VehicleCameraObject camera = null;
                        APart optionalPart = null;
                        int camerasChecked = 0;
                        if (vehicle.definition.rendering.cameraObjects != null) {
                            camerasChecked += vehicle.definition.rendering.cameraObjects.size();
                            if (customCameraIndex < vehicle.definition.rendering.cameraObjects.size()) {
                                camera = vehicle.definition.rendering.cameraObjects.get(customCameraIndex);
                            }
                        }
                        if (camera == null) {
                            for (APart part : vehicle.parts) {
                                if (part.definition.rendering == null || part.definition.rendering.cameraObjects == null) continue;
                                if (customCameraIndex < camerasChecked + part.definition.rendering.cameraObjects.size()) {
                                    camera = part.definition.rendering.cameraObjects.get(customCameraIndex - camerasChecked);
                                    optionalPart = part;
                                    break;
                                }
                                camerasChecked += part.definition.rendering.cameraObjects.size();
                            }
                        }
                        if (camera != null) {
                            event.setPitch(0.0f);
                            event.setYaw(0.0f);
                            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                            Point3d totalRotation = optionalPart != null ? (camera.rot != null ? optionalPart.totalRotation.copy().add(camera.rot) : optionalPart.totalRotation) : camera.rot;
                            if (totalRotation != null) {
                                GL11.glRotated((double)(-camera.rot.y), (double)0.0, (double)1.0, (double)0.0);
                                GL11.glRotated((double)(-camera.rot.x), (double)1.0, (double)0.0, (double)0.0);
                                GL11.glRotated((double)(-camera.rot.z), (double)0.0, (double)0.0, (double)1.0);
                            }
                            if (camera.animations != null) {
                                for (JSONVehicle.VehicleAnimationDefinition animation : camera.animations) {
                                    double animationValue = VehicleAnimationSystem.getVariableValue(animation.variable, animation.axis.length(), animation.offset, animation.clampMin, animation.clampMax, animation.absolute, (float)event.getRenderPartialTicks(), vehicle, optionalPart);
                                    if (!animation.animationType.equals("rotation") || animationValue == 0.0) continue;
                                    Point3d rotationAxis = animation.axis.copy().normalize();
                                    if (animationValue == 0.0) continue;
                                    GL11.glTranslated((double)(animation.centerPoint.x - camera.pos.x), (double)(animation.centerPoint.y - camera.pos.y), (double)(animation.centerPoint.z - camera.pos.z));
                                    GL11.glRotated((double)animationValue, (double)(-rotationAxis.x), (double)(-rotationAxis.y), (double)(-rotationAxis.z));
                                    GL11.glTranslated((double)(-(animation.centerPoint.x - camera.pos.x)), (double)(-(animation.centerPoint.y - camera.pos.y)), (double)(-(animation.centerPoint.z - camera.pos.z)));
                                }
                            }
                            double playerPositionToEyeOffset = 0.87;
                            if (optionalPart != null) {
                                GL11.glTranslated((double)(-(optionalPart.totalOffset.x + camera.pos.x - riderLocation.x)), (double)(-(optionalPart.totalOffset.y + camera.pos.y - playerPositionToEyeOffset - riderLocation.y)), (double)(-(optionalPart.totalOffset.z + camera.pos.z - riderLocation.z)));
                            } else {
                                GL11.glTranslated((double)(-(camera.pos.x - riderLocation.x)), (double)(-(camera.pos.y - playerPositionToEyeOffset - riderLocation.y)), (double)(-(camera.pos.z - riderLocation.z)));
                            }
                            if (camera.animations != null) {
                                for (JSONVehicle.VehicleAnimationDefinition animation : camera.animations) {
                                    double animationValue = VehicleAnimationSystem.getVariableValue(animation.variable, animation.axis.length(), animation.offset, animation.clampMin, animation.clampMax, animation.absolute, (float)event.getRenderPartialTicks(), vehicle, optionalPart);
                                    if (!animation.animationType.equals("translation") || animationValue == 0.0 || !animation.animationType.equals("translation")) continue;
                                    Point3d translationAmount = animation.axis.copy().normalize().multiply(animationValue);
                                    GL11.glTranslated((double)(-translationAmount.x), (double)(-translationAmount.y), (double)(-translationAmount.z));
                                }
                            }
                            Point3d vehicleSmoothedRotation = vehicle.prevAngles.copy().add(vehicle.angles.copy().subtract(vehicle.prevAngles).multiply(event.getRenderPartialTicks()));
                            GL11.glRotated((double)(-vehicleSmoothedRotation.x), (double)1.0, (double)0.0, (double)0.0);
                            GL11.glRotated((double)(-vehicleSmoothedRotation.y), (double)0.0, (double)1.0, (double)0.0);
                            GL11.glRotated((double)(-vehicleSmoothedRotation.z), (double)0.0, (double)0.0, (double)1.0);
                        } else {
                            runningCustomCameras = false;
                        }
                    } else {
                        double pitchAngle;
                        double playerYawDelta = (360.0 + (vehicle.angles.y - (double)(-event.getEntity().field_70177_z)) % 360.0) % 360.0;
                        if (playerYawDelta > 180.0) {
                            playerYawDelta -= 360.0;
                        }
                        double rollAngle = vehicle.prevAngles.z + (vehicle.angles.z - vehicle.prevAngles.z) * event.getRenderPartialTicks();
                        for (pitchAngle = vehicle.prevAngles.x + (vehicle.angles.x - vehicle.prevAngles.x) * event.getRenderPartialTicks(); pitchAngle > 180.0; pitchAngle -= 360.0) {
                        }
                        while (pitchAngle < -180.0) {
                            pitchAngle += 360.0;
                        }
                        while (rollAngle > 180.0) {
                            rollAngle -= 360.0;
                        }
                        while (rollAngle < -180.0) {
                            rollAngle += 360.0;
                        }
                        double rollRollComponent = Math.cos(Math.toRadians(playerYawDelta)) * rollAngle;
                        double pitchRollComponent = -Math.sin(Math.toRadians(playerYawDelta)) * pitchAngle;
                        GL11.glRotated((double)(rollRollComponent + pitchRollComponent), (double)0.0, (double)0.0, (double)1.0);
                    }
                } else if (MasterInterface.gameInterface.inThirdPerson()) {
                    if (runningCustomCameras) {
                        ++customCameraIndex;
                        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                    }
                    GL11.glTranslated((double)(-riderLocation.x), (double)0.0, (double)(-zoomLevel));
                } else {
                    runningCustomCameras = true;
                    customCameraIndex = 0;
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(RenderGameOverlayEvent.Post event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
            AEntityBase ridingEntity;
            if (MasterInterface.gameInterface.inFirstPerson() && Minecraft.func_71410_x().field_71439_g.func_184187_bx() == null) {
                RayTraceResult lastHit = Minecraft.func_71410_x().field_71476_x;
                if (lastHit != null && lastHit.field_72308_g instanceof BuilderEntity) {
                    BuilderEntity builder = (BuilderEntity)Minecraft.func_71410_x().field_71476_x.field_72308_g;
                    if (builder.entity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)builder.entity;
                        for (BoundingBox box : vehicle.interactionBoxes) {
                            FluidTank tank;
                            APart part;
                            if (!box.isPointInside(new Point3d(lastHit.field_72307_f.field_72450_a, lastHit.field_72307_f.field_72448_b, lastHit.field_72307_f.field_72449_c)) || !((part = vehicle.getPartAtLocation(box.localCenter)) instanceof PartInteractable) || (tank = ((PartInteractable)part).tank) == null) continue;
                            String tankText = tank.getFluid().isEmpty() ? "EMPTY" : tank.getFluid().toUpperCase() + " : " + tank.getFluidLevel() + "/" + tank.getMaxLevel();
                            MasterInterface.guiInterface.drawBasicText(tankText, event.getResolution().func_78326_a() / 2 + 4, event.getResolution().func_78328_b() / 2, Color.WHITE, AGUIBase.TextPosition.LEFT_ALIGNED, 0);
                            return;
                        }
                    }
                }
            } else if ((MasterInterface.gameInterface.inFirstPerson() ? (Boolean)ConfigSystem.configObject.client.renderHUD_1P.value : (Boolean)ConfigSystem.configObject.client.renderHUD_3P.value).booleanValue() && Minecraft.func_71410_x().field_71439_g.func_184187_bx() instanceof BuilderEntity && (ridingEntity = ((BuilderEntity)Minecraft.func_71410_x().field_71439_g.func_184187_bx()).entity) instanceof EntityVehicleF_Physics) {
                for (IWrapperEntity rider : ridingEntity.locationRiderMap.values()) {
                    if (!MasterInterface.gameInterface.getClientPlayer().equals(rider)) continue;
                    PartSeat seat = (PartSeat)((EntityVehicleF_Physics)ridingEntity).getPartAtLocation((Point3d)ridingEntity.locationRiderMap.inverse().get((Object)rider));
                    if (seat.activeGun != null && !MasterInterface.gameInterface.isChatOpen()) {
                        MasterInterface.guiInterface.drawBasicText("Active Gun:", event.getResolution().func_78326_a(), 0, Color.WHITE, AGUIBase.TextPosition.RIGHT_ALIGNED, 0);
                        MasterInterface.guiInterface.drawBasicText(seat.activeGun.getItemName(), event.getResolution().func_78326_a(), 8, Color.WHITE, AGUIBase.TextPosition.RIGHT_ALIGNED, 0);
                    }
                    if (!seat.vehicleDefinition.isController) continue;
                    if (currentHUD == null) {
                        currentHUD = new BuilderGUI(new GUIHUD((EntityVehicleF_Physics)ridingEntity));
                        currentHUD.func_73866_w_();
                        currentHUD.func_146280_a(Minecraft.func_71410_x(), event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
                    }
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)0.0, (double)0.0, (double)250.0);
                    if (MasterInterface.gameInterface.inFirstPerson() ? (Boolean)ConfigSystem.configObject.client.fullHUD_1P.value == false : (Boolean)ConfigSystem.configObject.client.fullHUD_3P.value == false) {
                        GL11.glTranslated((double)0.0, (double)((double)InterfaceRender.currentHUD.gui.getHeight() / 2.0), (double)0.0);
                    }
                    GL11.glEnable((int)3008);
                    currentHUD.func_73863_a(0, 0, event.getPartialTicks());
                    GL11.glPopMatrix();
                    MasterInterface.renderInterface.setInternalLightingState(false);
                    GL11.glDisable((int)3008);
                    return;
                }
            }
        }
        currentHUD = null;
    }

    @SubscribeEvent
    public static void on(RenderWorldLastEvent event) {
        Minecraft.func_71410_x().field_71441_e.field_72984_F.func_76320_a("iv_render_pass_-1");
        for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
            if (!(entity instanceof BuilderEntity)) continue;
            Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity).func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTicks());
        }
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        double playerX = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)event.getPartialTicks();
        double playerY = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)event.getPartialTicks();
        double playerZ = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)event.getPartialTicks();
        for (TileEntity tile : Minecraft.func_71410_x().field_71441_e.field_147482_g) {
            if (!(tile instanceof BuilderTileEntity)) continue;
            Vec3d delta = new Vec3d((Vec3i)tile.func_174877_v()).func_72441_c(-playerX, -playerY, -playerZ);
            if (TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile) == null) continue;
            TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile).func_192841_a(tile, delta.field_72450_a, delta.field_72448_b, delta.field_72449_c, event.getPartialTicks(), 0, 0.0f);
        }
        Minecraft.func_71410_x().field_71441_e.field_72984_F.func_76319_b();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110545_a((IResourcePack)new PackResourcePack("mts_packs"));
        RenderingRegistry.registerEntityRenderingHandler(BuilderEntity.class, (IRenderFactory)new IRenderFactory<BuilderEntity>(){

            public Render<? super BuilderEntity> createRenderFor(RenderManager manager) {
                return new Render<BuilderEntity>(manager){

                    protected ResourceLocation getEntityTexture(BuilderEntity builder) {
                        return null;
                    }

                    public void doRender(BuilderEntity builder, double x, double y, double z, float entityYaw, float partialTicks) {
                        if (builder.entity != null) {
                            int renderPass;
                            Minecraft.func_71410_x().field_71441_e.field_72984_F.func_76320_a("iv_render_entity_" + builder.entity.lookupID);
                            if (!renderData.containsKey((Object)builder)) {
                                renderData.put(builder, new RenderTickData(builder.entity.world));
                            }
                            if ((renderPass = MasterInterface.renderInterface.getRenderPass()) == -1) {
                                renderPass = 2;
                            }
                            if (((RenderTickData)renderData.get((Object)builder)).shouldRender(renderPass, partialTicks)) {
                                builder.entity.render(partialTicks);
                            }
                            Minecraft.func_71410_x().field_71441_e.field_72984_F.func_76319_b();
                        }
                    }
                };
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(BuilderTileEntity.class, (TileEntitySpecialRenderer)new BuilderTileEntityRender());
        for (Map.Entry<AItemBase, BuilderItem> entry : BuilderItem.itemWrapperMap.entrySet()) {
            try {
                if (entry.getValue().item instanceof AItemPack) continue;
                InterfaceRender.registerCoreItemRender(entry.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (AItemPack aItemPack : PackParserSystem.getAllPackItems()) {
            if (PackParserSystem.getPackConfiguration(((AJSONItem)aItemPack.definition).packID) == null || PackParserSystem.getPackConfiguration((String)((AJSONItem)aItemPack.definition).packID).internallyGenerated) {
                ModelLoader.setCustomModelResourceLocation((Item)BuilderItem.itemWrapperMap.get(aItemPack), (int)0, (ModelResourceLocation)new ModelResourceLocation("mts_packs:" + ((AJSONItem)aItemPack.definition).packID + "." + aItemPack.getRegistrationName(), "inventory"));
                continue;
            }
            if (!PackResourcePack.createdLoaders.containsKey(((AJSONItem)aItemPack.definition).packID)) {
                ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110545_a((IResourcePack)new PackResourcePack(((AJSONItem)aItemPack.definition).packID));
            }
            ModelLoader.setCustomModelResourceLocation((Item)BuilderItem.itemWrapperMap.get(aItemPack), (int)0, (ModelResourceLocation)new ModelResourceLocation("mts_packs:" + aItemPack.getRegistrationName(), "inventory"));
        }
    }

    private static void registerCoreItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("mts:" + item.getRegistryName().func_110623_a(), "inventory"));
    }

    static {
        currentHUD = null;
    }

    private static class PackResourcePack
    implements IResourcePack {
        private static final Map<String, PackResourcePack> createdLoaders = new HashMap<String, PackResourcePack>();
        private final String packDomain;
        private final Set<String> domains;

        private PackResourcePack(String packDomain) {
            this.packDomain = packDomain;
            this.domains = new HashSet<String>();
            this.domains.add(packDomain);
            createdLoaders.put(packDomain, this);
        }

        public InputStream func_110590_a(ResourceLocation location) throws IOException {
            String rawPackInfo = location.func_110623_a();
            try {
                boolean itemJSON = rawPackInfo.endsWith(".json");
                if (itemJSON) {
                    String combinedPackInfo = rawPackInfo;
                    combinedPackInfo = combinedPackInfo.substring("models/item/".length(), combinedPackInfo.length() - ".json".length());
                    String packID = combinedPackInfo.substring(0, combinedPackInfo.indexOf(46));
                    String systemName = combinedPackInfo.substring(combinedPackInfo.lastIndexOf(46) + 1);
                    Object packItem = PackParserSystem.getItem(packID, systemName);
                    String resourcePath = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_JSON, systemName);
                    InputStream stream = this.getClass().getResourceAsStream(resourcePath);
                    if (stream != null) {
                        return stream;
                    }
                    String itemTexturePath = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_PNG, systemName);
                    itemTexturePath = itemTexturePath.substring(("/assets/" + packID + "/textures/").length());
                    itemTexturePath = itemTexturePath.substring(0, itemTexturePath.length() - ".png".length());
                    itemTexturePath = packID + ":" + itemTexturePath;
                    String fakeJSON = "{\"parent\":\"mts:item/basic\",\"textures\":{\"layer0\": \"" + itemTexturePath + "\"}}";
                    return new ByteArrayInputStream(fakeJSON.getBytes(StandardCharsets.UTF_8));
                }
                String combinedPackInfo = rawPackInfo;
                combinedPackInfo = combinedPackInfo.substring("textures/".length(), combinedPackInfo.length() - ".png".length());
                String packID = this.packDomain;
                String systemName = combinedPackInfo.substring(combinedPackInfo.lastIndexOf(47) + 1);
                if (systemName.endsWith("_item")) {
                    systemName = systemName.substring(0, systemName.length() - "_item".length());
                }
                Object packItem = PackParserSystem.getItem(packID, systemName);
                return this.getClass().getResourceAsStream(PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_PNG, systemName));
            }
            catch (Exception e) {
                MasterInterface.coreInterface.logError("ERROR: Could not parse out item JSON or PNG from: " + rawPackInfo);
                return null;
            }
        }

        public boolean func_110589_b(ResourceLocation location) {
            return this.domains.contains(location.func_110624_b()) && !location.func_110623_a().contains("blockstates") && !location.func_110623_a().contains("armatures") && !location.func_110623_a().contains("mcmeta") && (location.func_110623_a().startsWith("models/item/") || location.func_110623_a().startsWith("textures/"));
        }

        public Set<String> func_110587_b() {
            return this.domains;
        }

        public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
            return null;
        }

        public BufferedImage func_110586_a() throws IOException {
            return null;
        }

        public String func_130077_b() {
            return "Internal:" + this.packDomain;
        }
    }
}

