/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import mcinterface1122.BuilderItem;
import mcinterface1122.InterfaceAudio;
import mcinterface1122.InterfaceCore;
import mcinterface1122.InterfaceGUI;
import mcinterface1122.InterfaceGame;
import mcinterface1122.InterfaceInput;
import mcinterface1122.InterfaceNetwork;
import mcinterface1122.InterfaceOGGDecoder;
import mcinterface1122.InterfaceRender;
import mcinterface1122.PacketEntityCSHandshake;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="mts", name="Minecraft Transport Simulator", version="19.5.0")
public class MasterInterface {
    static final String MODID = "mts";
    static final String MODNAME = "Minecraft Transport Simulator";
    static final String MODVER = "19.5.0";
    static Logger logger;
    static final InterfaceAudio audioInterface;
    static final InterfaceCore coreInterface;
    static final InterfaceGame gameInterface;
    static final InterfaceGUI guiInterface;
    static final InterfaceInput inputInterface;
    static final InterfaceNetwork networkInterface;
    static final InterfaceOGGDecoder oggDecoderInterface;
    static final InterfaceRender renderInterface;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        coreInterface.flushLogQueue();
        MasterLoader.setMainDirectory(event.getModConfigurationDirectory().getParent());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        byte packetIndex;
        networkInterface.init();
        byte by = packetIndex = 0;
        packetIndex = (byte)(packetIndex + 1);
        networkInterface.registerPacket(by, PacketEntityCSHandshake.class);
        MasterLoader.registerPackets(packetIndex);
    }

    public static void createItem(AItemBase item) {
        String packID;
        BuilderItem.itemWrapperMap.put(item, new BuilderItem(item));
        if (item instanceof AItemPack && PackParserSystem.getPackConfiguration(packID = ((AJSONItem)((AItemPack)item).definition).packID) == null) {
            BuilderItem.itemWrapperMap.get(item).func_77655_b(packID + "." + item.getRegistrationName());
        }
    }

    public static BuilderItem getItem(AItemBase item) {
        return BuilderItem.itemWrapperMap.get(item);
    }

    static {
        FluidRegistry.enableUniversalBucket();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            audioInterface = new InterfaceAudio();
            coreInterface = new InterfaceCore();
            gameInterface = new InterfaceGame();
            guiInterface = new InterfaceGUI();
            inputInterface = new InterfaceInput();
            networkInterface = new InterfaceNetwork();
            oggDecoderInterface = new InterfaceOGGDecoder();
            renderInterface = new InterfaceRender();
        } else {
            audioInterface = null;
            coreInterface = new InterfaceCore();
            gameInterface = null;
            guiInterface = null;
            inputInterface = null;
            networkInterface = new InterfaceNetwork();
            oggDecoderInterface = null;
            renderInterface = null;
        }
        MasterLoader.setInterfaces(MODID, audioInterface, coreInterface, gameInterface, guiInterface, inputInterface, networkInterface, oggDecoderInterface, renderInterface);
    }
}

