/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import io.netty.buffer.ByteBuf;
import mcinterface1122.MasterInterface;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketBase;

class PacketEntityCSHandshake
extends APacketBase {
    private final int builderID;
    private final IWrapperNBT data;

    public PacketEntityCSHandshake(int builderID, IWrapperNBT data) {
        super(null);
        this.builderID = builderID;
        this.data = data;
    }

    public PacketEntityCSHandshake(ByteBuf buf) {
        super(buf);
        this.builderID = buf.readInt();
        this.data = buf.readBoolean() ? MasterInterface.networkInterface.createDataFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.builderID);
        if (this.data != null) {
            buf.writeBoolean(true);
            this.data.writeToBuffer(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(IWrapperWorld world, IWrapperPlayer player) {
        if (world.isClient()) {
            world.getEntity(this.builderID).setNBT(this.data);
        } else {
            player.sendPacket(new PacketEntityCSHandshake(this.builderID, world.getEntity(this.builderID).getNBT()));
        }
    }
}

