/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import mcinterface1122.BuilderEntity;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

class WrapperEntity
implements IWrapperEntity {
    final Entity entity;
    private final Point3d mutablePosition = new Point3d(0.0, 0.0, 0.0);
    private final Point3d mutableVelocity = new Point3d(0.0, 0.0, 0.0);
    private final Point3d mutableRenderPosition = new Point3d(0.0, 0.0, 0.0);

    WrapperEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean equals(Object obj) {
        return this.entity.equals(obj instanceof WrapperEntity ? ((WrapperEntity)obj).entity : obj);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.entity != null && !this.entity.field_70128_L;
    }

    @Override
    public int getID() {
        return this.entity.func_145782_y();
    }

    @Override
    public AEntityBase getEntityRiding() {
        return this.entity.func_184187_bx() instanceof BuilderEntity ? ((BuilderEntity)this.entity.func_184187_bx()).entity : null;
    }

    @Override
    public void setRiding(AEntityBase entityToRide) {
        if (entityToRide != null) {
            this.entity.func_184205_a((Entity)BuilderEntity.createdServerBuilders.get(entityToRide), true);
        } else {
            this.entity.func_184210_p();
        }
    }

    @Override
    public double getSeatOffset() {
        return 0.0;
    }

    @Override
    public double getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @Override
    public Point3d getPosition() {
        this.mutablePosition.set(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        return this.mutablePosition;
    }

    @Override
    public void setPosition(Point3d position) {
        this.entity.func_70107_b(position.x, position.y, position.z);
    }

    @Override
    public Point3d getVelocity() {
        this.mutableVelocity.set(this.entity.field_70159_w, this.entity.field_70181_x, this.entity.field_70179_y);
        return this.mutableVelocity;
    }

    @Override
    public void setVelocity(Point3d motion) {
        this.entity.field_70159_w = motion.x;
        this.entity.field_70181_x = motion.y;
        this.entity.field_70179_y = motion.z;
    }

    @Override
    public float getPitch() {
        return this.entity.field_70125_A;
    }

    @Override
    public float getYaw() {
        return -this.entity.field_70177_z;
    }

    @Override
    public float getHeadYaw() {
        return -this.entity.func_70079_am();
    }

    @Override
    public void setYaw(double yaw) {
        this.entity.field_70177_z = (float)(-yaw);
    }

    @Override
    public void setHeadYaw(double yaw) {
        this.entity.func_70034_d((float)(-yaw));
    }

    @Override
    public void setPitch(double pitch) {
        this.entity.field_70125_A = (float)pitch;
    }

    @Override
    public IWrapperNBT getNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.entity.func_189511_e(tag);
        return new WrapperNBT(tag);
    }

    @Override
    public void setNBT(IWrapperNBT data) {
        this.entity.func_70020_e(((WrapperNBT)data).tag);
    }

    @Override
    public boolean leashTo(IWrapperPlayer playerWrapper) {
        EntityPlayer player = ((WrapperPlayer)playerWrapper).player;
        if (this.entity instanceof EntityLiving) {
            ItemStack heldStack = player.func_184614_ca();
            if (((EntityLiving)this.entity).func_184652_a(player) && heldStack.func_77973_b() instanceof ItemLead) {
                ((EntityLiving)this.entity).func_110162_b((Entity)player, true);
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void attack(Damage damage) {
        WrapperEntity.attack(this.entity, damage);
    }

    @Override
    public Point3d getRenderedPosition(float partialTicks) {
        this.mutableRenderPosition.x = this.entity.field_70142_S + (this.entity.field_70165_t - this.entity.field_70142_S) * (double)partialTicks;
        this.mutableRenderPosition.y = this.entity.field_70137_T + (this.entity.field_70163_u - this.entity.field_70137_T) * (double)partialTicks;
        this.mutableRenderPosition.z = this.entity.field_70136_U + (this.entity.field_70161_v - this.entity.field_70136_U) * (double)partialTicks;
        return this.mutableRenderPosition;
    }

    static void attack(Entity attackedEntity, final Damage damage) {
        if (attackedEntity instanceof BuilderEntity) {
            ((BuilderEntity)attackedEntity).entity.attack(damage);
            return;
        }
        DamageSource newSource = new DamageSource(damage.name){

            public ITextComponent func_151519_b(EntityLivingBase player) {
                EntityLivingBase recentEntity = player.func_94060_bK();
                if (recentEntity != null) {
                    if (damage.attacker != null) {
                        return new TextComponentTranslation("death.attack." + this.field_76373_n + ".player.player", new Object[]{player.func_145748_c_(), ((WrapperEntity)damage.attacker).entity.func_145748_c_(), recentEntity.func_145748_c_()});
                    }
                    return new TextComponentTranslation("death.attack." + this.field_76373_n + ".null.player", new Object[]{player.func_145748_c_(), recentEntity.func_145748_c_()});
                }
                if (damage.attacker != null) {
                    return new TextComponentTranslation("death.attack." + this.field_76373_n + ".player.null", new Object[]{player.func_145748_c_(), ((WrapperEntity)damage.attacker).entity.func_145748_c_()});
                }
                return new TextComponentTranslation("death.attack." + this.field_76373_n + ".null.null", new Object[]{player.func_145748_c_()});
            }
        };
        if (damage.isFire) {
            newSource.func_76361_j();
            attackedEntity.func_70015_d(5);
        }
        if (damage.isWater) {
            attackedEntity.func_70066_B();
            return;
        }
        if (damage.isExplosion) {
            newSource.func_94540_d();
        }
        if (damage.ignoreArmor) {
            newSource.func_76348_h();
        }
        if (damage.ignoreCooldown && attackedEntity instanceof EntityLivingBase) {
            ((EntityLivingBase)attackedEntity).field_70172_ad = 0;
        }
        if (((Boolean)ConfigSystem.configObject.general.creativeDamage.value).booleanValue()) {
            newSource.func_76359_i();
        }
        attackedEntity.func_70097_a(newSource, (float)damage.amount);
    }
}

