/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.Map;
import mcinterface1122.BuilderItem;
import mcinterface1122.MasterInterface;
import mcinterface1122.WrapperItemStack;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;

class WrapperInventory
implements IWrapperInventory {
    final IInventory inventory;

    WrapperInventory(IInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public int getSize() {
        return this.inventory.func_70302_i_();
    }

    @Override
    public WrapperItemStack getStackInSlot(int slot) {
        return new WrapperItemStack(this.inventory.func_70301_a(slot));
    }

    @Override
    public AItemBase getItemInSlot(int slot) {
        Item item = this.inventory.func_70301_a(slot).func_77973_b();
        return item instanceof BuilderItem ? ((BuilderItem)item).item : null;
    }

    @Override
    public void decrementSlot(int slot) {
        this.inventory.func_70301_a(slot).func_190920_e(this.inventory.func_70301_a(slot).func_190916_E() - 1);
        this.inventory.func_70296_d();
    }

    @Override
    public boolean hasItem(AItemBase itemToFind) {
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack currentStack = this.inventory.func_70301_a(i);
            if (!((Object)((Object)BuilderItem.itemWrapperMap.get(itemToFind))).equals(currentStack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStack(IWrapperItemStack wrapperStack) {
        ItemStack stack = ((WrapperItemStack)wrapperStack).stack;
        if (stack.func_77951_h()) {
            int slot = -1;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                if (!this.inventory.func_70301_a(i).func_190926_b()) continue;
                slot = i;
                break;
            }
            if (slot >= 0) {
                this.inventory.func_70299_a(slot, stack.func_77946_l());
                stack.func_190920_e(0);
                this.inventory.func_70296_d();
                return true;
            }
        } else {
            ItemStack currentStack;
            int i;
            int amountRemaining = stack.func_190916_E();
            for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
                currentStack = this.inventory.func_70301_a(i);
                if (currentStack.func_190926_b()) {
                    this.inventory.func_70299_a(i, stack.func_77946_l());
                    stack.func_190920_e(0);
                    this.inventory.func_70296_d();
                    return true;
                }
                if (!currentStack.func_77969_a(stack) || !(currentStack.func_77942_o() ? currentStack.func_77978_p().equals((Object)stack.func_77978_p()) : !stack.func_77942_o())) continue;
                amountRemaining -= stack.func_77976_d() - currentStack.func_190916_E();
            }
            if (amountRemaining <= 0) {
                for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
                    currentStack = this.inventory.func_70301_a(i);
                    if (!currentStack.func_77969_a(stack) || !(currentStack.func_77942_o() ? currentStack.func_77978_p().equals((Object)stack.func_77978_p()) : !stack.func_77942_o())) continue;
                    currentStack.func_190920_e(currentStack.func_190916_E() + stack.func_77979_a(Math.min(currentStack.func_77976_d() - currentStack.func_190916_E(), stack.func_190916_E())).func_190916_E());
                    if (!stack.func_190926_b()) continue;
                    this.inventory.func_70296_d();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean addItem(AItemBase item, IWrapperNBT data) {
        WrapperItemStack stack = new WrapperItemStack(new ItemStack((Item)BuilderItem.itemWrapperMap.get(item)));
        if (data != null) {
            stack.setData(data);
        }
        return this.addStack(stack);
    }

    @Override
    public boolean removeStack(IWrapperItemStack stack, int qtyToRemove) {
        Item item = ((WrapperItemStack)stack).stack.func_77973_b();
        int meta = ((WrapperItemStack)stack).stack.func_77960_j();
        NBTTagCompound nbt = ((WrapperItemStack)stack).stack.func_77978_p();
        int qtyRemoved = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack currentStack = this.inventory.func_70301_a(i);
            if (!currentStack.func_77973_b().equals(item) || meta > -1 && currentStack.func_77960_j() != meta || nbt != null && !NBTUtil.func_181123_a((NBTBase)nbt, (NBTBase)currentStack.func_77978_p(), (boolean)true)) continue;
            int qtyRemovedFromStack = Math.min(qtyToRemove - qtyRemoved, currentStack.func_190916_E());
            qtyRemoved += qtyRemovedFromStack;
            if (qtyToRemove == 0) continue;
            currentStack.func_190918_g(qtyRemovedFromStack);
            if (currentStack.func_190926_b()) {
                this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                this.inventory.func_70296_d();
            }
            if (qtyRemoved != qtyToRemove) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeItem(AItemBase item, IWrapperNBT data) {
        WrapperItemStack stack = new WrapperItemStack(new ItemStack((Item)BuilderItem.itemWrapperMap.get(item)));
        if (data != null) {
            stack.setData(data);
        }
        return this.removeStack(stack, 1);
    }

    @Override
    public boolean hasMaterials(AItemPack<?> item, boolean includeMain, boolean includeSub) {
        for (IWrapperItemStack materialStack : MasterInterface.coreInterface.parseFromJSON(item, includeMain, includeSub)) {
            int requiredMaterialCount = materialStack.getSize();
            for (int i = 0; i < this.getSize(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((WrapperItemStack)materialStack).stack)) continue;
                requiredMaterialCount -= stack.func_190916_E();
            }
            if (requiredMaterialCount <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeMaterials(AItemPack<?> item, boolean includeMain, boolean includeSub) {
        for (IWrapperItemStack materialStack : MasterInterface.coreInterface.parseFromJSON(item, includeMain, includeSub)) {
            this.removeStack(materialStack, materialStack.getSize());
        }
        this.inventory.func_70296_d();
    }

    @Override
    public float getInventoryWeight(Map<String, Double> heavyItems) {
        float weight = 0.0f;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null) continue;
            double weightMultiplier = 1.0;
            for (String heavyItemName : heavyItems.keySet()) {
                if (!stack.func_77973_b().getRegistryName().toString().contains(heavyItemName)) continue;
                weightMultiplier = heavyItems.get(heavyItemName);
                break;
            }
            weight = (float)((double)weight + (double)(5.0f * (float)stack.func_190916_E() / (float)stack.func_77976_d()) * weightMultiplier);
        }
        return weight;
    }
}

