/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mcinterface1122.BuilderBlock;
import mcinterface1122.BuilderEntity;
import mcinterface1122.BuilderItem;
import mcinterface1122.BuilderTileEntity;
import mcinterface1122.WrapperBlock;
import mcinterface1122.WrapperEntity;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperTileEntity;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.IBlockTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

class WrapperWorld
implements IWrapperWorld {
    private static final Map<World, WrapperWorld> worldWrappers = new HashMap<World, WrapperWorld>();
    private final Map<Entity, WrapperEntity> entityWrappers = new HashMap<Entity, WrapperEntity>();
    private final Map<EntityPlayer, WrapperPlayer> playerWrappers = new HashMap<EntityPlayer, WrapperPlayer>();
    final World world;

    private WrapperWorld(World world) {
        this.world = world;
    }

    static WrapperWorld getWrapperFor(World world) {
        if (world != null) {
            if (!worldWrappers.containsKey(world)) {
                worldWrappers.put(world, new WrapperWorld(world));
            }
            return worldWrappers.get(world);
        }
        return null;
    }

    WrapperEntity getWrapperFor(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.getWrapperFor((EntityPlayer)entity);
        }
        if (entity != null) {
            WrapperEntity wrapper;
            if (!this.entityWrappers.containsKey(entity)) {
                this.entityWrappers.put(entity, new WrapperEntity(entity));
            }
            if (!(wrapper = this.entityWrappers.get(entity)).isValid() || !entity.equals((Object)wrapper.entity)) {
                wrapper = new WrapperEntity(entity);
                this.entityWrappers.put(entity, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    WrapperPlayer getWrapperFor(EntityPlayer player) {
        if (player != null) {
            WrapperPlayer wrapper;
            if (!this.playerWrappers.containsKey(player)) {
                this.playerWrappers.put(player, new WrapperPlayer(player));
            }
            if (!(wrapper = this.playerWrappers.get(player)).isValid() || !player.equals((Object)wrapper.player)) {
                wrapper = new WrapperPlayer(player);
                this.playerWrappers.put(player, wrapper);
            }
            return this.playerWrappers.get(player);
        }
        return null;
    }

    @Override
    public boolean isClient() {
        return this.world.field_72995_K;
    }

    @Override
    public int getDimensionID() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public long getTime() {
        return this.world.func_82737_E();
    }

    @Override
    public long getMaxHeight() {
        return this.world.func_72800_K();
    }

    @Override
    public IWrapperEntity getEntity(int id) {
        Entity entity = this.world.func_73045_a(id);
        return entity instanceof EntityPlayer ? this.getWrapperFor((EntityPlayer)entity) : this.getWrapperFor(entity);
    }

    @Override
    public List<IWrapperEntity> getEntitiesWithin(BoundingBox box) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        for (Entity entity : this.world.func_72872_a(Entity.class, WrapperWorld.convertBox(box))) {
            entities.add(this.getWrapperFor(entity));
        }
        return entities;
    }

    @Override
    public WrapperEntity getNearestHostile(IWrapperEntity entityLooking, int searchRadius) {
        double smallestDistance = searchRadius * 2;
        Entity foundEntity = null;
        Entity mcLooker = ((WrapperEntity)entityLooking).entity;
        Vec3d mcLookerPos = mcLooker.func_174791_d();
        for (Entity entity : this.world.func_72839_b(mcLooker, mcLooker.func_174813_aQ().func_186662_g((double)searchRadius))) {
            float distance = mcLooker.func_70032_d(entity);
            if (!((double)distance < smallestDistance) || !(entity instanceof IMob) || entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_70725_aQ != 0 || this.world.func_147447_a(mcLookerPos, entity.func_174791_d(), false, true, false) != null) continue;
            foundEntity = entity;
        }
        return foundEntity != null ? this.getWrapperFor(foundEntity) : null;
    }

    @Override
    public void spawnEntity(AEntityBase entity) {
        BuilderEntity builder = new BuilderEntity(this.world);
        builder.func_70080_a(entity.position.x, entity.position.y, entity.position.z, (float)(-entity.angles.y), (float)entity.angles.x);
        builder.entity = entity;
        BuilderEntity.createdServerBuilders.put(entity, builder);
        this.world.func_72838_d((Entity)builder);
    }

    @Override
    public Map<IWrapperEntity, BoundingBox> attackEntities(Damage damage, AEntityBase damageSource, Point3d motion) {
        List collidedEntities;
        AxisAlignedBB mcBox = WrapperWorld.convertBox(damage.box);
        ArrayList<Point3d> rayTraceHits = new ArrayList<Point3d>();
        if (motion != null) {
            mcBox = mcBox.func_72321_a(motion.x, motion.y, motion.z);
            collidedEntities = this.world.func_72872_a(Entity.class, mcBox);
            Vec3d start = new Vec3d(damage.box.globalCenter.x, damage.box.globalCenter.y, damage.box.globalCenter.z);
            Vec3d end = start.func_72441_c(motion.x, motion.y, motion.z);
            Iterator iterator = collidedEntities.iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                RayTraceResult rayTrace = entity.func_174813_aQ().func_72327_a(start, end);
                if (rayTrace == null) {
                    iterator.remove();
                    continue;
                }
                Point3d hitPoint = new Point3d(rayTrace.field_72307_f.field_72450_a, rayTrace.field_72307_f.field_72448_b, rayTrace.field_72307_f.field_72449_c);
                rayTraceHits.add(hitPoint);
            }
        } else {
            collidedEntities = this.world.func_72872_a(Entity.class, mcBox);
            rayTraceHits = null;
        }
        if (!collidedEntities.isEmpty()) {
            if (damageSource != null) {
                Iterator iterator = collidedEntities.iterator();
                while (iterator.hasNext()) {
                    AEntityBase testSource;
                    Entity entity = (Entity)iterator.next();
                    if (entity instanceof BuilderEntity) {
                        testSource = ((BuilderEntity)entity).entity;
                        if (!damageSource.equals(testSource)) continue;
                        iterator.remove();
                        continue;
                    }
                    if (!(entity.func_184187_bx() instanceof BuilderEntity) || !damageSource.equals(testSource = ((BuilderEntity)entity.func_184187_bx()).entity)) continue;
                    iterator.remove();
                }
            }
            if (!this.isClient()) {
                for (Entity entity : collidedEntities) {
                    WrapperEntity.attack(entity, damage);
                }
            }
        }
        if (this.isClient()) {
            HashMap<IWrapperEntity, BoundingBox> entities = new HashMap<IWrapperEntity, BoundingBox>();
            block3: for (Entity entity : collidedEntities) {
                if (entity instanceof BuilderEntity) {
                    for (BoundingBox box : ((BuilderEntity)entity).entity.interactionBoxes) {
                        if (motion == null) {
                            if (!box.intersects(damage.box)) continue;
                            entities.put(this.getWrapperFor(entity), box);
                            continue block3;
                        }
                        if (!box.isPointInside((Point3d)rayTraceHits.get(collidedEntities.indexOf(entity)))) continue;
                        entities.put(this.getWrapperFor(entity), box);
                        continue block3;
                    }
                    continue;
                }
                entities.put(this.getWrapperFor(entity), null);
            }
            return entities;
        }
        return null;
    }

    @Override
    public void moveEntities(List<BoundingBox> boxesToCheck, Point3d intialPosition, Point3d initalRotation, Point3d linearMovement, Point3d angularMovement) {
        ArrayList<Entity> movedEntities = new ArrayList<Entity>();
        for (BoundingBox box : boxesToCheck) {
            for (Entity entity : this.world.func_72872_a(Entity.class, WrapperWorld.convertBox(box).func_72321_a(0.0, 0.25, 0.0))) {
                if (movedEntities.contains(entity) || entity instanceof BuilderEntity || entity.func_184187_bx() != null) continue;
                AxisAlignedBB entityBox = entity.func_174813_aQ();
                double entityBottomDelta = box.globalCenter.y + box.heightRadius - entityBox.field_72338_b;
                if (!(entityBottomDelta >= -0.5) || !(entityBottomDelta <= 0.5) || !(entity.field_70181_x < 0.0) && !(entity.field_70181_x < entityBottomDelta)) continue;
                Point3d entityDeltaOffset = new Point3d(entity.field_70165_t - intialPosition.x, entity.field_70163_u - intialPosition.y, entity.field_70161_v - intialPosition.z);
                Point3d vehicleBoxMovement = entityDeltaOffset.copy().rotateFine(angularMovement).subtract(entityDeltaOffset).add(linearMovement);
                entity.func_70091_d(MoverType.SELF, vehicleBoxMovement.x, vehicleBoxMovement.y + entityBottomDelta, vehicleBoxMovement.z);
                movedEntities.add(entity);
                entity.field_70122_E = true;
            }
        }
    }

    @Override
    public void loadEntities(BoundingBox box, AEntityBase vehicle) {
        block0: for (Entity entity : this.world.func_72839_b((Entity)BuilderEntity.createdServerBuilders.get(vehicle), WrapperWorld.convertBox(box))) {
            if (!(entity instanceof INpc) && !(entity instanceof IAnimals) || entity instanceof IMob) continue;
            for (Point3d ridableLocation : vehicle.ridableLocations) {
                if (vehicle.locationRiderMap.containsKey((Object)ridableLocation) || vehicle instanceof EntityVehicleF_Physics && ((EntityVehicleF_Physics)vehicle).getPartAtLocation((Point3d)ridableLocation).vehicleDefinition.isController) continue;
                vehicle.addRider(new WrapperEntity(entity), ridableLocation);
                continue block0;
            }
        }
    }

    @Override
    public WrapperBlock getWrapperBlock(Point3i point) {
        return this.isAir(point) ? null : new WrapperBlock(this.world, new BlockPos(point.x, point.y, point.z));
    }

    @Override
    public ABlockBase getBlock(Point3i point) {
        Block block = this.world.func_180495_p(new BlockPos(point.x, point.y, point.z)).func_177230_c();
        return block instanceof BuilderBlock ? ((BuilderBlock)block).block : null;
    }

    @Override
    public float getBlockRotation(Point3i point) {
        return ((EnumFacing)this.world.func_180495_p(new BlockPos(point.x, point.y, point.z)).func_177229_b((IProperty)BuilderBlock.FACING)).func_185119_l();
    }

    @Override
    public boolean isBlockSolid(Point3i point) {
        IBlockState offsetMCState = this.world.func_180495_p(new BlockPos(point.x, point.y, point.z));
        Block offsetMCBlock = offsetMCState.func_177230_c();
        return offsetMCBlock != null ? !offsetMCBlock.equals(Blocks.field_180401_cv) && offsetMCState.func_185904_a().func_76218_k() && offsetMCState.func_185917_h() && offsetMCState.func_185904_a() != Material.field_151572_C : false;
    }

    @Override
    public boolean isBlockLiquid(Point3i point) {
        IBlockState offsetMCState = this.world.func_180495_p(new BlockPos(point.x, point.y, point.z));
        return offsetMCState.func_185904_a().func_76224_d();
    }

    @Override
    public boolean isBlockBottomSlab(Point3i point) {
        IBlockState state = this.world.func_180495_p(new BlockPos(point.x, point.y, point.z));
        Block block = state.func_177230_c();
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
    }

    @Override
    public boolean isBlockTopSlab(Point3i point) {
        IBlockState state = this.world.func_180495_p(new BlockPos(point.x, point.y, point.z));
        Block block = state.func_177230_c();
        return block instanceof BlockSlab && !((BlockSlab)block).func_176552_j() && state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
    }

    @Override
    public void updateBoundingBoxCollisions(BoundingBox box, Point3d collisionMotion, boolean ignoreIfGreater) {
        AxisAlignedBB mcBox = WrapperWorld.convertBox(box);
        box.collidingBlocks.clear();
        ArrayList<AxisAlignedBB> collidingAABBs = new ArrayList<AxisAlignedBB>();
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (this.world.func_175667_e(pos)) {
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_177230_c().func_176209_a(state, false) && state.func_185890_d((IBlockAccess)this.world, pos) != null) {
                            int oldCollidingBlockCount = collidingAABBs.size();
                            state.func_185908_a(this.world, pos, mcBox, collidingAABBs, null, false);
                            if (collidingAABBs.size() > oldCollidingBlockCount) {
                                box.collidingBlocks.add(new WrapperBlock(this.world, pos));
                            }
                        }
                        if (box.collidesWithLiquids && state.func_185904_a().func_76224_d()) {
                            collidingAABBs.add(state.func_185900_c((IBlockAccess)this.world, pos).func_186670_a(pos));
                            box.collidingBlocks.add(new WrapperBlock(this.world, pos));
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        box.currentCollisionDepth.set(0.0, 0.0, 0.0);
        for (AxisAlignedBB colBox : collidingAABBs) {
            double boxCollisionDepth;
            if (collisionMotion.x > 0.0) {
                boxCollisionDepth = mcBox.field_72336_d - colBox.field_72340_a;
                if (!ignoreIfGreater || collisionMotion.x - boxCollisionDepth > 0.0) {
                    box.currentCollisionDepth.x = Math.max(box.currentCollisionDepth.x, boxCollisionDepth);
                }
            } else if (collisionMotion.x < 0.0) {
                boxCollisionDepth = colBox.field_72336_d - mcBox.field_72340_a;
                if (!ignoreIfGreater || collisionMotion.x + boxCollisionDepth < 0.0) {
                    box.currentCollisionDepth.x = Math.max(box.currentCollisionDepth.x, boxCollisionDepth);
                }
            }
            if (collisionMotion.y > 0.0) {
                boxCollisionDepth = mcBox.field_72337_e - colBox.field_72338_b;
                if (!ignoreIfGreater || collisionMotion.y - boxCollisionDepth > 0.0) {
                    box.currentCollisionDepth.y = Math.max(box.currentCollisionDepth.y, boxCollisionDepth);
                }
            } else if (collisionMotion.y < 0.0) {
                boxCollisionDepth = colBox.field_72337_e - mcBox.field_72338_b;
                if (!ignoreIfGreater || collisionMotion.y + boxCollisionDepth < 0.0) {
                    box.currentCollisionDepth.y = Math.max(box.currentCollisionDepth.y, boxCollisionDepth);
                }
            }
            if (collisionMotion.z > 0.0) {
                boxCollisionDepth = colBox.field_72334_f - mcBox.field_72339_c;
                if (ignoreIfGreater && !(collisionMotion.z - boxCollisionDepth > 0.0)) continue;
                box.currentCollisionDepth.z = Math.max(box.currentCollisionDepth.z, boxCollisionDepth);
                continue;
            }
            if (!(collisionMotion.z < 0.0)) continue;
            boxCollisionDepth = colBox.field_72334_f - mcBox.field_72339_c;
            if (ignoreIfGreater && !(collisionMotion.z + boxCollisionDepth < 0.0)) continue;
            box.currentCollisionDepth.z = Math.max(box.currentCollisionDepth.z, boxCollisionDepth);
        }
    }

    @Override
    public int getRedstonePower(Point3i point) {
        return this.world.func_175676_y(new BlockPos(point.x, point.y, point.z));
    }

    @Override
    public float getRainStrength(Point3i point) {
        return this.world.func_175727_C(new BlockPos(point.x, point.y, point.z)) ? this.world.func_72867_j(1.0f) + this.world.func_72819_i(1.0f) : 0.0f;
    }

    @Override
    public float getTemperature(Point3i point) {
        BlockPos pos = new BlockPos(point.x, point.y, point.z);
        return this.world.func_180494_b(pos).func_180626_a(pos);
    }

    @Override
    public <TileEntityType extends ATileEntityBase<JSONDefinition>, JSONDefinition extends AJSONItem<?>> boolean setBlock(ABlockBase block, Point3i location, IWrapperPlayer playerWrapper, ABlockBase.Axis axis) {
        if (!this.world.field_72995_K) {
            BuilderBlock wrapper = BuilderBlock.blockWrapperMap.get(block);
            WrapperPlayer player = (WrapperPlayer)playerWrapper;
            WrapperItemStack stack = (WrapperItemStack)((WrapperPlayer)playerWrapper).getHeldStack();
            BlockPos pos = new BlockPos(location.x, location.y, location.z);
            EnumFacing facing = EnumFacing.valueOf((String)axis.name());
            if (!this.world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.world, pos)) {
                pos = pos.func_177972_a(facing);
                location.add(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
            }
            if (stack.getItem() != null && player.player.func_175151_a(pos, facing, stack.stack) && this.world.func_190527_a((Block)wrapper, pos, false, facing, null)) {
                IBlockState newState = wrapper.getStateForPlacement(this.world, pos, facing, 0.0f, 0.0f, 0.0f, 0, (EntityLivingBase)player.player, EnumHand.MAIN_HAND);
                if (this.world.func_180501_a(pos, newState, 11)) {
                    if (block instanceof IBlockTileEntity) {
                        WrapperNBT data;
                        BuilderTileEntity builderTile = (BuilderTileEntity)this.world.func_175625_s(pos);
                        if (stack.stack.func_77942_o()) {
                            data = new WrapperNBT(stack.stack.func_77978_p());
                        } else {
                            data = new WrapperNBT(new NBTTagCompound());
                            if (stack.getItem() instanceof AItemPack) {
                                data.setString("packID", ((AJSONItem)((AItemPack)stack.getItem()).definition).packID);
                                data.setString("systemName", ((AJSONItem)((AItemPack)stack.getItem()).definition).systemName);
                            }
                        }
                        builderTile.tileEntity = ((IBlockTileEntity)((Object)block)).createTileEntity(this, new Point3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), data);
                    }
                    block.onPlaced(this, location, player);
                    stack.stack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public WrapperTileEntity getWrapperTileEntity(Point3i position) {
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z));
        return tile != null ? new WrapperTileEntity(tile) : null;
    }

    @Override
    public <TileEntityType extends ATileEntityBase<?>> TileEntityType getTileEntity(Point3i point) {
        TileEntity tile = this.world.func_175625_s(new BlockPos(point.x, point.y, point.z));
        return tile instanceof BuilderTileEntity ? (TileEntityType)((BuilderTileEntity)tile).tileEntity : null;
    }

    @Override
    public void markTileEntityChanged(Point3i point) {
        this.world.func_175625_s(new BlockPos(point.x, point.y, point.z)).func_70296_d();
    }

    @Override
    public float getLightBrightness(Point3i point, boolean calculateBlock) {
        BlockPos pos = new BlockPos(point.x, point.y, point.z);
        float sunLight = this.world.func_72971_b(0.0f) * (float)(this.world.func_175642_b(EnumSkyBlock.SKY, pos) - this.world.func_175657_ab()) / 15.0f;
        float blockLight = calculateBlock ? (float)this.world.func_175705_a(EnumSkyBlock.BLOCK, pos) / 15.0f : 0.0f;
        return Math.max(sunLight, blockLight);
    }

    @Override
    public void updateLightBrightness(Point3i point) {
        Object tile = this.getTileEntity(point);
        if (tile != null) {
            BlockPos pos = new BlockPos(point.x, point.y, point.z);
            this.world.func_175664_x(pos);
        }
    }

    @Override
    public void destroyBlock(Point3i point) {
        this.world.func_175655_b(new BlockPos(point.x, point.y, point.z), true);
    }

    @Override
    public boolean isAir(Point3i point) {
        BlockPos pos = new BlockPos(point.x, point.y, point.z);
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block.isAir(state, (IBlockAccess)this.world, pos);
    }

    @Override
    public boolean isFire(Point3i point) {
        BlockPos pos = new BlockPos(point.x, point.y, point.z);
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_185904_a().equals(Material.field_151581_o);
    }

    @Override
    public void setToFire(Point3i point) {
        this.world.func_175656_a(new BlockPos(point.x, point.y, point.z), Blocks.field_150480_ab.func_176223_P());
    }

    @Override
    public boolean fertilizeBlock(Point3i point, IWrapperItemStack wrapperStack) {
        IGrowable growable;
        BlockPos cropPos;
        IBlockState cropState;
        Block cropBlock;
        ItemStack stack = ((WrapperItemStack)wrapperStack).stack;
        if (stack.func_77973_b().equals(Items.field_151100_aR) && !this.world.field_72995_K && (cropBlock = (cropState = this.world.func_180495_p(cropPos = new BlockPos(point.x, point.y, point.z))).func_177230_c()) instanceof IGrowable && (growable = (IGrowable)cropState.func_177230_c()).func_176473_a(this.world, cropPos, cropState, this.world.field_72995_K)) {
            ItemDye.func_179234_a((ItemStack)stack.func_77946_l(), (World)this.world, (BlockPos)cropPos);
            return true;
        }
        return false;
    }

    @Override
    public List<IWrapperItemStack> harvestBlock(Point3i point) {
        BlockPos pos = new BlockPos(point.x, point.y, point.z);
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockCrops && ((BlockCrops)state.func_177230_c()).func_185525_y(state) || state.func_177230_c() instanceof BlockBush) {
            Block harvestedBlock = state.func_177230_c();
            NonNullList drops = NonNullList.func_191196_a();
            ArrayList<IWrapperItemStack> cropDrops = new ArrayList<IWrapperItemStack>();
            this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), harvestedBlock.getSoundType(state, this.world, pos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            if (!this.world.field_72995_K) {
                harvestedBlock.getDrops(drops, (IBlockAccess)this.world, pos, state, 0);
                this.world.func_175698_g(pos);
                if (harvestedBlock instanceof BlockCrops) {
                    for (ItemStack drop : drops) {
                        cropDrops.add(new WrapperItemStack(drop));
                    }
                } else {
                    for (ItemStack stack : drops) {
                        if (stack.func_190916_E() <= 0) continue;
                        this.world.func_72838_d((Entity)new EntityItem(this.world, (double)point.x, (double)point.y, (double)point.z, stack));
                    }
                }
            }
            return cropDrops;
        }
        return null;
    }

    @Override
    public boolean plantBlock(Point3i point, IWrapperItemStack stack) {
        Item item = ((WrapperItemStack)stack).stack.func_77973_b();
        if (item instanceof IPlantable) {
            IBlockState plantState;
            BlockPos cropPos;
            IPlantable plantable = (IPlantable)item;
            BlockPos farmlandPos = new BlockPos(point.x, point.y, point.z);
            IBlockState farmlandState = this.world.func_180495_p(farmlandPos);
            Block farmlandBlock = farmlandState.func_177230_c();
            if (farmlandBlock.equals(Blocks.field_150458_ak) && this.world.func_175623_d(cropPos = farmlandPos.func_177984_a()) && farmlandBlock.canSustainPlant(plantState = plantable.getPlant((IBlockAccess)this.world, cropPos), (IBlockAccess)this.world, farmlandPos, EnumFacing.UP, plantable)) {
                this.world.func_180501_a(cropPos, plantState, 11);
                this.world.func_184134_a((double)farmlandPos.func_177958_n(), (double)farmlandPos.func_177956_o(), (double)farmlandPos.func_177952_p(), plantState.func_177230_c().getSoundType(plantState, this.world, farmlandPos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean plowBlock(Point3i point) {
        IBlockState newState;
        BlockPos pos;
        block5: {
            block6: {
                Block block;
                IBlockState oldState;
                block4: {
                    pos = new BlockPos(point.x, point.y, point.z);
                    oldState = this.world.func_180495_p(pos);
                    newState = null;
                    block = oldState.func_177230_c();
                    if (!block.equals(Blocks.field_150349_c) && !block.equals(Blocks.field_185774_da)) break block4;
                    newState = Blocks.field_150458_ak.func_176223_P();
                    break block5;
                }
                if (!block.equals(Blocks.field_150346_d)) break block6;
                switch ((BlockDirt.DirtType)oldState.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        newState = Blocks.field_150458_ak.func_176223_P();
                        break block5;
                    }
                    case COARSE_DIRT: {
                        newState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
                        break block5;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        this.world.func_180501_a(pos, newState, 11);
        this.world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        return true;
    }

    @Override
    public void spawnItem(AItemBase item, IWrapperNBT data, Point3d point) {
        ItemStack stack = new ItemStack((Item)BuilderItem.itemWrapperMap.get(item));
        if (data != null) {
            stack.func_77982_d(((WrapperNBT)data).tag);
        }
        this.world.func_72838_d((Entity)new EntityItem(this.world, point.x, point.y, point.z, stack));
    }

    @Override
    public void spawnItemStack(IWrapperItemStack stack, Point3d point) {
        this.world.func_72838_d((Entity)new EntityItem(this.world, point.x, point.y, point.z, ((WrapperItemStack)stack).stack));
    }

    @Override
    public void spawnExplosion(AEntityBase source, Point3d location, double strength, boolean flames) {
        this.world.func_72885_a((Entity)BuilderEntity.createdServerBuilders.get(source), location.x, location.y, location.z, (float)strength, flames, true);
    }

    @Override
    public void spawnExplosion(IWrapperPlayer player, Point3d location, double strength, boolean flames) {
        this.world.func_72885_a((Entity)((WrapperPlayer)player).player, location.x, location.y, location.z, (float)strength, flames, true);
    }

    private static AxisAlignedBB convertBox(BoundingBox box) {
        return new AxisAlignedBB(box.globalCenter.x - box.widthRadius, box.globalCenter.y - box.heightRadius, box.globalCenter.z - box.depthRadius, box.globalCenter.x + box.widthRadius, box.globalCenter.y + box.heightRadius, box.globalCenter.z + box.depthRadius);
    }
}

