/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.mcinterface.IWrapperBlock;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.vehicles.main.AEntityBase;

public class BoundingBox {
    public final Point3d localCenter;
    public final Point3d globalCenter;
    public final Point3d currentCollisionDepth;
    public final List<IWrapperBlock> collidingBlocks = new ArrayList<IWrapperBlock>();
    private final Point3d tempGlobalCenter;
    public double widthRadius;
    public double heightRadius;
    public double depthRadius;
    public final boolean collidesWithLiquids;
    public final boolean isInterior;
    public final boolean isCollision;
    public final double armorThickness;

    public BoundingBox(Point3d center, double widthRadius, double heightRadius, double depthRadius) {
        this(center, center, widthRadius, heightRadius, depthRadius, false, false, false, 0.0);
    }

    public BoundingBox(Point3d localCenter, Point3d globalCenter, double widthRadius, double heightRadius, double depthRadius, boolean collidesWithLiquids, boolean isInterior, boolean isCollision, double armorThickness) {
        this.localCenter = localCenter;
        this.globalCenter = globalCenter;
        this.tempGlobalCenter = globalCenter.copy();
        this.currentCollisionDepth = new Point3d(0.0, 0.0, 0.0);
        this.widthRadius = widthRadius;
        this.heightRadius = heightRadius;
        this.depthRadius = depthRadius;
        this.collidesWithLiquids = collidesWithLiquids;
        this.isInterior = isInterior;
        this.isCollision = isCollision;
        this.armorThickness = armorThickness;
    }

    public boolean updateCollidingBlocks(IWrapperWorld world, Point3d offset) {
        return this.updateCollisions(world, offset, false);
    }

    public boolean updateMovingCollisions(IWrapperWorld world, Point3d offset) {
        return this.updateCollisions(world, offset, true);
    }

    private boolean updateCollisions(IWrapperWorld world, Point3d offset, boolean ignoreIfGreater) {
        this.tempGlobalCenter.setTo(this.globalCenter);
        this.globalCenter.add(offset);
        world.updateBoundingBoxCollisions(this, offset, ignoreIfGreater);
        this.globalCenter.setTo(this.tempGlobalCenter);
        return !this.collidingBlocks.isEmpty();
    }

    public void updateToEntity(AEntityBase entity) {
        this.globalCenter.setTo(this.localCenter).rotateFine(entity.angles).add(entity.position);
        if (this.isCollision) {
            this.globalCenter.x = (double)((int)(this.globalCenter.x * 10.0)) / 10.0;
            this.globalCenter.y = (double)((int)(this.globalCenter.y * 10.0)) / 10.0;
            this.globalCenter.z = (double)((int)(this.globalCenter.z * 10.0)) / 10.0;
        }
    }

    public boolean isPointInside(Point3d point) {
        return this.globalCenter.x - this.widthRadius <= point.x && this.globalCenter.x + this.widthRadius >= point.x && this.globalCenter.y - this.heightRadius <= point.y && this.globalCenter.y + this.heightRadius >= point.y && this.globalCenter.z - this.depthRadius <= point.z && this.globalCenter.z + this.depthRadius >= point.z;
    }

    public boolean intersects(BoundingBox box) {
        return this.globalCenter.x - this.widthRadius < box.globalCenter.x + box.widthRadius && this.globalCenter.x + this.widthRadius > box.globalCenter.x - box.widthRadius && this.globalCenter.y - this.heightRadius < box.globalCenter.y + box.heightRadius && this.globalCenter.y + this.heightRadius > box.globalCenter.y - box.heightRadius && this.globalCenter.z - this.depthRadius < box.globalCenter.z + box.depthRadius && this.globalCenter.z + this.depthRadius > box.globalCenter.z - box.depthRadius;
    }

    public boolean intersectsWithYZ(Point3d point) {
        return point.y >= this.globalCenter.y - this.heightRadius && point.y <= this.globalCenter.y + this.heightRadius && point.z >= this.globalCenter.z - this.depthRadius && point.z <= this.globalCenter.z + this.depthRadius;
    }

    public boolean intersectsWithXZ(Point3d point) {
        return point.x >= this.globalCenter.x - this.widthRadius && point.x <= this.globalCenter.x + this.widthRadius && point.z >= this.globalCenter.z - this.depthRadius && point.z <= this.globalCenter.z + this.depthRadius;
    }

    public boolean intersectsWithXY(Point3d point) {
        return point.x >= this.globalCenter.x - this.widthRadius && point.x <= this.globalCenter.x + this.widthRadius && point.y >= this.globalCenter.y - this.heightRadius && point.y <= this.globalCenter.y + this.heightRadius;
    }

    public Point3d getXPlaneCollision(Point3d start, Point3d end, double xPoint) {
        Point3d collisionPoint = start.getIntermediateWithXValue(end, xPoint);
        return collisionPoint != null && this.intersectsWithYZ(collisionPoint) ? collisionPoint : null;
    }

    public Point3d getYPlaneCollision(Point3d start, Point3d end, double yPoint) {
        Point3d collisionPoint = start.getIntermediateWithYValue(end, yPoint);
        return collisionPoint != null && this.intersectsWithXZ(collisionPoint) ? collisionPoint : null;
    }

    public Point3d getZPlaneCollision(Point3d start, Point3d end, double zPoint) {
        Point3d collisionPoint = start.getIntermediateWithZValue(end, zPoint);
        return collisionPoint != null && this.intersectsWithXY(collisionPoint) ? collisionPoint : null;
    }

    public Point3d getIntersectionPoint(Point3d start, Point3d end) {
        Point3d intersection = this.getXPlaneCollision(start, end, this.globalCenter.x - this.widthRadius);
        Point3d secondIntersection = this.getXPlaneCollision(start, end, this.globalCenter.x + this.widthRadius);
        if (secondIntersection != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getYPlaneCollision(start, end, this.globalCenter.y - this.heightRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getYPlaneCollision(start, end, this.globalCenter.y + this.heightRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getZPlaneCollision(start, end, this.globalCenter.z - this.depthRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        if ((secondIntersection = this.getZPlaneCollision(start, end, this.globalCenter.z + this.depthRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
        }
        return intersection;
    }
}

