/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketFluidTankChange;
import minecrafttransportsimulator.systems.ConfigSystem;

public class FluidTank {
    public static final Map<Integer, FluidTank> createdClientTanks = new HashMap<Integer, FluidTank>();
    public static final Map<Integer, FluidTank> createdServerTanks = new HashMap<Integer, FluidTank>();
    private static int idCounter = 1;
    public final int tankID;
    private final int maxLevel;
    private final boolean onClient;
    private String currentFluid;
    private double fluidLevel;
    private double fluidDispensed;

    public FluidTank(IWrapperNBT data, int maxLevel, boolean onClient) {
        int n;
        if (onClient) {
            n = data.getInteger("tankID");
        } else {
            int n2 = idCounter;
            n = n2;
            idCounter = n2 + 1;
        }
        this.tankID = n;
        this.maxLevel = maxLevel;
        this.onClient = onClient;
        this.currentFluid = data.getString("currentFluid");
        this.fluidLevel = data.getDouble("fluidLevel");
        this.fluidDispensed = data.getDouble("fluidDispensed");
        if (onClient) {
            createdClientTanks.put(this.tankID, this);
        } else {
            createdServerTanks.put(this.tankID, this);
        }
    }

    public double getFluidLevel() {
        return this.fluidLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getAmountDispensed() {
        return this.fluidDispensed;
    }

    public void resetAmountDispensed() {
        this.fluidDispensed = 0.0;
    }

    public String getFluid() {
        return this.currentFluid;
    }

    public void manuallySet(String fluidName, double fluidLevel) {
        this.currentFluid = fluidName;
        this.fluidLevel = fluidLevel;
    }

    public double fill(String fluid, double maxAmount, boolean doFill) {
        if (this.currentFluid.isEmpty() || this.currentFluid.equals(fluid)) {
            if (maxAmount >= (double)this.getMaxLevel() - this.fluidLevel) {
                maxAmount = (double)this.getMaxLevel() - this.fluidLevel;
            }
            if (doFill) {
                this.fluidLevel += maxAmount;
                if (this.currentFluid.isEmpty()) {
                    this.currentFluid = fluid;
                }
                if (!this.onClient) {
                    MasterLoader.networkInterface.sendToAllClients(new PacketFluidTankChange(this, maxAmount));
                }
            }
            return maxAmount;
        }
        return 0.0;
    }

    public double drain(String fluid, double maxAmount, boolean doDrain) {
        if (!this.currentFluid.isEmpty() && (this.currentFluid.equals(fluid) || fluid.isEmpty())) {
            if (maxAmount >= this.fluidLevel) {
                maxAmount = this.fluidLevel;
            }
            if (doDrain) {
                if (!this.onClient) {
                    MasterLoader.networkInterface.sendToAllClients(new PacketFluidTankChange(this, -maxAmount));
                }
                this.fluidLevel -= maxAmount;
                this.fluidDispensed += maxAmount;
                if (this.fluidLevel == 0.0) {
                    this.currentFluid = "";
                }
            }
            return maxAmount;
        }
        return 0.0;
    }

    public double getExplosiveness() {
        for (Map<String, Double> fuelEntry : ConfigSystem.configObject.fuel.fuels.values()) {
            if (!fuelEntry.containsKey(this.currentFluid)) continue;
            return this.fluidLevel * fuelEntry.get(this.currentFluid) / 10000.0;
        }
        return 0.0;
    }

    public double getWeight() {
        return this.fluidLevel / 50.0;
    }

    public void save(IWrapperNBT data) {
        data.setInteger("tankID", this.tankID);
        data.setString("currentFluid", this.currentFluid);
        data.setDouble("fluidLevel", this.fluidLevel);
        data.setDouble("fluidDispensed", this.fluidDispensed);
    }
}

