/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import minecrafttransportsimulator.baseclasses.Point3i;

public class Point3d {
    private static final Point3d ZERO = new Point3d(0.0, 0.0, 0.0);
    public double x;
    public double y;
    public double z;
    private static final double[] sinTable = new double[361];
    private static final double[] cosTable = new double[361];
    public static final TypeAdapter<Point3d> adapter = new TypeAdapter<Point3d>(){

        public Point3d read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            reader.beginArray();
            Point3d point = new Point3d(reader.nextDouble(), reader.nextDouble(), reader.nextDouble());
            reader.endArray();
            return point;
        }

        public void write(JsonWriter writer, Point3d point) throws IOException {
            if (point == null) {
                writer.nullValue();
                return;
            }
            writer.beginArray();
            writer.setIndent("");
            writer.value(point.x);
            writer.value(point.y);
            writer.value(point.z);
            writer.endArray();
            writer.setIndent("  ");
        }
    };

    public Point3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3d(Point3i point) {
        this(point.x, point.y, point.z);
    }

    public boolean equals(Object object) {
        if (object instanceof Point3d) {
            Point3d otherPoint = (Point3d)object;
            return (float)this.x == (float)otherPoint.x && (float)this.y == (float)otherPoint.y && (float)this.z == (float)otherPoint.z;
        }
        return false;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Point3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Point3d setTo(Point3d point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
        return this;
    }

    public Point3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Point3d add(Point3d point) {
        this.x += point.x;
        this.y += point.y;
        this.z += point.z;
        return this;
    }

    public Point3d subtract(Point3d point) {
        this.x -= point.x;
        this.y -= point.y;
        this.z -= point.z;
        return this;
    }

    public Point3d multiply(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Point3d multiply(Point3d point) {
        this.x *= point.x;
        this.y *= point.y;
        this.z *= point.z;
        return this;
    }

    public double distanceTo(Point3d point) {
        double deltaX = point.x - this.x;
        double deltaY = point.y - this.y;
        double deltaZ = point.z - this.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public double distanceTo(Point3i point) {
        double deltaX = (double)point.x - this.x;
        double deltaY = (double)point.y - this.y;
        double deltaZ = (double)point.z - this.z;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public double dotProduct(Point3d point) {
        return this.x * point.x + this.y * point.y + this.z * point.z;
    }

    public Point3d crossProduct(Point3d point) {
        return new Point3d(this.y * point.z - this.z * point.y, this.z * point.x - this.x * point.z, this.x * point.y - this.y * point.x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Point3d normalize() {
        double length = this.length();
        if (length > 1.0E-4) {
            this.x /= length;
            this.y /= length;
            this.z /= length;
        }
        return this;
    }

    public Point3d copy() {
        return new Point3d(this.x, this.y, this.z);
    }

    public boolean isZero() {
        return this.equals(ZERO);
    }

    public Point3d getIntermediateWithXValue(Point3d endPoint, double targetX) {
        Point3d delta = endPoint.copy().subtract(this);
        if (delta.x * delta.x < 1.0E-7) {
            return null;
        }
        double factor = (targetX - this.x) / delta.x;
        return factor >= 0.0 && factor <= 1.0 ? delta.multiply(factor).add(this) : null;
    }

    public Point3d getIntermediateWithYValue(Point3d endPoint, double targetY) {
        Point3d delta = endPoint.copy().subtract(this);
        if (delta.y * delta.y < 1.0E-7) {
            return null;
        }
        double factor = (targetY - this.y) / delta.y;
        return factor >= 0.0 && factor <= 1.0 ? delta.multiply(factor).add(this) : null;
    }

    public Point3d getIntermediateWithZValue(Point3d endPoint, double targetZ) {
        Point3d delta = endPoint.copy().subtract(this);
        if (delta.z * delta.z < 1.0E-7) {
            return null;
        }
        double factor = (targetZ - this.z) / delta.z;
        return factor >= 0.0 && factor <= 1.0 ? delta.multiply(factor).add(this) : null;
    }

    public Point3d rotateCoarse(Point3d angles) {
        if (cosTable[0] == 0.0) {
            for (int i = 0; i <= 360; ++i) {
                Point3d.sinTable[i] = Math.sin(Math.toRadians(i));
                Point3d.cosTable[i] = Math.cos(Math.toRadians(i));
            }
        }
        double xRot = (angles.x % 360.0 + 360.0) % 360.0;
        double yRot = (angles.y % 360.0 + 360.0) % 360.0;
        double zRot = (angles.z % 360.0 + 360.0) % 360.0;
        double cosX = cosTable[(int)xRot];
        double sinX = sinTable[(int)xRot];
        double cosY = cosTable[(int)yRot];
        double sinY = sinTable[(int)yRot];
        double cosZ = cosTable[(int)zRot];
        double sinZ = sinTable[(int)zRot];
        this.set(this.x * (cosY * cosZ - sinX * -sinY * sinZ) + this.y * (-sinX * -sinY * cosZ - cosY * sinZ) + this.z * (-cosX * -sinY), this.x * (cosX * sinZ) + this.y * (cosX * cosZ) + this.z * -sinX, this.x * (-sinY * cosZ + sinX * cosY * sinZ) + this.y * (sinX * cosY * cosZ + sinY * sinZ) + this.z * (cosX * cosY));
        return this;
    }

    public Point3d rotateFine(Point3d angles) {
        if (!angles.isZero()) {
            double cosX = Math.cos(Math.toRadians(angles.x));
            double sinX = Math.sin(Math.toRadians(angles.x));
            double cosY = Math.cos(Math.toRadians(angles.y));
            double sinY = Math.sin(Math.toRadians(angles.y));
            double cosZ = Math.cos(Math.toRadians(angles.z));
            double sinZ = Math.sin(Math.toRadians(angles.z));
            this.set(this.x * (cosY * cosZ - sinX * -sinY * sinZ) + this.y * (-sinX * -sinY * cosZ - cosY * sinZ) + this.z * (-cosX * -sinY), this.x * (cosX * sinZ) + this.y * (cosX * cosZ) + this.z * -sinX, this.x * (-sinY * cosZ + sinX * cosY * sinZ) + this.y * (sinX * cosY * cosZ + sinY * sinZ) + this.z * (cosX * cosY));
        }
        return this;
    }
}

