/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevice;

public class VehicleGroundDeviceBox {
    private final EntityVehicleF_Physics vehicle;
    private final boolean isFront;
    private final boolean isLeft;
    private final BoundingBox solidBox = new BoundingBox(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), 0.0, 0.0, 0.0, false, false, false, 0.0);
    private final BoundingBox liquidBox = new BoundingBox(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), 0.0, 0.0, 0.0, true, false, false, 0.0);
    private final List<BoundingBox> liquidCollisionBoxes = new ArrayList<BoundingBox>();
    private final List<PartGroundDevice> groundDevices = new ArrayList<PartGroundDevice>();
    private final List<PartGroundDevice> liquidDevices = new ArrayList<PartGroundDevice>();
    public boolean isCollided;
    public boolean isCollidedLiquid;
    public boolean isGrounded;
    public boolean isGroundedLiquid;
    public double collisionDepth;
    public final Point3d contactPoint = new Point3d(0.0, 0.0, 0.0);

    public VehicleGroundDeviceBox(EntityVehicleF_Physics vehicle, boolean isFront, boolean isLeft) {
        this.vehicle = vehicle;
        this.isFront = isFront;
        this.isLeft = isLeft;
        this.updateMembers();
        this.updateBounds();
        this.updateCollisionStatuses();
    }

    public void updateMembers() {
        this.liquidCollisionBoxes.clear();
        for (BoundingBox box : this.vehicle.blockCollisionBoxes) {
            if (!box.collidesWithLiquids) continue;
            if (this.isFront && box.localCenter.z > 0.0) {
                if (this.isLeft && box.localCenter.x >= 0.0) {
                    this.liquidCollisionBoxes.add(box);
                    continue;
                }
                if (this.isLeft || !(box.localCenter.x <= 0.0)) continue;
                this.liquidCollisionBoxes.add(box);
                continue;
            }
            if (this.isFront || !(box.localCenter.z <= 0.0)) continue;
            if (this.isLeft && box.localCenter.x >= 0.0) {
                this.liquidCollisionBoxes.add(box);
                continue;
            }
            if (this.isLeft || !(box.localCenter.x <= 0.0)) continue;
            this.liquidCollisionBoxes.add(box);
        }
        this.groundDevices.clear();
        this.liquidDevices.clear();
        for (APart part : this.vehicle.parts) {
            if (!(part instanceof PartGroundDevice)) continue;
            if (this.isFront && part.placementOffset.z > 0.0) {
                if (this.isLeft && part.placementOffset.x >= 0.0) {
                    this.groundDevices.add((PartGroundDevice)part);
                    if (!part.definition.ground.canFloat) continue;
                    this.liquidDevices.add((PartGroundDevice)part);
                    continue;
                }
                if (this.isLeft || !(part.placementOffset.x <= 0.0)) continue;
                this.groundDevices.add((PartGroundDevice)part);
                if (!part.definition.ground.canFloat) continue;
                this.liquidDevices.add((PartGroundDevice)part);
                continue;
            }
            if (this.isFront || !(part.placementOffset.z <= 0.0)) continue;
            if (this.isLeft && part.placementOffset.x >= 0.0) {
                this.groundDevices.add((PartGroundDevice)part);
                if (!part.definition.ground.canFloat) continue;
                this.liquidDevices.add((PartGroundDevice)part);
                continue;
            }
            if (this.isLeft || !(part.placementOffset.x <= 0.0)) continue;
            this.groundDevices.add((PartGroundDevice)part);
            if (!part.definition.ground.canFloat) continue;
            this.liquidDevices.add((PartGroundDevice)part);
        }
    }

    public void updateBounds() {
        this.solidBox.localCenter.set(0.0, 0.0, 0.0);
        this.solidBox.widthRadius = 0.0;
        this.solidBox.heightRadius = 0.0;
        for (APart aPart : this.groundDevices) {
            this.solidBox.localCenter.add(aPart.totalOffset);
            this.solidBox.widthRadius += (double)aPart.getWidth();
            this.solidBox.heightRadius += (double)aPart.getHeight();
        }
        this.solidBox.widthRadius /= 2.0 * (double)this.groundDevices.size();
        this.solidBox.heightRadius /= 2.0 * (double)this.groundDevices.size();
        this.solidBox.depthRadius = this.solidBox.widthRadius;
        this.solidBox.localCenter.multiply(1.0 / (double)this.groundDevices.size());
        this.liquidBox.localCenter.set(0.0, 0.0, 0.0);
        this.liquidBox.widthRadius = 0.0;
        this.liquidBox.heightRadius = 0.0;
        for (APart aPart : this.liquidDevices) {
            this.liquidBox.localCenter.add(aPart.totalOffset);
            this.liquidBox.widthRadius += (double)aPart.getWidth();
            this.liquidBox.heightRadius += (double)aPart.getHeight();
        }
        for (BoundingBox boundingBox : this.liquidCollisionBoxes) {
            this.liquidBox.localCenter.add(boundingBox.localCenter);
            this.liquidBox.widthRadius += boundingBox.widthRadius * 2.0;
            this.liquidBox.heightRadius += boundingBox.heightRadius * 2.0;
        }
        this.liquidBox.widthRadius /= 2.0 * (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size());
        this.liquidBox.heightRadius /= 2.0 * (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size());
        this.liquidBox.depthRadius = this.solidBox.widthRadius;
        this.liquidBox.localCenter.multiply(1.0 / (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size()));
    }

    public void updateCollisionStatuses() {
        this.isCollided = false;
        this.isGrounded = false;
        this.collisionDepth = 0.0;
        Point3d vehicleMotionOffset = this.vehicle.motion.copy().multiply(this.vehicle.SPEED_FACTOR);
        Point3d groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundDetectionOffset);
        if (!this.groundDevices.isEmpty()) {
            this.solidBox.globalCenter.setTo(this.solidBox.localCenter).rotateCoarse(this.vehicle.angles.copy().add(this.vehicle.rotation)).add(this.vehicle.position).add(vehicleMotionOffset);
            this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, vehicleMotionOffset, false);
            this.isCollided = !this.solidBox.collidingBlocks.isEmpty();
            this.collisionDepth = this.solidBox.currentCollisionDepth.y;
            this.solidBox.globalCenter.add(PartGroundDevice.groundDetectionOffset);
            this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, groundCollisionOffset, false);
            this.solidBox.globalCenter.subtract(PartGroundDevice.groundDetectionOffset);
            this.isGrounded = this.isCollided ? true : !this.solidBox.collidingBlocks.isEmpty();
            this.contactPoint.setTo(this.solidBox.localCenter).add(0.0, -this.solidBox.heightRadius, 0.0);
        }
        if (!this.liquidDevices.isEmpty() || !this.liquidCollisionBoxes.isEmpty()) {
            this.liquidBox.globalCenter.setTo(this.liquidBox.localCenter).rotateCoarse(this.vehicle.angles.copy().add(this.vehicle.rotation)).add(this.vehicle.position).add(vehicleMotionOffset);
            this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, vehicleMotionOffset, false);
            this.isCollidedLiquid = !this.liquidBox.collidingBlocks.isEmpty();
            double liquidCollisionDepth = this.liquidBox.currentCollisionDepth.y;
            this.liquidBox.globalCenter.add(PartGroundDevice.groundDetectionOffset);
            this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, groundCollisionOffset, false);
            this.liquidBox.globalCenter.subtract(PartGroundDevice.groundDetectionOffset);
            boolean bl = this.isCollidedLiquid ? true : (this.isGroundedLiquid = !this.liquidBox.collidingBlocks.isEmpty());
            if (this.isGroundedLiquid && liquidCollisionDepth >= this.collisionDepth) {
                this.isCollided = this.isCollidedLiquid;
                this.isGrounded = this.isGroundedLiquid;
                this.collisionDepth = liquidCollisionDepth;
                this.contactPoint.setTo(this.liquidBox.localCenter).add(0.0, -this.liquidBox.heightRadius, 0.0);
            }
        }
    }

    public boolean isReady() {
        return !this.groundDevices.isEmpty() || !this.liquidDevices.isEmpty();
    }
}

