/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceBox;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;

public class VehicleGroundDeviceCollection {
    private static final double MAX_LINEAR_MOVEMENT_PER_TICK = 0.2;
    private final EntityVehicleF_Physics vehicle;
    private final VehicleGroundDeviceBox frontLeftGDB;
    private final VehicleGroundDeviceBox frontRightGDB;
    private final VehicleGroundDeviceBox rearLeftGDB;
    private final VehicleGroundDeviceBox rearRightGDB;

    public VehicleGroundDeviceCollection(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        this.frontLeftGDB = new VehicleGroundDeviceBox(vehicle, true, true);
        this.frontRightGDB = new VehicleGroundDeviceBox(vehicle, true, false);
        this.rearLeftGDB = new VehicleGroundDeviceBox(vehicle, false, true);
        this.rearRightGDB = new VehicleGroundDeviceBox(vehicle, false, false);
    }

    public void updateMembers() {
        this.frontLeftGDB.updateMembers();
        this.frontRightGDB.updateMembers();
        this.rearLeftGDB.updateMembers();
        this.rearRightGDB.updateMembers();
    }

    public void updateBounds() {
        this.frontLeftGDB.updateBounds();
        this.frontRightGDB.updateBounds();
        this.rearLeftGDB.updateBounds();
        this.rearRightGDB.updateBounds();
    }

    public void updateCollisions() {
        this.frontLeftGDB.updateCollisionStatuses();
        this.frontRightGDB.updateCollisionStatuses();
        this.rearLeftGDB.updateCollisionStatuses();
        this.rearRightGDB.updateCollisionStatuses();
    }

    public double getMaxCollisionDepth() {
        return Math.max(Math.max(Math.max(this.frontLeftGDB.collisionDepth, this.frontRightGDB.collisionDepth), this.rearLeftGDB.collisionDepth), this.rearRightGDB.collisionDepth);
    }

    public int getBoxesInLiquid() {
        int boxes = 0;
        if (this.frontLeftGDB.isCollidedLiquid || this.frontLeftGDB.isGroundedLiquid) {
            ++boxes;
        }
        if (this.frontRightGDB.isCollidedLiquid || this.frontRightGDB.isGroundedLiquid) {
            ++boxes;
        }
        if (this.rearLeftGDB.isCollidedLiquid || this.rearLeftGDB.isGroundedLiquid) {
            ++boxes;
        }
        if (this.rearRightGDB.isCollidedLiquid || this.rearRightGDB.isGroundedLiquid) {
            ++boxes;
        }
        return boxes;
    }

    public boolean isReady() {
        boolean haveFrontPoint = false;
        boolean haveRearPoint = false;
        boolean haveCenterPoint = false;
        if (this.frontLeftGDB.isReady()) {
            haveFrontPoint = true;
            boolean bl = haveCenterPoint = this.frontLeftGDB.contactPoint.x == 0.0;
        }
        if (this.frontRightGDB.isReady()) {
            if (haveFrontPoint) {
                haveCenterPoint = true;
            } else {
                haveFrontPoint = true;
            }
            if (!haveCenterPoint) {
                boolean bl = haveCenterPoint = this.frontRightGDB.contactPoint.x == 0.0;
            }
        }
        if (haveFrontPoint) {
            if (this.rearLeftGDB.isReady()) {
                haveRearPoint = true;
                boolean bl = haveCenterPoint = this.rearLeftGDB.contactPoint.x == 0.0;
            }
            if (this.rearRightGDB.isReady()) {
                if (haveRearPoint) {
                    haveCenterPoint = true;
                } else {
                    haveRearPoint = true;
                }
                if (!haveCenterPoint) {
                    haveCenterPoint = this.rearRightGDB.contactPoint.x == 0.0;
                }
            }
        }
        return haveFrontPoint && haveRearPoint && haveCenterPoint;
    }

    public double performPitchCorrection(double groundBoost) {
        double side1Delta = 0.0;
        double side2Delta = 0.0;
        double groundedSideOffset = 0.0;
        VehicleGroundDeviceBox testBox1 = null;
        VehicleGroundDeviceBox testBox2 = null;
        if (this.vehicle.towedByVehicle == null) {
            if ((this.rearLeftGDB.isGrounded || this.rearRightGDB.isGrounded) && !this.frontLeftGDB.isGrounded && !this.frontRightGDB.isGrounded) {
                side1Delta = Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z);
                side2Delta = Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z);
                groundedSideOffset = this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded ? -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z) : (!this.rearLeftGDB.isGrounded && this.rearRightGDB.isGrounded ? -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z) : -Math.max(Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z), Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z)));
                testBox1 = this.frontLeftGDB;
                testBox2 = this.frontRightGDB;
            }
            if ((this.frontLeftGDB.isGrounded || this.frontRightGDB.isGrounded) && !this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded) {
                side1Delta = -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z);
                side2Delta = -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z);
                groundedSideOffset = this.frontLeftGDB.isGrounded && !this.rearRightGDB.isGrounded ? Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z) : (!this.frontLeftGDB.isGrounded && this.frontRightGDB.isGrounded ? Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z) : Math.max(Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.z), Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.z)));
                testBox1 = this.rearLeftGDB;
                testBox2 = this.rearRightGDB;
            }
        } else if (!this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded) {
            side1Delta = -Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.z);
            side2Delta = -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.z);
            groundedSideOffset = Math.hypot(this.vehicle.definition.motorized.hookupPos.y, this.vehicle.definition.motorized.hookupPos.z);
            testBox1 = this.rearLeftGDB;
            testBox2 = this.rearRightGDB;
        }
        if (((side1Delta -= groundedSideOffset) != 0.0 || (side2Delta -= groundedSideOffset) != 0.0) && testBox1.isReady() && testBox2.isReady()) {
            double testRotation = Math.toDegrees(Math.asin(Math.min(0.2 / Math.max(side1Delta, side2Delta), 1.0)));
            if ((this.vehicle.motion.y - groundBoost * this.vehicle.SPEED_FACTOR <= 0.0 || testRotation * this.vehicle.rotation.x >= 0.0) && Math.abs(this.vehicle.angles.x + testRotation) < 85.0) {
                double intialLinearMovement = Math.sin(Math.toRadians(testRotation)) * groundedSideOffset;
                this.vehicle.rotation.x += testRotation;
                this.vehicle.motion.y += intialLinearMovement;
                testBox1.updateCollisionStatuses();
                testBox2.updateCollisionStatuses();
                double angularCorrection = 0.0;
                double linearCorrection = 0.0;
                if (testBox1.collisionDepth > 0.0) {
                    angularCorrection = Math.toDegrees(Math.asin(testBox1.collisionDepth / side1Delta));
                }
                if (testBox2.collisionDepth > 0.0) {
                    double angularCorrection2 = Math.toDegrees(Math.asin(testBox2.collisionDepth / side2Delta));
                    if (angularCorrection > 0.0 ? angularCorrection2 > angularCorrection : angularCorrection2 < angularCorrection) {
                        angularCorrection = angularCorrection2;
                    }
                }
                if (Math.abs(angularCorrection) > Math.abs(testRotation) || Double.isNaN(angularCorrection)) {
                    this.vehicle.rotation.x -= testRotation;
                    this.vehicle.motion.y -= intialLinearMovement;
                    return 0.0;
                }
                linearCorrection = -intialLinearMovement * (angularCorrection / testRotation);
                this.vehicle.rotation.x -= angularCorrection;
                this.vehicle.motion.y += linearCorrection;
                this.updateCollisions();
                return intialLinearMovement + linearCorrection;
            }
        }
        return 0.0;
    }

    public double performRollCorrection(double groundBoost) {
        double side1Delta = 0.0;
        double side2Delta = 0.0;
        double groundedSideOffset = 0.0;
        VehicleGroundDeviceBox testBox1 = null;
        VehicleGroundDeviceBox testBox2 = null;
        if ((this.rearRightGDB.isGrounded || this.frontRightGDB.isGrounded) && !this.rearLeftGDB.isGrounded && !this.frontLeftGDB.isGrounded) {
            side1Delta = Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.x);
            side2Delta = Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.x);
            groundedSideOffset = this.rearRightGDB.isGrounded && !this.frontRightGDB.isGrounded ? -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.x) : (!this.rearRightGDB.isGrounded && this.frontRightGDB.isGrounded ? -Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.x) : -Math.max(Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.x), Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.x)));
            testBox1 = this.frontLeftGDB;
            testBox2 = this.frontRightGDB;
        }
        if ((this.rearLeftGDB.isGrounded || this.frontLeftGDB.isGrounded) && !this.rearRightGDB.isGrounded && !this.frontRightGDB.isGrounded) {
            side1Delta = -Math.hypot(this.rearRightGDB.contactPoint.y, this.rearRightGDB.contactPoint.x);
            side2Delta = -Math.hypot(this.frontRightGDB.contactPoint.y, this.frontRightGDB.contactPoint.x);
            groundedSideOffset = this.rearLeftGDB.isGrounded && !this.frontRightGDB.isGrounded ? Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.x) : (!this.rearLeftGDB.isGrounded && this.frontLeftGDB.isGrounded ? Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.x) : Math.max(Math.hypot(this.rearLeftGDB.contactPoint.y, this.rearLeftGDB.contactPoint.x), Math.hypot(this.frontLeftGDB.contactPoint.y, this.frontLeftGDB.contactPoint.x)));
            testBox1 = this.rearLeftGDB;
            testBox2 = this.rearRightGDB;
        }
        if (((side1Delta -= groundedSideOffset) != 0.0 || (side2Delta -= groundedSideOffset) != 0.0) && testBox1.isReady() && testBox2.isReady()) {
            double testRotation = -Math.toDegrees(Math.asin(Math.min(0.2 / Math.max(side1Delta, side2Delta), 1.0)));
            if (this.vehicle.motion.y - groundBoost * this.vehicle.SPEED_FACTOR <= 0.0 || testRotation * this.vehicle.rotation.z >= 0.0) {
                double intialLinearMovement = -Math.sin(Math.toRadians(testRotation)) * groundedSideOffset;
                this.vehicle.rotation.z += testRotation;
                this.vehicle.motion.y += intialLinearMovement;
                testBox1.updateCollisionStatuses();
                testBox2.updateCollisionStatuses();
                double angularCorrection = 0.0;
                double linearCorrection = 0.0;
                if (testBox1.collisionDepth > 0.0) {
                    angularCorrection = Math.toDegrees(Math.asin(testBox1.collisionDepth / side1Delta));
                }
                if (testBox2.collisionDepth > 0.0) {
                    double angularCorrection2 = Math.toDegrees(Math.asin(testBox2.collisionDepth / side2Delta));
                    if (angularCorrection > 0.0 ? angularCorrection2 > angularCorrection : angularCorrection2 < angularCorrection) {
                        angularCorrection = angularCorrection2;
                    }
                }
                if (Math.abs(angularCorrection) > Math.abs(testRotation) || Double.isNaN(angularCorrection)) {
                    this.vehicle.rotation.z -= testRotation;
                    this.vehicle.motion.y -= intialLinearMovement;
                    return 0.0;
                }
                linearCorrection = -intialLinearMovement * (-angularCorrection / testRotation);
                this.vehicle.rotation.z += angularCorrection;
                this.vehicle.motion.y += linearCorrection;
                this.updateCollisions();
                return intialLinearMovement + linearCorrection;
            }
        }
        return 0.0;
    }
}

