/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.components;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;

public abstract class ABlockBase {
    public final float hardness;
    public final float blastResistance;
    protected static final BoundingBox SINGLE_BLOCK_BOUNDS = new BoundingBox(new Point3d(0.0, 0.0, 0.0), 0.5, 0.5, 0.5);

    public ABlockBase(float hardness, float blastResistance) {
        this.hardness = hardness;
        this.blastResistance = blastResistance;
    }

    public void onPlaced(IWrapperWorld world, Point3i location, IWrapperPlayer player) {
    }

    public boolean onClicked(IWrapperWorld world, Point3i location, Axis axis, IWrapperPlayer player) {
        return false;
    }

    public float getRotation(IWrapperWorld world, Point3i location) {
        return world.getBlockRotation(location);
    }

    public void addCollisionBoxes(IWrapperWorld world, Point3i location, List<BoundingBox> collidingBoxes) {
        collidingBoxes.add(SINGLE_BLOCK_BOUNDS);
    }

    public static enum Axis {
        NONE(0, 0, 0, 0),
        UP(0, 1, 0, 0),
        DOWN(0, -1, 0, 0),
        NORTH(0, 0, -1, 180),
        SOUTH(0, 0, 1, 0),
        EAST(1, 0, 0, 90),
        WEST(-1, 0, 0, 270);

        public final int xOffset;
        public final int yOffset;
        public final int zOffset;
        public final int yRotation;

        private Axis(int xOffset, int yOffset, int zOffset, int yRotation) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            this.yRotation = yRotation;
        }

        public Point3i getOffsetPoint(Point3i point) {
            return point.copy().add(this.xOffset, this.yOffset, this.zOffset);
        }

        public Axis getOpposite() {
            switch (this) {
                case UP: {
                    return DOWN;
                }
                case DOWN: {
                    return UP;
                }
                case NORTH: {
                    return SOUTH;
                }
                case SOUTH: {
                    return NORTH;
                }
                case EAST: {
                    return WEST;
                }
                case WEST: {
                    return EAST;
                }
            }
            return NONE;
        }
    }
}

