/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.instances;

import minecrafttransportsimulator.baseclasses.FluidTank;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.IBlockTileEntity;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFuelPump;
import minecrafttransportsimulator.items.instances.ItemJerrycan;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.AEntityBase;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Physics;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartEngine;

public class BlockFuelPump
extends ABlockBase
implements IBlockTileEntity<TileEntityFuelPump> {
    public BlockFuelPump() {
        super(10.0f, 5.0f);
    }

    @Override
    public boolean onClicked(IWrapperWorld world, Point3i point, ABlockBase.Axis axis, IWrapperPlayer player) {
        if (!world.isClient()) {
            TileEntityFuelPump pump = (TileEntityFuelPump)world.getTileEntity(point);
            FluidTank tank = pump.getTank();
            IWrapperItemStack stack = player.getHeldStack();
            if (stack.interactWithTank(tank, player) > 0.0) {
                return true;
            }
            if (stack.getItem() instanceof ItemJerrycan) {
                IWrapperNBT data = stack.getData();
                if (!data.getBoolean("isFull") && tank.getFluidLevel() >= 1000.0) {
                    data.setBoolean("isFull", true);
                    data.setString("fluidName", tank.getFluid());
                    stack.setData(data);
                    tank.drain(tank.getFluid(), 1000.0, true);
                }
                return true;
            }
            if (pump.connectedVehicle == null) {
                EntityVehicleF_Physics nearestVehicle = null;
                double lowestDistance = 16.0;
                for (AEntityBase entity : AEntityBase.createdServerEntities) {
                    double entityDistance;
                    if (!(entity instanceof EntityVehicleF_Physics) || !((entityDistance = entity.position.distanceTo(point)) < lowestDistance)) continue;
                    lowestDistance = entityDistance;
                    nearestVehicle = (EntityVehicleF_Physics)entity;
                }
                if (nearestVehicle != null) {
                    if (tank.getFluidLevel() == 0.0) {
                        player.sendPacket(new PacketPlayerChatMessage("interact.fuelpump.nofuel"));
                    } else {
                        if (!nearestVehicle.fuelTank.getFluid().isEmpty() && !tank.getFluid().equals(nearestVehicle.fuelTank.getFluid())) {
                            player.sendPacket(new PacketPlayerChatMessage("interact.fuelpump.wrongtype"));
                            return true;
                        }
                        for (APart part : nearestVehicle.parts) {
                            if (!(part instanceof PartEngine) || !ConfigSystem.configObject.fuel.fuels.get(part.definition.engine.fuelType).containsKey(tank.getFluid())) continue;
                            pump.connectedVehicle = nearestVehicle;
                            pump.connectedVehicle.beingFueled = true;
                            tank.resetAmountDispensed();
                            MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(pump, true));
                            player.sendPacket(new PacketPlayerChatMessage("interact.fuelpump.connect"));
                            return true;
                        }
                        player.sendPacket(new PacketPlayerChatMessage("interact.fuelpump.wrongengines"));
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage("interact.fuelpump.toofar"));
                }
            } else {
                MasterLoader.networkInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(pump, false));
                pump.connectedVehicle.beingFueled = false;
                pump.connectedVehicle = null;
                player.sendPacket(new PacketPlayerChatMessage("interact.fuelpump.disconnect"));
            }
        }
        return true;
    }

    @Override
    public TileEntityFuelPump createTileEntity(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        return new TileEntityFuelPump(world, position, data);
    }

    @Override
    public Class<TileEntityFuelPump> getTileEntityClass() {
        return TileEntityFuelPump.class;
    }
}

