/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.instances;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3d;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.IBlockTileEntity;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemPole;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.items.instances.ItemWrench;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.mcinterface.MasterLoader;
import minecrafttransportsimulator.packets.instances.PacketTileEntityPoleChange;

public class BlockPole
extends ABlockBase
implements IBlockTileEntity<TileEntityPole> {
    private final Map<ABlockBase.Axis, BoundingBox> axisBounds = new HashMap<ABlockBase.Axis, BoundingBox>();

    public BlockPole() {
        super(10.0f, 5.0f);
        double connectorRadius = 0.125;
        double axialRadius = (0.5 - connectorRadius) / 2.0;
        double axialCenterPoint = 0.5 - axialRadius;
        this.axisBounds.put(ABlockBase.Axis.NONE, new BoundingBox(new Point3d(0.0, 0.0, 0.0), connectorRadius, connectorRadius, connectorRadius));
        this.axisBounds.put(ABlockBase.Axis.UP, new BoundingBox(new Point3d(0.0, axialCenterPoint, 0.0), connectorRadius, axialRadius, connectorRadius));
        this.axisBounds.put(ABlockBase.Axis.DOWN, new BoundingBox(new Point3d(0.0, -axialCenterPoint, 0.0), connectorRadius, axialRadius, connectorRadius));
        this.axisBounds.put(ABlockBase.Axis.NORTH, new BoundingBox(new Point3d(0.0, 0.0, -axialCenterPoint), connectorRadius, connectorRadius, axialRadius));
        this.axisBounds.put(ABlockBase.Axis.SOUTH, new BoundingBox(new Point3d(0.0, 0.0, axialCenterPoint), connectorRadius, connectorRadius, axialRadius));
        this.axisBounds.put(ABlockBase.Axis.EAST, new BoundingBox(new Point3d(axialCenterPoint, 0.0, 0.0), axialRadius, connectorRadius, connectorRadius));
        this.axisBounds.put(ABlockBase.Axis.WEST, new BoundingBox(new Point3d(-axialCenterPoint, 0.0, 0.0), axialRadius, connectorRadius, connectorRadius));
    }

    @Override
    public void onPlaced(IWrapperWorld world, Point3i location, IWrapperPlayer player) {
        IWrapperNBT data = player.getHeldStack().getData();
        if (data.getString("packID").isEmpty()) {
            TileEntityPole pole = (TileEntityPole)world.getTileEntity(location);
            pole.components.put(ABlockBase.Axis.NONE, TileEntityPole.createComponent((ItemPoleComponent)player.getHeldItem()));
        }
    }

    @Override
    public boolean onClicked(IWrapperWorld world, Point3i location, ABlockBase.Axis axis, IWrapperPlayer player) {
        TileEntityPole pole = (TileEntityPole)world.getTileEntity(location);
        if (pole != null) {
            boolean isPlayerHoldingComponent;
            IWrapperItemStack heldStack = player.getHeldStack();
            AItemBase heldItem = heldStack.getItem();
            boolean isPlayerHoldingWrench = heldItem instanceof ItemWrench;
            boolean isPlayerClickingEditableSign = pole.components.get((Object)axis) instanceof TileEntityPole_Sign && ((JSONPoleComponent.PoleGeneral)pole.components.get((Object)((Object)axis)).definition.general).textObjects != null;
            boolean bl = isPlayerHoldingComponent = heldItem instanceof ItemPoleComponent && !(heldItem instanceof ItemPole);
            if (world.isClient()) {
                if (isPlayerHoldingWrench) {
                    MasterLoader.networkInterface.sendToServer(new PacketTileEntityPoleChange(pole, axis, null, null, true));
                } else if (isPlayerClickingEditableSign) {
                    MasterLoader.networkInterface.sendToServer(new PacketTileEntityPoleChange(pole, axis, null, null, false));
                } else if (isPlayerHoldingComponent) {
                    List<String> textLines = null;
                    ItemPoleComponent component = (ItemPoleComponent)heldItem;
                    if (((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)component.definition).general).textObjects != null) {
                        textLines = heldStack.getData().getStrings("textLines", ((JSONPoleComponent.PoleGeneral)((JSONPoleComponent)component.definition).general).textObjects.size());
                    }
                    MasterLoader.networkInterface.sendToServer(new PacketTileEntityPoleChange(pole, axis, component, textLines, false));
                } else {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void addCollisionBoxes(IWrapperWorld world, Point3i location, List<BoundingBox> collidingBoxes) {
        TileEntityPole pole = (TileEntityPole)world.getTileEntity(location);
        if (pole != null) {
            for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                if (!(world.getBlock(axis.getOffsetPoint(location)) instanceof BlockPole) && !world.isBlockSolid(axis.getOffsetPoint(location)) && !pole.components.containsKey((Object)axis)) continue;
                collidingBoxes.add(this.axisBounds.get((Object)axis));
            }
        } else {
            super.addCollisionBoxes(world, location, collidingBoxes);
        }
    }

    @Override
    public TileEntityPole createTileEntity(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        return new TileEntityPole(world, position, data);
    }

    @Override
    public Class<TileEntityPole> getTileEntityClass() {
        return TileEntityPole.class;
    }
}

