/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3i;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperWorld;
import minecrafttransportsimulator.rendering.instances.ARenderTileEntityBase;
import minecrafttransportsimulator.systems.PackParserSystem;

public abstract class ATileEntityBase<JSONDefinition extends AJSONItem<?>> {
    public final IWrapperWorld world;
    public final Point3i position;
    public final AItemPack<JSONDefinition> item;
    public final JSONDefinition definition;
    public float lightLevel;

    public ATileEntityBase(IWrapperWorld world, Point3i position, IWrapperNBT data) {
        this.world = world;
        this.position = position;
        this.item = PackParserSystem.getItem(data.getString("packID"), data.getString("systemName"));
        this.definition = this.item.definition;
        this.lightLevel = (float)data.getDouble("lightLevel");
    }

    public ABlockBase getBlock() {
        return this.world.getBlock(this.position);
    }

    public List<AItemPack<JSONDefinition>> getDrops() {
        ArrayList<AItemPack<JSONDefinition>> drops = new ArrayList<AItemPack<JSONDefinition>>();
        if (this.definition != null) {
            drops.add(this.item);
        }
        return drops;
    }

    public void remove() {
    }

    public void save(IWrapperNBT data) {
        data.setString("packID", ((AJSONItem)this.definition).packID);
        data.setString("systemName", ((AJSONItem)this.definition).systemName);
        data.setDouble("lightLevel", this.lightLevel);
    }

    public abstract ARenderTileEntityBase<? extends ATileEntityBase<JSONDefinition>> getRenderer();
}

